/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Identifiable;

public final class FileGeneratorArg
implements Identifiable<String> {
    @Parameter
    private final Map<String, String> configuration = new HashMap<String, String>();
    @Parameter(required=true)
    private String identifier;

    public FileGeneratorArg() {
    }

    public FileGeneratorArg(String identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public FileGeneratorArg(String identifier, Map<String, String> configuration) {
        this(identifier);
        this.configuration.putAll(configuration);
    }

    public String getIdentifier() {
        return (String)Verify.verifyNotNull((Object)this.identifier);
    }

    public @NonNull Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.identifier).add("configuration", this.configuration).toString();
    }
}

