/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.plugin.generator.api.FileGenerator;
import org.opendaylight.yangtools.plugin.generator.api.FileGeneratorException;
import org.opendaylight.yangtools.plugin.generator.api.GeneratedFile;
import org.opendaylight.yangtools.plugin.generator.api.GeneratedFilePath;
import org.opendaylight.yangtools.plugin.generator.api.GeneratedFileType;
import org.opendaylight.yangtools.plugin.generator.api.ModuleResourceResolver;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang2sources.plugin.ContextHolder;
import org.opendaylight.yangtools.yang2sources.plugin.GeneratorTaskFactory;
import org.opendaylight.yangtools.yang2sources.plugin.ParserConfigAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

final class GeneratorTask
extends ParserConfigAware {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorTask.class);
    private final Map<GeneratedFileType, File> persistentDirs = new HashMap<GeneratedFileType, File>(4);
    private final Map<GeneratedFileType, File> transientDirs = new HashMap<GeneratedFileType, File>(4);
    private final GeneratorTaskFactory factory;
    private final ContextHolder contextHolder;
    private final MavenProject project;
    private final File buildDir;
    private final String suffix;

    GeneratorTask(@NonNull GeneratorTaskFactory factory, @NonNull ContextHolder contextHolder, MavenProject project) {
        this.factory = Objects.requireNonNull(factory);
        this.contextHolder = Objects.requireNonNull(contextHolder);
        this.project = Objects.requireNonNull(project);
        this.buildDir = new File(project.getBuild().getDirectory());
        this.suffix = factory.getIdentifier();
    }

    @Override
    YangParserConfiguration parserConfig() {
        return this.factory.parserConfig();
    }

    Collection<File> execute(BuildContext buildContext) throws FileGeneratorException, IOException {
        Stopwatch sw = Stopwatch.createStarted();
        FileGenerator gen = this.factory.generator();
        Table generatedFiles = gen.generateFiles(this.contextHolder.getContext(), this.contextHolder.getYangModules(), (ModuleResourceResolver)this.contextHolder);
        LOG.info("{}: Defined {} files in {}", new Object[]{this.suffix, generatedFiles.size(), sw});
        sw.reset().start();
        ListMultimap dirs = MultimapBuilder.hashKeys().arrayListValues().build();
        block4: for (Table.Cell cell : generatedFiles.cellSet()) {
            File target;
            GeneratedFile file = (GeneratedFile)cell.getValue();
            String relativePath = ((GeneratedFilePath)cell.getColumnKey()).getPath();
            switch (file.getLifecycle()) {
                case PERSISTENT: {
                    target = new File(this.persistentPath((GeneratedFileType)cell.getRowKey()), relativePath);
                    if (!target.exists()) break;
                    LOG.debug("Skipping existing persistent {}", (Object)target);
                    continue block4;
                }
                case TRANSIENT: {
                    target = new File(this.transientPath((GeneratedFileType)cell.getRowKey()), relativePath);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported file type in " + file);
                }
            }
            dirs.put((Object)target.getParentFile(), (Object)new WriteTask(buildContext, target, (GeneratedFile)cell.getValue()));
        }
        LOG.info("Sorted {} files into {} directories in {}", new Object[]{dirs.size(), dirs.keySet().size(), sw});
        sw.reset().start();
        dirs.keySet().parallelStream().forEach(path -> {
            try {
                Files.createDirectories(path.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create " + path, e);
            }
        });
        LOG.debug("Parent directories created in {}", (Object)sw);
        sw.reset().start();
        List<File> result = dirs.values().parallelStream().map(WriteTask::generateFile).collect(Collectors.toList());
        LOG.debug("Generated {} files in {}", (Object)result.size(), (Object)sw);
        return result;
    }

    private File persistentPath(GeneratedFileType fileType) throws FileGeneratorException {
        File existing = this.persistentDirs.get(fileType);
        if (existing != null) {
            return existing;
        }
        File newDir = this.persistentDirectory(fileType);
        Verify.verify((this.persistentDirs.put(fileType, newDir) == null ? 1 : 0) != 0);
        return newDir;
    }

    private File transientPath(GeneratedFileType fileType) throws FileGeneratorException {
        File existing = this.transientDirs.get(fileType);
        if (existing != null) {
            return existing;
        }
        File newDir = this.transientDirectory(fileType);
        Verify.verify((this.transientDirs.put(fileType, newDir) == null ? 1 : 0) != 0);
        return newDir;
    }

    private File persistentDirectory(GeneratedFileType fileType) throws FileGeneratorException {
        File ret;
        if (GeneratedFileType.SOURCE.equals((Object)fileType)) {
            ret = new File(this.project.getBuild().getSourceDirectory());
        } else if (GeneratedFileType.RESOURCE.equals((Object)fileType)) {
            ret = new File(new File(this.project.getBuild().getSourceDirectory()).getParentFile(), "resources");
        } else {
            throw new FileGeneratorException("Unknown generated file type " + fileType);
        }
        return ret;
    }

    private File transientDirectory(GeneratedFileType fileType) throws FileGeneratorException {
        File ret;
        if (GeneratedFileType.SOURCE.equals((Object)fileType)) {
            ret = this.transientDirectory("generated-sources");
            this.project.addCompileSourceRoot(ret.toString());
        } else if (GeneratedFileType.RESOURCE.equals((Object)fileType)) {
            ret = this.transientDirectory("generated-resources");
            this.project.addResource(GeneratorTask.createResouce(ret));
        } else {
            throw new FileGeneratorException("Unknown generated file type " + fileType);
        }
        return ret;
    }

    private File transientDirectory(String component) {
        return new File(this.buildDir, this.subdirFileName(component));
    }

    private String subdirFileName(String component) {
        return component + File.separatorChar + this.suffix;
    }

    private static Resource createResouce(File directory) {
        Resource ret = new Resource();
        ret.setDirectory(directory.toString());
        return ret;
    }

    private static final class WriteTask {
        private final BuildContext buildContext;
        private final GeneratedFile file;
        private final File target;

        WriteTask(BuildContext buildContext, File target, GeneratedFile file) {
            this.buildContext = Objects.requireNonNull(buildContext);
            this.target = Objects.requireNonNull(target);
            this.file = Objects.requireNonNull(file);
        }

        File generateFile() {
            try (OutputStream stream = this.buildContext.newFileOutputStream(this.target);){
                this.file.writeBody(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to generate file " + this.target, e);
            }
            return this.target;
        }
    }
}

