/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.maven.project.MavenProject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.plugin.generator.api.FileGenerator;
import org.opendaylight.yangtools.plugin.generator.api.FileGeneratorException;
import org.opendaylight.yangtools.plugin.generator.api.FileGeneratorFactory;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang2sources.plugin.ContextHolder;
import org.opendaylight.yangtools.yang2sources.plugin.FileGeneratorArg;
import org.opendaylight.yangtools.yang2sources.plugin.GeneratorTask;
import org.opendaylight.yangtools.yang2sources.plugin.ParserConfigAware;

@NonNullByDefault
final class GeneratorTaskFactory
extends ParserConfigAware
implements Identifiable<String> {
    private final YangParserConfiguration parserConfig;
    private final FileGeneratorArg arg;
    private final FileGenerator gen;

    private GeneratorTaskFactory(FileGenerator gen, FileGeneratorArg arg) {
        this.gen = Objects.requireNonNull(gen);
        this.arg = Objects.requireNonNull(arg);
        switch (gen.importResolutionMode()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case REVISION_EXACT_OR_LATEST: 
        }
        this.parserConfig = YangParserConfiguration.DEFAULT;
    }

    static GeneratorTaskFactory of(FileGeneratorFactory factory, FileGeneratorArg arg) throws FileGeneratorException {
        return new GeneratorTaskFactory(factory.newFileGenerator(arg.getConfiguration()), arg);
    }

    public String getIdentifier() {
        return this.arg.getIdentifier();
    }

    @Override
    YangParserConfiguration parserConfig() {
        return this.parserConfig;
    }

    FileGenerator generator() {
        return this.gen;
    }

    String generatorName() {
        return this.gen.getClass().getName();
    }

    GeneratorTask createTask(MavenProject project, ContextHolder context) {
        return new GeneratorTask(this, context, project);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generator", (Object)this.generatorName()).add("argument", (Object)this.arg).toString();
    }
}

