/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    static List<File> getClassPath(MavenProject project) {
        ArrayList<File> dependencies = new ArrayList<File>();
        for (org.apache.maven.artifact.Artifact element : project.getArtifacts()) {
            File asFile = element.getFile();
            if (!Util.isJar(asFile) && !asFile.isDirectory()) continue;
            dependencies.add(asFile);
        }
        return dependencies;
    }

    static void checkClasspath(MavenProject project, RepositorySystem repoSystem, RepositorySystemSession repoSession) {
        Plugin plugin = project.getPlugin("org.opendaylight.yangtools:yang-maven-plugin");
        if (plugin == null) {
            LOG.warn("{} {} not found, dependencies version check skipped", (Object)"yang-to-sources:", (Object)"org.opendaylight.yangtools:yang-maven-plugin");
            return;
        }
        List remoteRepos = RepositoryUtils.toRepos((List)project.getRemoteArtifactRepositories());
        HashMap pluginDeps = new HashMap();
        for (Dependency mavenDep : plugin.getDependencies()) {
            DependencyResult result;
            org.eclipse.aether.graph.Dependency aetherDep = RepositoryUtils.toDependency((Dependency)mavenDep, (ArtifactTypeRegistry)repoSession.getArtifactTypeRegistry());
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(aetherDep);
            collectRequest.setRepositories(remoteRepos);
            DependencyRequest request = new DependencyRequest(collectRequest, null);
            try {
                result = repoSystem.resolveDependencies(repoSession, request);
            }
            catch (DependencyResolutionException e) {
                throw new IllegalStateException(e);
            }
            pluginDeps.put(aetherDep.getArtifact(), result.getArtifactResults().stream().map(ArtifactResult::getArtifact).collect(Collectors.toSet()));
        }
        Collection projectDependencies = RepositoryUtils.toArtifacts((Collection)project.getDependencyArtifacts());
        for (Map.Entry entry : pluginDeps.entrySet()) {
            Util.checkArtifact((Artifact)entry.getKey(), projectDependencies);
            for (Artifact dependency : (Set)entry.getValue()) {
                Util.checkArtifact(dependency, projectDependencies);
            }
        }
    }

    private static void checkArtifact(Artifact artifact, Collection<Artifact> dependencies) {
        for (Artifact d : dependencies) {
            if (!artifact.getGroupId().equals(d.getGroupId()) || !artifact.getArtifactId().equals(d.getArtifactId()) || artifact.getVersion().equals(d.getVersion())) continue;
            LOG.warn("{} Dependency resolution conflict:", (Object)"yang-to-sources:");
            LOG.warn("{} '{}' dependency [{}] has different version than one declared in current project [{}]. It is recommended to fix this problem because it may cause compilation errors.", new Object[]{"yang-to-sources:", "org.opendaylight.yangtools:yang-maven-plugin", artifact, d});
        }
    }

    private static boolean isJar(File element) {
        return element.isFile() && element.getName().endsWith(".jar");
    }

    static SourceIdentifier moduleToIdentifier(ModuleLike module) {
        return new SourceIdentifier(UnresolvedQName.Unqualified.of((String)module.getName()), (Revision)module.getRevision().orElse(null));
    }
}

