/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.opendaylight.yangtools.yang2sources.plugin.FileGeneratorArg;
import org.opendaylight.yangtools.yang2sources.plugin.Util;
import org.opendaylight.yangtools.yang2sources.plugin.YangToSourcesProcessor;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true)
public final class YangToSourcesMojo
extends AbstractMojo {
    public static final String PLUGIN_NAME = "org.opendaylight.yangtools:yang-maven-plugin";
    @Parameter(required=false)
    private FileGeneratorArg[] fileGenerators;
    @Parameter(required=false)
    private String yangFilesRootDir;
    @Parameter(required=false)
    private String[] excludeFiles;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="inspectDependencies")
    private boolean inspectDependencies;
    @Parameter(property="yang.skip")
    private String yangSkip;
    @Component
    @VisibleForTesting
    BuildContext buildContext;
    private YangToSourcesProcessor yangToSourcesProcessor;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(readonly=true, defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repoSession;

    public YangToSourcesMojo() {
    }

    @VisibleForTesting
    YangToSourcesMojo(YangToSourcesProcessor processor) {
        this.yangToSourcesProcessor = processor;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="yangFilesRootDir")
    public void execute() throws MojoExecutionException, MojoFailureException {
        Util.checkClasspath(this.project, this.repoSystem, this.repoSession);
        if (this.yangToSourcesProcessor == null) {
            File yangFilesRootFile = YangToSourcesMojo.processYangFilesRootDir(this.yangFilesRootDir, this.project.getBasedir());
            Collection<File> excludedFiles = YangToSourcesMojo.processExcludeFiles(this.excludeFiles, yangFilesRootFile);
            this.yangToSourcesProcessor = new YangToSourcesProcessor(this.buildContext, yangFilesRootFile, excludedFiles, YangToSourcesMojo.arrayToList(this.fileGenerators), this.project, this.inspectDependencies);
        }
        this.yangToSourcesProcessor.conditionalExecute("true".equals(this.yangSkip));
    }

    private static <T> List<T> arrayToList(T[] array) {
        return array == null ? ImmutableList.of() : Arrays.asList(array);
    }

    private static File processYangFilesRootDir(String yangFilesRootDir, File baseDir) {
        File file;
        File yangFilesRootFile = yangFilesRootDir == null ? new File(baseDir, "src" + File.separator + "main" + File.separator + "yang") : ((file = new File(yangFilesRootDir)).isAbsolute() ? file : new File(baseDir, file.getPath()));
        return yangFilesRootFile;
    }

    private static Collection<File> processExcludeFiles(String[] excludeFiles, File baseDir) {
        if (excludeFiles == null) {
            return ImmutableList.of();
        }
        return Collections2.transform(Arrays.asList(excludeFiles), f -> new File(baseDir, (String)f));
    }
}

