/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.project.MavenProject;
import org.opendaylight.yangtools.yang2sources.plugin.GeneratedDirectories;

public abstract class ConfigArg {
    private final File outputBaseDir;

    public ConfigArg(String outputBaseDir) {
        this.outputBaseDir = outputBaseDir == null ? null : new File(outputBaseDir);
    }

    public File getOutputBaseDir(MavenProject project) {
        if (this.outputBaseDir == null) {
            return null;
        }
        return this.outputBaseDir.isAbsolute() ? this.outputBaseDir : new File(project.getBasedir(), this.outputBaseDir.getPath());
    }

    public abstract void check();

    public static final class CodeGeneratorArg
    extends ConfigArg {
        private final Map<String, String> additionalConfiguration = new HashMap<String, String>();
        private String codeGeneratorClass;
        private File resourceBaseDir;

        public CodeGeneratorArg() {
            super(null);
        }

        public CodeGeneratorArg(String codeGeneratorClass) {
            this(codeGeneratorClass, null);
        }

        public CodeGeneratorArg(String codeGeneratorClass, String outputBaseDir) {
            super(outputBaseDir);
            this.codeGeneratorClass = codeGeneratorClass;
        }

        public CodeGeneratorArg(String codeGeneratorClass, String outputBaseDir, String resourceBaseDir) {
            super(outputBaseDir);
            this.codeGeneratorClass = codeGeneratorClass;
            this.resourceBaseDir = new File(resourceBaseDir);
        }

        @Override
        public void check() {
            Objects.requireNonNull(this.codeGeneratorClass, "codeGeneratorClass for CodeGenerator cannot be null");
        }

        public String getCodeGeneratorClass() {
            return this.codeGeneratorClass;
        }

        public File getResourceBaseDir(MavenProject project) {
            if (this.resourceBaseDir == null) {
                return new GeneratedDirectories(project).getYangServicesDir();
            }
            return this.resourceBaseDir.isAbsolute() ? this.resourceBaseDir : new File(project.getBasedir(), this.resourceBaseDir.getPath());
        }

        public Map<String, String> getAdditionalConfiguration() {
            return this.additionalConfiguration;
        }
    }
}

