/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.opendaylight.yangtools.yang.model.parser.api.YangParser;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ASTSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.TextToASTTransformer;
import org.opendaylight.yangtools.yang2sources.plugin.ConfigArg;
import org.opendaylight.yangtools.yang2sources.plugin.ContextHolder;
import org.opendaylight.yangtools.yang2sources.plugin.GeneratedDirectories;
import org.opendaylight.yangtools.yang2sources.plugin.ProcessorModuleReactor;
import org.opendaylight.yangtools.yang2sources.plugin.ScannedDependency;
import org.opendaylight.yangtools.yang2sources.plugin.YangProvider;
import org.opendaylight.yangtools.yang2sources.spi.BasicCodeGenerator;
import org.opendaylight.yangtools.yang2sources.spi.BuildContextAware;
import org.opendaylight.yangtools.yang2sources.spi.MavenProjectAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

class YangToSourcesProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(YangToSourcesProcessor.class);
    private static final YangParserFactory DEFAULT_PARSER_FACTORY;
    static final String LOG_PREFIX = "yang-to-sources:";
    private static final String META_INF_STR = "META-INF";
    private static final String YANG_STR = "yang";
    static final String META_INF_YANG_STRING;
    static final String META_INF_YANG_STRING_JAR = "META-INF/yang";
    static final String META_INF_YANG_SERVICES_STRING_JAR = "META-INF/services";
    private final YangParserFactory parserFactory;
    private final File yangFilesRootDir;
    private final Set<File> excludedFiles;
    private final List<ConfigArg.CodeGeneratorArg> codeGeneratorArgs;
    private final MavenProject project;
    private final boolean inspectDependencies;
    private final BuildContext buildContext;
    private final YangProvider yangProvider;

    private YangToSourcesProcessor(BuildContext buildContext, File yangFilesRootDir, Collection<File> excludedFiles, List<ConfigArg.CodeGeneratorArg> codeGenerators, MavenProject project, boolean inspectDependencies, YangProvider yangProvider) {
        this.buildContext = Objects.requireNonNull(buildContext, "buildContext");
        this.yangFilesRootDir = Objects.requireNonNull(yangFilesRootDir, "yangFilesRootDir");
        this.excludedFiles = ImmutableSet.copyOf(excludedFiles);
        this.codeGeneratorArgs = ImmutableList.copyOf(codeGenerators);
        this.project = Objects.requireNonNull(project);
        this.inspectDependencies = inspectDependencies;
        this.yangProvider = Objects.requireNonNull(yangProvider);
        this.parserFactory = DEFAULT_PARSER_FACTORY;
    }

    @VisibleForTesting
    YangToSourcesProcessor(File yangFilesRootDir, Collection<File> excludedFiles, List<ConfigArg.CodeGeneratorArg> codeGenerators, MavenProject project, boolean inspectDependencies, YangProvider yangProvider) {
        this((BuildContext)new DefaultBuildContext(), yangFilesRootDir, excludedFiles, codeGenerators, project, inspectDependencies, yangProvider);
    }

    YangToSourcesProcessor(BuildContext buildContext, File yangFilesRootDir, Collection<File> excludedFiles, List<ConfigArg.CodeGeneratorArg> codeGenerators, MavenProject project, boolean inspectDependencies) {
        this(buildContext, yangFilesRootDir, excludedFiles, codeGenerators, project, inspectDependencies, YangProvider.getInstance());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.conditionalExecute(false);
    }

    void conditionalExecute(boolean skip) throws MojoExecutionException, MojoFailureException {
        List<File> yangFilesInProject;
        try {
            yangFilesInProject = YangToSourcesProcessor.listFiles(this.yangFilesRootDir, this.excludedFiles);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to list project files", (Throwable)e);
        }
        if (yangFilesInProject.isEmpty()) {
            LOG.info("{} No input files found", (Object)LOG_PREFIX);
            return;
        }
        List<Map.Entry<ConfigArg.CodeGeneratorArg, BasicCodeGenerator>> codeGenerators = this.instantiateGenerators();
        StatementParserMode importMode = YangToSourcesProcessor.determineRequiredImportMode(codeGenerators);
        Optional<ProcessorModuleReactor> optReactor = this.createReactor(importMode, yangFilesInProject);
        if (!optReactor.isPresent()) {
            return;
        }
        ProcessorModuleReactor reactor = optReactor.get();
        if (!skip) {
            ContextHolder holder;
            Stopwatch watch = Stopwatch.createStarted();
            try {
                holder = reactor.toContext();
            }
            catch (YangParserException e) {
                throw new MojoFailureException("Failed to process reactor " + reactor, (Throwable)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read reactor " + reactor, (Exception)e);
            }
            LOG.info("{} {} YANG models processed in {}", new Object[]{LOG_PREFIX, holder.getContext().getModules().size(), watch});
            this.generateSources(holder, codeGenerators);
        } else {
            LOG.info("{} Skipping YANG code generation because property yang.skip is true", (Object)LOG_PREFIX);
        }
        Collection<YangTextSchemaSource> models = reactor.getModelsInProject();
        try {
            this.yangProvider.addYangsToMetaInf(this.project, models);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed write model files for " + models, (Exception)e);
        }
        File generatedServicesDir = new GeneratedDirectories(this.project).getYangServicesDir();
        YangProvider.setResource(generatedServicesDir, this.project);
        LOG.debug("{} Yang services files from: {} marked as resources: {}", new Object[]{LOG_PREFIX, generatedServicesDir, META_INF_YANG_SERVICES_STRING_JAR});
    }

    private static StatementParserMode determineRequiredImportMode(Collection<Map.Entry<ConfigArg.CodeGeneratorArg, BasicCodeGenerator>> codeGenerators) throws MojoFailureException {
        BasicCodeGenerator.ImportResolutionMode requestedMode = null;
        BasicCodeGenerator requestingGenerator = null;
        for (Map.Entry<ConfigArg.CodeGeneratorArg, BasicCodeGenerator> entry : codeGenerators) {
            BasicCodeGenerator generator = entry.getValue();
            BasicCodeGenerator.ImportResolutionMode mode = generator.getImportResolutionMode();
            if (mode == null) continue;
            if (requestedMode == null) {
                requestedMode = mode;
                requestingGenerator = generator;
                continue;
            }
            if (mode == requestedMode) continue;
            throw new MojoFailureException(String.format("Import resolution mode conflict between %s (%s) and %s (%s)", requestingGenerator, requestedMode, generator, mode));
        }
        if (requestedMode == null) {
            return StatementParserMode.DEFAULT_MODE;
        }
        switch (requestedMode) {
            case REVISION_EXACT_OR_LATEST: {
                return StatementParserMode.DEFAULT_MODE;
            }
            case SEMVER_LATEST: {
                return StatementParserMode.SEMVER_MODE;
            }
        }
        throw new IllegalStateException("Unhandled import resolution mode " + requestedMode);
    }

    private List<Map.Entry<ConfigArg.CodeGeneratorArg, BasicCodeGenerator>> instantiateGenerators() throws MojoExecutionException {
        ArrayList<Map.Entry<ConfigArg.CodeGeneratorArg, BasicCodeGenerator>> generators = new ArrayList<Map.Entry<ConfigArg.CodeGeneratorArg, BasicCodeGenerator>>(this.codeGeneratorArgs.size());
        for (ConfigArg.CodeGeneratorArg arg : this.codeGeneratorArgs) {
            BasicCodeGenerator generator;
            arg.check();
            try {
                generator = YangToSourcesProcessor.getInstance(arg.getCodeGeneratorClass(), BasicCodeGenerator.class);
            }
            catch (ReflectiveOperationException e) {
                throw new MojoExecutionException("Failed to instantiate code generator " + arg.getCodeGeneratorClass(), (Exception)e);
            }
            LOG.info("{} Code generator instantiated from {}", (Object)LOG_PREFIX, (Object)arg.getCodeGeneratorClass());
            generators.add(new AbstractMap.SimpleImmutableEntry<ConfigArg.CodeGeneratorArg, BasicCodeGenerator>(arg, generator));
        }
        return generators;
    }

    private Optional<ProcessorModuleReactor> createReactor(StatementParserMode parserMode, List<File> yangFilesInProject) throws MojoExecutionException {
        LOG.info("{} Inspecting {}", (Object)LOG_PREFIX, (Object)this.yangFilesRootDir);
        try {
            Object dependencies;
            ArrayList<File> allFiles = new ArrayList<File>(yangFilesInProject);
            if (this.inspectDependencies) {
                dependencies = new ArrayList();
                Stopwatch watch = Stopwatch.createStarted();
                ScannedDependency.scanDependencies(this.project).forEach(arg_0 -> YangToSourcesProcessor.lambda$createReactor$0(allFiles, (Collection)dependencies, arg_0));
                LOG.info("{} Found {} dependencies in {}", new Object[]{LOG_PREFIX, dependencies.size(), watch});
            } else {
                dependencies = ImmutableList.of();
            }
            if (!allFiles.stream().anyMatch(arg_0 -> ((BuildContext)this.buildContext).hasDelta(arg_0))) {
                LOG.info("{} None of {} input files changed", (Object)LOG_PREFIX, (Object)allFiles.size());
                return Optional.empty();
            }
            YangParser parser = this.parserFactory.createParser(parserMode);
            ArrayList<YangTextSchemaSource> sourcesInProject = new ArrayList<YangTextSchemaSource>(yangFilesInProject.size());
            List parsed = yangFilesInProject.parallelStream().map(file -> {
                YangTextSchemaSource textSource = YangTextSchemaSource.forFile((File)file);
                try {
                    return new AbstractMap.SimpleImmutableEntry<YangTextSchemaSource, ASTSchemaSource>(textSource, TextToASTTransformer.transformText((YangTextSchemaSource)textSource));
                }
                catch (IOException | YangSyntaxErrorException | SchemaSourceException e) {
                    throw new IllegalArgumentException("Failed to parse " + file, e);
                }
            }).collect(Collectors.toList());
            for (Map.Entry entry : parsed) {
                YangTextSchemaSource textSource = (YangTextSchemaSource)entry.getKey();
                ASTSchemaSource astSource = (ASTSchemaSource)entry.getValue();
                parser.addSource((SchemaSourceRepresentation)astSource);
                if (!((SourceIdentifier)astSource.getIdentifier()).equals(textSource.getIdentifier())) {
                    sourcesInProject.add(YangTextSchemaSource.delegateForByteSource((SourceIdentifier)((SourceIdentifier)astSource.getIdentifier()), (ByteSource)textSource));
                    continue;
                }
                sourcesInProject.add(textSource);
            }
            LOG.debug("Found project files: {}", yangFilesInProject);
            LOG.info("{} Project model files found: {}", (Object)LOG_PREFIX, (Object)yangFilesInProject.size());
            ProcessorModuleReactor reactor = new ProcessorModuleReactor(parser, sourcesInProject, (Collection<ScannedDependency>)dependencies);
            LOG.debug("Initialized reactor {} with {}", (Object)reactor, yangFilesInProject);
            return Optional.of(reactor);
        }
        catch (IOException | RuntimeException | YangSyntaxErrorException e) {
            LOG.error("{} Unable to parse YANG files from {}", new Object[]{LOG_PREFIX, this.yangFilesRootDir, e});
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            throw new MojoExecutionException("yang-to-sources: Unable to parse YANG files from " + this.yangFilesRootDir, rootCause);
        }
    }

    private static List<File> listFiles(File root, Collection<File> excludedFiles) throws IOException {
        if (!root.isDirectory()) {
            LOG.warn("{} YANG source directory {} not found. No code will be generated.", (Object)LOG_PREFIX, (Object)root);
            return ImmutableList.of();
        }
        return Files.walk(root.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).filter(f -> {
            if (excludedFiles.contains(f)) {
                LOG.info("{} YANG file excluded {}", (Object)LOG_PREFIX, f);
                return false;
            }
            return true;
        }).filter(f -> f.getName().endsWith(".yang")).collect(Collectors.toList());
    }

    private void generateSources(ContextHolder context, Collection<Map.Entry<ConfigArg.CodeGeneratorArg, BasicCodeGenerator>> generators) throws MojoFailureException {
        if (generators.isEmpty()) {
            LOG.warn("{} No code generators provided", (Object)LOG_PREFIX);
            return;
        }
        HashMap<String, String> thrown = new HashMap<String, String>();
        for (Map.Entry<ConfigArg.CodeGeneratorArg, BasicCodeGenerator> entry : generators) {
            String codeGeneratorClass = entry.getKey().getCodeGeneratorClass();
            try {
                this.generateSourcesWithOneGenerator(context, entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                LOG.error("{} Unable to generate sources with {} generator", new Object[]{LOG_PREFIX, codeGeneratorClass, e});
                thrown.put(codeGeneratorClass, e.getClass().getCanonicalName());
            }
        }
        if (!thrown.isEmpty()) {
            LOG.error("{} One or more code generators failed, including failed list(generatorClass=exception) {}", (Object)LOG_PREFIX, thrown);
            throw new MojoFailureException("yang-to-sources: One or more code generators failed, including failed list(generatorClass=exception) " + thrown);
        }
    }

    private void generateSourcesWithOneGenerator(ContextHolder context, ConfigArg.CodeGeneratorArg codeGeneratorCfg, BasicCodeGenerator codeGenerator) throws IOException {
        File outputDir = Objects.requireNonNull(codeGeneratorCfg.getOutputBaseDir(this.project), "outputBaseDir is null. Please provide a valid outputBaseDir value in pom.xml");
        this.project.addCompileSourceRoot(outputDir.getAbsolutePath());
        LOG.info("{} Sources will be generated to {}", (Object)LOG_PREFIX, (Object)outputDir);
        LOG.debug("{} Project root dir is {}", (Object)LOG_PREFIX, (Object)this.project.getBasedir());
        LOG.debug("{} Additional configuration picked up for : {}: {}", new Object[]{LOG_PREFIX, codeGeneratorCfg.getCodeGeneratorClass(), codeGeneratorCfg.getAdditionalConfiguration()});
        if (codeGenerator instanceof BuildContextAware) {
            ((BuildContextAware)codeGenerator).setBuildContext(this.buildContext);
        }
        if (codeGenerator instanceof MavenProjectAware) {
            ((MavenProjectAware)codeGenerator).setMavenProject(this.project);
        }
        codeGenerator.setAdditionalConfig(codeGeneratorCfg.getAdditionalConfiguration());
        File resourceBaseDir = codeGeneratorCfg.getResourceBaseDir(this.project);
        YangProvider.setResource(resourceBaseDir, this.project);
        codeGenerator.setResourceBaseDir(resourceBaseDir);
        LOG.debug("{} Folder: {} marked as resources for generator: {}", new Object[]{LOG_PREFIX, resourceBaseDir, codeGeneratorCfg.getCodeGeneratorClass()});
        if (outputDir.exists()) {
            Files.walk(outputDir.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            LOG.info("{} Succesfully deleted output directory {}", (Object)LOG_PREFIX, (Object)outputDir);
        }
        Stopwatch watch = Stopwatch.createStarted();
        Collection generated = codeGenerator.generateSources(context.getContext(), outputDir, context.getYangModules(), context::moduleToResourcePath);
        LOG.debug("{} Sources generated by {}: {}", new Object[]{LOG_PREFIX, codeGeneratorCfg.getCodeGeneratorClass(), generated});
        LOG.info("{} Sources generated by {}: {} in {}", new Object[]{LOG_PREFIX, codeGeneratorCfg.getCodeGeneratorClass(), generated == null ? 0 : generated.size(), watch});
    }

    private static <T> T getInstance(String codeGeneratorClass, Class<T> baseType) throws ReflectiveOperationException {
        Class<?> clazz = Class.forName(codeGeneratorClass);
        Preconditions.checkArgument((boolean)baseType.isAssignableFrom(clazz), (String)"Code generator %s has to implement %s", clazz, baseType);
        return baseType.cast(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private static /* synthetic */ void lambda$createReactor$0(Collection allFiles, Collection dependencies, ScannedDependency dep) {
        allFiles.add(dep.file());
        dependencies.add(dep);
    }

    static {
        Iterator<YangParserFactory> it = ServiceLoader.load(YangParserFactory.class).iterator();
        Preconditions.checkState((boolean)it.hasNext(), (Object)"Failed to find a YangParserFactory implementation");
        DEFAULT_PARSER_FACTORY = it.next();
        META_INF_YANG_STRING = META_INF_STR + File.separator + YANG_STR;
    }
}

