/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang2sources.plugin.Util;

final class ContextHolder
implements Immutable {
    private final SchemaContext context;
    private final Set<Module> modules;
    private final Set<SourceIdentifier> sources;

    ContextHolder(SchemaContext context, Set<Module> modules, Set<SourceIdentifier> sources) {
        this.context = Objects.requireNonNull(context);
        this.modules = ImmutableSet.copyOf(modules);
        this.sources = ImmutableSet.copyOf(sources);
    }

    SchemaContext getContext() {
        return this.context;
    }

    Set<Module> getYangModules() {
        return this.modules;
    }

    Optional<String> moduleToResourcePath(Module mod) {
        SourceIdentifier id = Util.moduleToIdentifier(mod);
        return this.sources.contains(id) ? Optional.of("/META-INF/yang/" + id.toYangFilename()) : Optional.empty();
    }
}

