/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    static List<File> getClassPath(MavenProject project) {
        ArrayList<File> dependencies = new ArrayList<File>();
        for (Artifact element : project.getArtifacts()) {
            File asFile = element.getFile();
            if (!Util.isJar(asFile) && !asFile.isDirectory()) continue;
            dependencies.add(asFile);
        }
        return dependencies;
    }

    static void checkClasspath(MavenProject project, RepositorySystem repoSystem, ArtifactRepository localRepo, List<ArtifactRepository> remoteRepos) {
        Plugin plugin = project.getPlugin("org.opendaylight.yangtools:yang-maven-plugin");
        if (plugin == null) {
            LOG.warn("{} {} not found, dependencies version check skipped", (Object)"yang-to-sources:", (Object)"org.opendaylight.yangtools:yang-maven-plugin");
        } else {
            HashMap<Artifact, Collection<Artifact>> pluginDependencies = new HashMap<Artifact, Collection<Artifact>>();
            Util.getPluginTransitiveDependencies(plugin, pluginDependencies, repoSystem, localRepo, remoteRepos);
            Set projectDependencies = project.getDependencyArtifacts();
            for (Map.Entry entry : pluginDependencies.entrySet()) {
                Util.checkArtifact((Artifact)entry.getKey(), projectDependencies);
                for (Artifact dependency : (Collection)entry.getValue()) {
                    Util.checkArtifact(dependency, projectDependencies);
                }
            }
        }
    }

    private static void getPluginTransitiveDependencies(Plugin plugin, Map<Artifact, Collection<Artifact>> map, RepositorySystem repoSystem, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepos) {
        List pluginDependencies = plugin.getDependencies();
        for (Dependency dep : pluginDependencies) {
            Artifact artifact = repoSystem.createDependencyArtifact(dep);
            ArtifactResolutionRequest request = new ArtifactResolutionRequest();
            request.setArtifact(artifact);
            request.setResolveTransitively(true);
            request.setLocalRepository(localRepository);
            request.setRemoteRepositories(remoteRepos);
            ArtifactResolutionResult result = repoSystem.resolve(request);
            Set pluginDependencyDependencies = result.getArtifacts();
            map.put(artifact, pluginDependencyDependencies);
        }
    }

    private static void checkArtifact(Artifact artifact, Collection<Artifact> dependencies) {
        for (Artifact d : dependencies) {
            if (!artifact.getGroupId().equals(d.getGroupId()) || !artifact.getArtifactId().equals(d.getArtifactId()) || artifact.getVersion().equals(d.getVersion())) continue;
            LOG.warn("{} Dependency resolution conflict:", (Object)"yang-to-sources:");
            LOG.warn("{} '{}' dependency [{}] has different version than one declared in current project [{}]. It is recommended to fix this problem because it may cause compilation errors.", new Object[]{"yang-to-sources:", "org.opendaylight.yangtools:yang-maven-plugin", artifact, d});
        }
    }

    private static boolean isJar(File element) {
        return element.isFile() && element.getName().endsWith(".jar");
    }

    static SourceIdentifier moduleToIdentifier(Module module) {
        return RevisionSourceIdentifier.create((String)module.getName(), (Optional)module.getRevision());
    }
}

