/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang2sources.plugin;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang2sources.plugin.GeneratedDirectories;
import org.opendaylight.yangtools.yang2sources.plugin.YangToSourcesProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class YangProvider {
    private static final YangProvider DEFAULT = new Default();

    YangProvider() {
    }

    static YangProvider getInstance() {
        return DEFAULT;
    }

    abstract void addYangsToMetaInf(MavenProject var1, Collection<YangTextSchemaSource> var2) throws IOException;

    static void setResource(File targetYangDir, MavenProject project) {
        Resource res = new Resource();
        res.setDirectory(targetYangDir.getPath());
        project.addResource(res);
    }

    private static final class Default
    extends YangProvider {
        private static final Logger LOG = LoggerFactory.getLogger(Default.class);

        private Default() {
        }

        @Override
        void addYangsToMetaInf(MavenProject project, Collection<YangTextSchemaSource> modelsInProject) throws IOException {
            File generatedYangDir = new GeneratedDirectories(project).getYangDir();
            LOG.debug("Generated dir {}", (Object)generatedYangDir);
            File withMetaInf = new File(generatedYangDir, YangToSourcesProcessor.META_INF_YANG_STRING);
            for (YangTextSchemaSource source : modelsInProject) {
                String fileName = source.getIdentifier().toYangFilename();
                File file = new File(withMetaInf, fileName);
                Files.createParentDirs((File)file);
                source.copyTo(Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]));
                LOG.debug("Created file {} for {}", (Object)file, (Object)source.getIdentifier());
            }
            Default.setResource(generatedYangDir, project);
            LOG.debug("{} YANG files marked as resources: {}", (Object)"yang-to-sources:", (Object)generatedYangDir);
        }
    }
}

