/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureSet;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;

@Beta
public interface YangParser {
    public @NonNull Collection<Class<? extends SourceRepresentation>> supportedSourceRepresentations();

    public @NonNull YangParser addSource(SourceRepresentation var1) throws IOException, YangSyntaxErrorException;

    default public @NonNull YangParser addSources(SourceRepresentation ... sources) throws IOException, YangSyntaxErrorException {
        for (SourceRepresentation source : sources) {
            this.addSource(source);
        }
        return this;
    }

    default public @NonNull YangParser addSources(Collection<? extends SourceRepresentation> sources) throws IOException, YangSyntaxErrorException {
        for (SourceRepresentation sourceRepresentation : sources) {
            this.addSource(sourceRepresentation);
        }
        return this;
    }

    public YangParser addLibSource(SourceRepresentation var1) throws IOException, YangSyntaxErrorException;

    default public @NonNull YangParser addLibSources(SourceRepresentation ... sources) throws IOException, YangSyntaxErrorException {
        for (SourceRepresentation source : sources) {
            this.addLibSource(source);
        }
        return this;
    }

    default public @NonNull YangParser addLibSources(Collection<SourceRepresentation> sources) throws IOException, YangSyntaxErrorException {
        for (SourceRepresentation source : sources) {
            this.addLibSource(source);
        }
        return this;
    }

    public @NonNull YangParser setSupportedFeatures(@NonNull FeatureSet var1);

    public @NonNull YangParser setModulesWithSupportedDeviations(@NonNull SetMultimap<QNameModule, QNameModule> var1);

    public @NonNull List<DeclaredStatement<?>> buildDeclaredModel() throws YangParserException;

    public @NonNull EffectiveModelContext buildEffectiveModel() throws YangParserException;
}

