/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.parser.api.ImportResolutionMode;

@NonNullByDefault
public final class YangParserConfiguration
implements Immutable {
    public static final YangParserConfiguration DEFAULT = YangParserConfiguration.builder().build();
    private final ImportResolutionMode importResolutionMode;
    private final boolean retainDeclarationReferences;

    private YangParserConfiguration(ImportResolutionMode importResolutionMode, boolean retainDeclarationReferences) {
        this.importResolutionMode = Objects.requireNonNull(importResolutionMode);
        this.retainDeclarationReferences = retainDeclarationReferences;
    }

    @Beta
    public ImportResolutionMode importResolutionMode() {
        return this.importResolutionMode;
    }

    public boolean retainDeclarationReferences() {
        return this.retainDeclarationReferences;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.importResolutionMode, this.retainDeclarationReferences});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof YangParserConfiguration)) {
            return false;
        }
        YangParserConfiguration other = (YangParserConfiguration)obj;
        return this.importResolutionMode == other.importResolutionMode && this.retainDeclarationReferences == other.retainDeclarationReferences;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("importResolution", (Object)this.importResolutionMode).add("declarationReferences", this.retainDeclarationReferences).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements org.opendaylight.yangtools.concepts.Builder<YangParserConfiguration> {
        private ImportResolutionMode importResolutionMode = ImportResolutionMode.DEFAULT;
        private boolean retainDeclarationReferences = false;

        private Builder() {
        }

        public YangParserConfiguration build() {
            return new YangParserConfiguration(this.importResolutionMode, this.retainDeclarationReferences);
        }

        @Beta
        public Builder importResolutionMode(ImportResolutionMode newImportResolutionMode) {
            this.importResolutionMode = Objects.requireNonNull(newImportResolutionMode);
            return this;
        }

        public Builder retainDeclarationReferences(boolean newRetainDeclarationReferences) {
            this.retainDeclarationReferences = newRetainDeclarationReferences;
            return this;
        }
    }
}

