/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AnyXmlSchemaNodeImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractSchemaNodeBuilder;

public final class AnyXmlBuilder
extends AbstractSchemaNodeBuilder
implements DataSchemaNodeBuilder {
    private AnyXmlSchemaNodeImpl instance;
    private boolean augmenting;
    private boolean addedByUses;
    private boolean configuration;
    private AnyXmlSchemaNode originalNode;
    private AnyXmlBuilder originalBuilder;
    private final ConstraintsBuilder constraints;

    public AnyXmlBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.constraints = new ConstraintsBuilderImpl(moduleName, line);
    }

    public AnyXmlBuilder(String moduleName, int line, QName qname, SchemaPath path, AnyXmlSchemaNode base) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.constraints = new ConstraintsBuilderImpl(moduleName, line, base.getConstraints());
        this.description = base.getDescription();
        this.reference = base.getReference();
        this.status = base.getStatus();
        this.augmenting = base.isAugmenting();
        this.addedByUses = base.isAddedByUses();
        this.originalNode = base;
        this.configuration = base.isConfiguration();
        this.unknownNodes.addAll(base.getUnknownSchemaNodes());
    }

    public AnyXmlSchemaNode build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = new AnyXmlSchemaNodeImpl(this.qname, this.schemaPath);
        this.instance.description = this.description;
        this.instance.reference = this.reference;
        this.instance.status = this.status;
        this.instance.augmenting = this.augmenting;
        this.instance.addedByUses = this.addedByUses;
        this.instance.configuration = this.configuration;
        this.instance.constraintsDef = this.constraints.toInstance();
        if (this.originalNode == null && this.originalBuilder != null) {
            this.originalNode = this.originalBuilder.build();
        }
        this.instance.original = this.originalNode;
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    @Override
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    @Override
    public AnyXmlBuilder getOriginal() {
        return this.originalBuilder;
    }

    @Override
    public void setOriginal(SchemaNodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof AnyXmlBuilder), (Object)("Original of anyxml cannot be " + builder));
        this.originalBuilder = (AnyXmlBuilder)builder;
    }

    @Override
    public boolean isConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(boolean configuration) {
        this.configuration = configuration;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyXmlBuilder other = (AnyXmlBuilder)obj;
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        return !(this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent()));
    }

    public String toString() {
        return "anyxml " + this.qname.getLocalName();
    }
}

