/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

final class AnyXmlSchemaNodeImpl
implements AnyXmlSchemaNode,
DerivableSchemaNode {
    private final QName qname;
    private final SchemaPath path;
    String description;
    String reference;
    Status status;
    boolean configuration;
    AnyXmlSchemaNode original;
    ConstraintDefinition constraintsDef;
    boolean augmenting;
    boolean addedByUses;
    ImmutableList<UnknownSchemaNode> unknownNodes;

    AnyXmlSchemaNodeImpl(QName qname, SchemaPath path) {
        this.qname = qname;
        this.path = path;
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isAugmenting() {
        return this.augmenting;
    }

    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public Optional<AnyXmlSchemaNode> getOriginal() {
        return Optional.fromNullable((Object)this.original);
    }

    public boolean isConfiguration() {
        return this.configuration;
    }

    public ConstraintDefinition getConstraints() {
        return this.constraintsDef;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyXmlSchemaNodeImpl other = (AnyXmlSchemaNodeImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(AnyXmlSchemaNodeImpl.class.getSimpleName());
        sb.append("[");
        sb.append("qname=").append(this.qname);
        sb.append(", path=").append(this.path);
        sb.append("]");
        return sb.toString();
    }
}

