/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AugmentationSchemaImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedDataNodeContainerBuilder;

public final class AugmentationSchemaBuilderImpl
extends AbstractDocumentedDataNodeContainerBuilder
implements AugmentationSchemaBuilder {
    private final int order;
    private AugmentationSchemaImpl instance;
    private String whenCondition;
    private final String augmentTargetStr;
    private final SchemaPath targetPath;
    private boolean resolved;
    private boolean unsupportedTarget = false;
    private AugmentationSchemaBuilder copyOf;

    public AugmentationSchemaBuilderImpl(String moduleName, int line, String augmentTargetStr, SchemaPath targetPath, int order) {
        super(moduleName, line, (QName)null);
        this.order = order;
        this.augmentTargetStr = augmentTargetStr;
        this.targetPath = targetPath;
    }

    @Override
    protected String getStatementName() {
        return "augment";
    }

    @Override
    public SchemaPath getPath() {
        return this.targetPath;
    }

    @Override
    public SchemaPath getTargetPath() {
        return this.targetPath;
    }

    @Override
    public AugmentationSchema build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.buildChildren();
        this.instance = new AugmentationSchemaImpl(this.targetPath, this.order, this);
        Builder parent = this.getParent();
        if (parent instanceof ModuleBuilder) {
            ModuleBuilder moduleBuilder = (ModuleBuilder)parent;
            this.instance.namespace = moduleBuilder.getNamespace();
            this.instance.revision = moduleBuilder.getRevision();
        }
        if (this.copyOf != null) {
            this.instance.setCopyOf(this.copyOf.build());
        }
        RevisionAwareXPathImpl whenStmt = this.whenCondition == null ? null : new RevisionAwareXPathImpl(this.whenCondition, false);
        this.instance.whenCondition = whenStmt;
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public void setUnsupportedTarget(boolean unsupportedTarget) {
        this.unsupportedTarget = unsupportedTarget;
    }

    @Override
    public boolean isUnsupportedTarget() {
        return this.unsupportedTarget;
    }

    @Override
    public String getWhenCondition() {
        return this.whenCondition;
    }

    @Override
    public void addWhenCondition(String whenCondition) {
        this.whenCondition = whenCondition;
    }

    @Override
    public String getTargetPathAsString() {
        return this.augmentTargetStr;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public int hashCode() {
        int prime = 17;
        int result = 1;
        result = 17 * result + (this.augmentTargetStr == null ? 0 : this.augmentTargetStr.hashCode());
        result = 17 * result + (this.whenCondition == null ? 0 : this.whenCondition.hashCode());
        result = 17 * result + this.getChildNodeBuilders().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AugmentationSchemaBuilderImpl other = (AugmentationSchemaBuilderImpl)obj;
        if (this.augmentTargetStr == null ? other.augmentTargetStr != null : !this.augmentTargetStr.equals(other.augmentTargetStr)) {
            return false;
        }
        if (this.whenCondition == null ? other.whenCondition != null : !this.whenCondition.equals(other.whenCondition)) {
            return false;
        }
        return this.getChildNodeBuilders().equals(other.getChildNodeBuilders());
    }

    public String toString() {
        return "augment " + this.augmentTargetStr;
    }

    public void setCopyOf(AugmentationSchemaBuilder old) {
        this.copyOf = old;
    }
}

