/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingMember;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AnyXmlBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.CopyUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.GroupingBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentitySchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.NotificationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.TypeDefinitionBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilderImpl;
import org.opendaylight.yangtools.yang.parser.impl.ParserListenerUtils;
import org.opendaylight.yangtools.yang.parser.impl.util.YangModelDependencyInfo;
import org.opendaylight.yangtools.yang.parser.util.NamedByteArrayInputStream;
import org.opendaylight.yangtools.yang.parser.util.NamedFileInputStream;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuilderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BuilderUtils.class);
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final Date NULL_DATE = new Date(0L);
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String CHILD_NOT_FOUND_IN_NODE_STR = "Child {} not found in node {}";

    private BuilderUtils() {
    }

    public static Collection<ByteSource> streamsToByteSources(Collection<InputStream> streams) throws IOException {
        HashSet<ByteSource> result = new HashSet<ByteSource>();
        for (InputStream stream : streams) {
            result.add(new ByteSourceImpl(stream));
        }
        return result;
    }

    public static ByteSource fileToByteSource(final File file) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return new NamedFileInputStream(file, file.getAbsolutePath());
            }
        };
    }

    public static Collection<ByteSource> filesToByteSources(Collection<File> streams) throws FileNotFoundException {
        return Collections2.transform(streams, (Function)new Function<File, ByteSource>(){

            public ByteSource apply(final File input) {
                return new ByteSource(){

                    public InputStream openStream() throws IOException {
                        return new NamedFileInputStream(input, input.getAbsolutePath());
                    }
                };
            }
        });
    }

    @Deprecated
    public static SchemaPath createSchemaPath(SchemaPath schemaPath, QName ... qname) {
        return schemaPath.createChild(qname);
    }

    public static ModuleBuilder findModuleFromBuilders(Map<String, NavigableMap<Date, ModuleBuilder>> modules, ModuleBuilder module, String prefix, int line) {
        ModuleBuilder dependentModule;
        if (prefix == null) {
            dependentModule = module;
        } else if (prefix.equals(module.getPrefix())) {
            dependentModule = module;
        } else {
            ModuleImport dependentModuleImport = module.getImport(prefix);
            if (dependentModuleImport == null) {
                throw new YangParseException(module.getName(), line, "No import found with prefix '" + prefix + "'.");
            }
            String dependentModuleName = dependentModuleImport.getModuleName();
            Date dependentModuleRevision = dependentModuleImport.getRevision();
            NavigableMap<Date, ModuleBuilder> moduleBuildersByRevision = modules.get(dependentModuleName);
            if (moduleBuildersByRevision == null) {
                return null;
            }
            dependentModule = dependentModuleRevision == null ? moduleBuildersByRevision.lastEntry().getValue() : (ModuleBuilder)moduleBuildersByRevision.get(dependentModuleRevision);
        }
        return dependentModule;
    }

    public static ModuleBuilder findModuleFromBuilders(ModuleImport imp, Iterable<ModuleBuilder> modules) {
        String name = imp.getModuleName();
        Date revision = imp.getRevision();
        TreeMap<Date, ModuleBuilder> map = new TreeMap<Date, ModuleBuilder>();
        for (ModuleBuilder module : modules) {
            if (module == null || !module.getName().equals(name)) continue;
            map.put(module.getRevision(), module);
        }
        if (map.isEmpty()) {
            return null;
        }
        if (revision == null) {
            return (ModuleBuilder)map.lastEntry().getValue();
        }
        return (ModuleBuilder)map.get(revision);
    }

    public static Module findModuleFromContext(SchemaContext context, ModuleBuilder currentModule, String prefix, int line) {
        TreeMap<Date, Module> modulesByRevision = new TreeMap<Date, Module>();
        ModuleImport dependentModuleImport = currentModule.getImport(prefix);
        if (dependentModuleImport == null) {
            throw new YangParseException(currentModule.getName(), line, "No import found with prefix '" + prefix + "'.");
        }
        String dependentModuleName = dependentModuleImport.getModuleName();
        Date dependentModuleRevision = dependentModuleImport.getRevision();
        for (Module contextModule : context.getModules()) {
            if (!contextModule.getName().equals(dependentModuleName)) continue;
            Date revision = contextModule.getRevision();
            if (revision == null) {
                revision = NULL_DATE;
            }
            modulesByRevision.put(revision, contextModule);
        }
        Module result = dependentModuleRevision == null ? (Module)modulesByRevision.get(modulesByRevision.firstKey()) : (Module)modulesByRevision.get(dependentModuleRevision);
        if (result == null) {
            throw new YangParseException(currentModule.getName(), line, "Module not found for prefix " + prefix);
        }
        return result;
    }

    public static void fillAugmentTarget(AugmentationSchemaBuilder augment, Builder target) {
        if (target instanceof DataNodeContainerBuilder) {
            BuilderUtils.fillAugmentTarget(augment, (DataNodeContainerBuilder)target);
        } else if (target instanceof ChoiceBuilder) {
            BuilderUtils.fillAugmentTarget(augment, (ChoiceBuilder)target);
        } else {
            throw new YangParseException(augment.getModuleName(), augment.getLine(), "Error in augment parsing: The target node MUST be either a container, list, choice, case, input, output, or notification node.");
        }
    }

    private static void fillAugmentTarget(AugmentationSchemaBuilder augment, DataNodeContainerBuilder target) {
        for (DataSchemaNodeBuilder child : augment.getChildNodeBuilders()) {
            DataSchemaNodeBuilder childCopy = CopyUtils.copy(child, (Builder)target, false);
            if (augment.getParent() instanceof UsesNodeBuilder) {
                BuilderUtils.setNodeAddedByUses(childCopy);
            }
            BuilderUtils.setNodeAugmenting(childCopy);
            try {
                target.addChildNode(childCopy);
            }
            catch (YangParseException e) {
                throw new YangParseException(augment.getModuleName(), augment.getLine(), "Failed to perform augmentation: " + e.getMessage());
            }
        }
    }

    private static void fillAugmentTarget(AugmentationSchemaBuilder augment, ChoiceBuilder target) {
        for (DataSchemaNodeBuilder builder : augment.getChildNodeBuilders()) {
            DataSchemaNodeBuilder childCopy = CopyUtils.copy(builder, (Builder)target, false);
            if (augment.getParent() instanceof UsesNodeBuilder) {
                BuilderUtils.setNodeAddedByUses(childCopy);
            }
            BuilderUtils.setNodeAugmenting(childCopy);
            target.addCase(childCopy);
        }
        for (UsesNodeBuilder usesNode : augment.getUsesNodeBuilders()) {
            if (usesNode == null) continue;
            throw new YangParseException(augment.getModuleName(), augment.getLine(), "Error in augment parsing: cannot augment choice with nodes from grouping");
        }
    }

    private static void setNodeAugmenting(DataSchemaNodeBuilder node) {
        block3: {
            block2: {
                node.setAugmenting(true);
                if (!(node instanceof DataNodeContainerBuilder)) break block2;
                DataNodeContainerBuilder dataNodeChild = (DataNodeContainerBuilder)((Object)node);
                for (DataSchemaNodeBuilder inner : dataNodeChild.getChildNodeBuilders()) {
                    BuilderUtils.setNodeAugmenting(inner);
                }
                break block3;
            }
            if (!(node instanceof ChoiceBuilder)) break block3;
            ChoiceBuilder choiceChild = (ChoiceBuilder)node;
            for (ChoiceCaseBuilder inner : choiceChild.getCases()) {
                BuilderUtils.setNodeAugmenting(inner);
            }
        }
    }

    public static void setNodeAddedByUses(GroupingMember node) {
        block3: {
            block2: {
                node.setAddedByUses(true);
                if (!(node instanceof DataNodeContainerBuilder)) break block2;
                DataNodeContainerBuilder dataNodeChild = (DataNodeContainerBuilder)((Object)node);
                for (DataSchemaNodeBuilder inner : dataNodeChild.getChildNodeBuilders()) {
                    BuilderUtils.setNodeAddedByUses(inner);
                }
                break block3;
            }
            if (!(node instanceof ChoiceBuilder)) break block3;
            ChoiceBuilder choiceChild = (ChoiceBuilder)node;
            for (ChoiceCaseBuilder inner : choiceChild.getCases()) {
                BuilderUtils.setNodeAddedByUses(inner);
            }
        }
    }

    public static SchemaNodeBuilder findTargetNode(Iterable<QName> path, DataNodeContainerBuilder parent) {
        String name;
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(path);
        SchemaNodeBuilder foundNode = null;
        Iterator<QName> pathIterator = path.iterator();
        if (pathIterator.hasNext() && (foundNode = parent.getDataChildByName(name = pathIterator.next().getLocalName())) == null) {
            foundNode = BuilderUtils.findUnknownNode(name, parent);
        }
        if (pathIterator.hasNext() && foundNode != null) {
            return BuilderUtils.findSchemaNode(Iterables.skip(path, (int)1), foundNode);
        }
        return foundNode;
    }

    public static SchemaNodeBuilder findSchemaNode(Iterable<QName> path, SchemaNodeBuilder parentNode) {
        SchemaNodeBuilder node = null;
        SchemaNodeBuilder parent = parentNode;
        int size = Iterables.size(path);
        int i = 0;
        for (QName qname : path) {
            String name = qname.getLocalName();
            if (parent instanceof DataNodeContainerBuilder) {
                node = ((DataNodeContainerBuilder)((Object)parent)).getDataChildByName(name);
                if (node == null) {
                    node = BuilderUtils.findUnknownNode(name, parent);
                }
            } else if (parent instanceof ChoiceBuilder) {
                node = ((ChoiceBuilder)parent).getCaseNodeByName(name);
                if (node == null) {
                    node = BuilderUtils.findUnknownNode(name, parent);
                }
            } else if (parent instanceof RpcDefinitionBuilder) {
                if (INPUT.equals(name)) {
                    node = ((RpcDefinitionBuilder)parent).getInput();
                } else if (OUTPUT.equals(name)) {
                    node = ((RpcDefinitionBuilder)parent).getOutput();
                } else if (node == null) {
                    node = BuilderUtils.findUnknownNode(name, parent);
                }
            } else {
                node = BuilderUtils.findUnknownNode(name, parent);
            }
            if (i < size - 1) {
                parent = node;
            }
            ++i;
        }
        return node;
    }

    private static UnknownSchemaNodeBuilder findUnknownNode(String name, Builder parent) {
        for (UnknownSchemaNodeBuilder un : parent.getUnknownNodes()) {
            if (!un.getQName().getLocalName().equals(name)) continue;
            return un;
        }
        return null;
    }

    public static Optional<SchemaNodeBuilder> findSchemaNodeInModule(SchemaPath schemaPath, ModuleBuilder module) {
        Iterator path = schemaPath.getPathFromRoot().iterator();
        Preconditions.checkArgument((boolean)path.hasNext(), (Object)"Schema Path must contain at least one element.");
        QName first = (QName)path.next();
        Optional currentNode = BuilderUtils.getDataNamespaceChild(module, first);
        while (currentNode.isPresent() && path.hasNext()) {
            QName currentPath;
            SchemaNodeBuilder currentParent = (SchemaNodeBuilder)currentNode.get();
            if ((currentNode = BuilderUtils.findDataChild(currentParent, currentPath = (QName)path.next())).isPresent()) continue;
            for (SchemaNodeBuilder schemaNodeBuilder : currentParent.getUnknownNodes()) {
                if (!schemaNodeBuilder.getQName().equals((Object)currentPath)) continue;
                currentNode = Optional.of((Object)schemaNodeBuilder);
            }
        }
        return currentNode;
    }

    private static Optional<SchemaNodeBuilder> findDataChild(SchemaNodeBuilder parent, QName child) {
        if (parent instanceof DataNodeContainerBuilder) {
            return BuilderUtils.castOptional(SchemaNodeBuilder.class, BuilderUtils.findDataChildInDataNodeContainer((DataNodeContainerBuilder)((Object)parent), child));
        }
        if (parent instanceof ChoiceBuilder) {
            return BuilderUtils.castOptional(SchemaNodeBuilder.class, BuilderUtils.findCaseInChoice((ChoiceBuilder)parent, child));
        }
        if (parent instanceof RpcDefinitionBuilder) {
            return BuilderUtils.castOptional(SchemaNodeBuilder.class, BuilderUtils.findContainerInRpc((RpcDefinitionBuilder)parent, child));
        }
        LOG.trace(CHILD_NOT_FOUND_IN_NODE_STR, (Object)child, (Object)parent);
        return Optional.absent();
    }

    private static <T> Optional<T> castOptional(Class<T> cls, Optional<?> optional) {
        Object value;
        if (optional.isPresent() && cls.isInstance(value = optional.get())) {
            Object casted = value;
            return Optional.of((Object)casted);
        }
        return Optional.absent();
    }

    private static Optional<ContainerSchemaNodeBuilder> findContainerInRpc(RpcDefinitionBuilder parent, QName child) {
        if (INPUT.equals(child.getLocalName())) {
            if (parent.getInput() == null) {
                QName qname = QName.create((QNameModule)parent.getQName().getModule(), (String)INPUT);
                ContainerSchemaNodeBuilder inputBuilder = new ContainerSchemaNodeBuilder(parent.getModuleName(), parent.getLine(), qname, parent.getPath().createChild(new QName[]{qname}));
                inputBuilder.setParent(parent);
                parent.setInput(inputBuilder);
                return Optional.of((Object)inputBuilder);
            }
            return Optional.of((Object)parent.getInput());
        }
        if (OUTPUT.equals(child.getLocalName())) {
            if (parent.getOutput() == null) {
                QName qname = QName.create((QNameModule)parent.getQName().getModule(), (String)OUTPUT);
                ContainerSchemaNodeBuilder outputBuilder = new ContainerSchemaNodeBuilder(parent.getModuleName(), parent.getLine(), qname, parent.getPath().createChild(new QName[]{qname}));
                outputBuilder.setParent(parent);
                parent.setOutput(outputBuilder);
                return Optional.of((Object)outputBuilder);
            }
            return Optional.of((Object)parent.getOutput());
        }
        LOG.trace(CHILD_NOT_FOUND_IN_NODE_STR, (Object)child, (Object)parent);
        return Optional.absent();
    }

    private static Optional<ChoiceCaseBuilder> findCaseInChoice(ChoiceBuilder parent, QName child) {
        for (ChoiceCaseBuilder caze : parent.getCases()) {
            if (!caze.getQName().equals((Object)child)) continue;
            return Optional.of((Object)caze);
        }
        LOG.trace(CHILD_NOT_FOUND_IN_NODE_STR, (Object)child, (Object)parent);
        return Optional.absent();
    }

    private static Optional<DataSchemaNodeBuilder> findDataChildInDataNodeContainer(DataNodeContainerBuilder parent, QName child) {
        for (DataSchemaNodeBuilder childNode : parent.getChildNodeBuilders()) {
            if (!childNode.getQName().equals((Object)child)) continue;
            return Optional.of((Object)childNode);
        }
        LOG.trace(CHILD_NOT_FOUND_IN_NODE_STR, (Object)child, (Object)parent);
        return Optional.absent();
    }

    private static Optional<SchemaNodeBuilder> getDataNamespaceChild(ModuleBuilder module, QName child) {
        Optional<SchemaNodeBuilder> dataTreeNode = BuilderUtils.getDataChildByQName(module, child);
        if (dataTreeNode.isPresent()) {
            return dataTreeNode;
        }
        Set<NotificationBuilder> notifications = module.getAddedNotifications();
        for (NotificationBuilder notification : notifications) {
            if (!notification.getQName().equals((Object)child)) continue;
            return Optional.of((Object)notification);
        }
        Set<RpcDefinitionBuilder> rpcs = module.getAddedRpcs();
        for (RpcDefinitionBuilder rpc : rpcs) {
            if (!rpc.getQName().equals((Object)child)) continue;
            return Optional.of((Object)rpc);
        }
        LOG.trace("Child {} not found in data namespace of module {}", (Object)child, (Object)module);
        return Optional.absent();
    }

    private static Optional<SchemaNodeBuilder> getDataChildByQName(DataNodeContainerBuilder builder, QName child) {
        for (DataSchemaNodeBuilder childNode : builder.getChildNodeBuilders()) {
            if (!childNode.getQName().equals((Object)child)) continue;
            return Optional.of((Object)childNode);
        }
        LOG.trace(CHILD_NOT_FOUND_IN_NODE_STR, (Object)child, (Object)builder);
        return Optional.absent();
    }

    public static boolean processAugmentation(AugmentationSchemaBuilder augment, ModuleBuilder firstNodeParent) {
        Optional<SchemaNodeBuilder> potentialTargetNode = BuilderUtils.findSchemaNodeInModule(augment.getTargetPath(), firstNodeParent);
        if (!potentialTargetNode.isPresent()) {
            return false;
        }
        if (potentialTargetNode.get() instanceof UnknownSchemaNodeBuilder) {
            LOG.warn("Error in augment parsing: unsupported augment target: {}", potentialTargetNode.get());
            return true;
        }
        SchemaNodeBuilder targetNode = (SchemaNodeBuilder)potentialTargetNode.get();
        BuilderUtils.fillAugmentTarget(augment, targetNode);
        Preconditions.checkState((boolean)(targetNode instanceof AugmentationTargetBuilder), (Object)"Node refered by augmentation must be valid augmentation target");
        ((AugmentationTargetBuilder)((Object)targetNode)).addAugmentation(augment);
        augment.setResolved(true);
        return true;
    }

    public static IdentitySchemaNodeBuilder findBaseIdentity(ModuleBuilder module, String baseString, int line) {
        if (baseString.indexOf(58) != -1) {
            Iterator it = COLON_SPLITTER.split((CharSequence)baseString).iterator();
            String prefix = (String)it.next();
            String name = (String)it.next();
            if (it.hasNext()) {
                throw new YangParseException(module.getName(), line, "Failed to parse identityref base: " + baseString);
            }
            ModuleBuilder dependentModule = BuilderUtils.getModuleByPrefix(module, prefix);
            if (dependentModule == null) {
                return null;
            }
            return BuilderUtils.findIdentity(dependentModule.getAddedIdentities(), name);
        }
        return BuilderUtils.findIdentity(module.getAddedIdentities(), baseString);
    }

    public static IdentitySchemaNodeBuilder findIdentity(Set<IdentitySchemaNodeBuilder> identities, String name) {
        for (IdentitySchemaNodeBuilder identity : identities) {
            if (!identity.getQName().getLocalName().equals(name)) continue;
            return identity;
        }
        return null;
    }

    public static ModuleBuilder getParentModule(Builder node) {
        if (node instanceof ModuleBuilder) {
            return (ModuleBuilder)node;
        }
        Builder parent = node.getParent();
        while (!(parent instanceof ModuleBuilder)) {
            parent = parent.getParent();
        }
        ModuleBuilder parentModule = (ModuleBuilder)parent;
        if (parentModule.isSubmodule()) {
            parentModule = parentModule.getParent();
        }
        return parentModule;
    }

    public static Set<DataSchemaNodeBuilder> wrapChildNodes(String moduleName, int line, Collection<DataSchemaNode> nodes, SchemaPath parentPath, QName parentQName) {
        LinkedHashSet<DataSchemaNodeBuilder> result = new LinkedHashSet<DataSchemaNodeBuilder>(nodes.size());
        for (DataSchemaNode node : nodes) {
            QName qname = QName.create((QName)parentQName, (String)node.getQName().getLocalName());
            DataSchemaNodeBuilder wrapped = BuilderUtils.wrapChildNode(moduleName, line, node, parentPath, qname);
            result.add(wrapped);
        }
        return result;
    }

    public static DataSchemaNodeBuilder wrapChildNode(String moduleName, int line, DataSchemaNode node, SchemaPath parentPath, QName qname) {
        SchemaPath schemaPath = parentPath.createChild(new QName[]{qname});
        if (node instanceof AnyXmlSchemaNode) {
            return new AnyXmlBuilder(moduleName, line, qname, schemaPath, (AnyXmlSchemaNode)node);
        }
        if (node instanceof ChoiceSchemaNode) {
            return new ChoiceBuilder(moduleName, line, qname, schemaPath, (ChoiceSchemaNode)node);
        }
        if (node instanceof ContainerSchemaNode) {
            return new ContainerSchemaNodeBuilder(moduleName, line, qname, schemaPath, (ContainerSchemaNode)node);
        }
        if (node instanceof LeafSchemaNode) {
            return new LeafSchemaNodeBuilder(moduleName, line, qname, schemaPath, (LeafSchemaNode)node);
        }
        if (node instanceof LeafListSchemaNode) {
            return new LeafListSchemaNodeBuilder(moduleName, line, qname, schemaPath, (LeafListSchemaNode)node);
        }
        if (node instanceof ListSchemaNode) {
            return new ListSchemaNodeBuilder(moduleName, line, qname, schemaPath, (ListSchemaNode)node);
        }
        if (node instanceof ChoiceCaseNode) {
            return new ChoiceCaseBuilder(moduleName, line, qname, schemaPath, (ChoiceCaseNode)node);
        }
        throw new YangParseException(moduleName, line, "Failed to copy node: Unknown type of DataSchemaNode: " + node);
    }

    public static Set<GroupingBuilder> wrapGroupings(String moduleName, int line, Set<GroupingDefinition> nodes, SchemaPath parentPath, QName parentQName) {
        HashSet<GroupingBuilder> result = new HashSet<GroupingBuilder>();
        for (GroupingDefinition node : nodes) {
            QName qname = QName.create((QName)parentQName, (String)node.getQName().getLocalName());
            SchemaPath schemaPath = parentPath.createChild(new QName[]{qname});
            result.add(new GroupingBuilderImpl(moduleName, line, qname, schemaPath, node));
        }
        return result;
    }

    public static Set<TypeDefinitionBuilder> wrapTypedefs(String moduleName, int line, DataNodeContainer dataNode, SchemaPath parentPath, QName parentQName) {
        Set nodes = dataNode.getTypeDefinitions();
        HashSet<TypeDefinitionBuilder> result = new HashSet<TypeDefinitionBuilder>();
        for (TypeDefinition node : nodes) {
            QName qname = QName.create((QName)parentQName, (String)node.getQName().getLocalName());
            SchemaPath schemaPath = parentPath.createChild(new QName[]{qname});
            result.add(new TypeDefinitionBuilderImpl(moduleName, line, qname, schemaPath, (ExtendedType)node));
        }
        return result;
    }

    public static List<UnknownSchemaNodeBuilderImpl> wrapUnknownNodes(String moduleName, int line, List<UnknownSchemaNode> nodes, SchemaPath parentPath, QName parentQName) {
        ArrayList<UnknownSchemaNodeBuilderImpl> result = new ArrayList<UnknownSchemaNodeBuilderImpl>();
        for (UnknownSchemaNode node : nodes) {
            QName qname = QName.create((QName)parentQName, (String)node.getQName().getLocalName());
            SchemaPath schemaPath = parentPath.createChild(new QName[]{qname});
            result.add(new UnknownSchemaNodeBuilderImpl(moduleName, line, qname, schemaPath, node));
        }
        return result;
    }

    public static ModuleBuilder getModuleByPrefix(ModuleBuilder module, String prefix) {
        if (prefix == null || prefix.isEmpty() || prefix.equals(module.getPrefix())) {
            return module;
        }
        return module.getImportedModule(prefix);
    }

    public static ModuleBuilder findModule(QName qname, Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        NavigableMap<Date, ModuleBuilder> map = modules.get(qname.getNamespace());
        if (map == null) {
            return null;
        }
        if (qname.getRevision() == null) {
            return map.lastEntry().getValue();
        }
        Map.Entry<Date, ModuleBuilder> lastEntry = map.lastEntry();
        if (qname.getRevision().compareTo(lastEntry.getKey()) > 0) {
            LOG.warn(String.format("Attempt to find more recent revision of module than is available. The requested revision is [%s], but the most recent available revision of module is [%s]. Most probably some of Yang models do not have updated revision or they are not referenced correctly.", qname.getRevision(), lastEntry.getKey()));
            return lastEntry.getValue();
        }
        return (ModuleBuilder)map.get(qname.getRevision());
    }

    public static Map<String, NavigableMap<Date, URI>> createYangNamespaceContext(Collection<? extends ParseTree> modules, Optional<SchemaContext> context) {
        HashMap<String, NavigableMap<Date, URI>> namespaceContext = new HashMap<String, NavigableMap<Date, URI>>();
        HashSet<YangParser.Submodule_stmtContext> submodules = new HashSet<YangParser.Submodule_stmtContext>();
        for (ParseTree parseTree : modules) {
            for (int i = 0; i < parseTree.getChildCount(); ++i) {
                ParseTree moduleTree = parseTree.getChild(i);
                if (moduleTree instanceof YangParser.Submodule_stmtContext) {
                    submodules.add((YangParser.Submodule_stmtContext)moduleTree);
                    continue;
                }
                if (!(moduleTree instanceof YangParser.Module_stmtContext)) continue;
                YangParser.Module_stmtContext moduleCtx = (YangParser.Module_stmtContext)moduleTree;
                String moduleName = ParserListenerUtils.stringFromNode((ParseTree)moduleCtx);
                Date rev = null;
                URI namespace = null;
                block2: for (int j = 0; j < moduleCtx.getChildCount(); ++j) {
                    ParseTree moduleCtxChildTree = moduleCtx.getChild(j);
                    if (moduleCtxChildTree instanceof YangParser.Revision_stmtsContext) {
                        String revisionDateStr = YangModelDependencyInfo.getLatestRevision((YangParser.Revision_stmtsContext)moduleCtxChildTree);
                        rev = revisionDateStr == null ? new Date(0L) : QName.parseRevision((String)revisionDateStr);
                    }
                    if (!(moduleCtxChildTree instanceof YangParser.Module_header_stmtsContext)) continue;
                    YangParser.Module_header_stmtsContext headerCtx = (YangParser.Module_header_stmtsContext)moduleCtxChildTree;
                    for (int k = 0; k < headerCtx.getChildCount(); ++k) {
                        ParseTree ctx = headerCtx.getChild(k);
                        if (!(ctx instanceof YangParser.Namespace_stmtContext)) continue;
                        String namespaceStr = ParserListenerUtils.stringFromNode(ctx);
                        namespace = URI.create(namespaceStr);
                        continue block2;
                    }
                }
                TreeMap<Date, URI> revToNs = (TreeMap<Date, URI>)namespaceContext.get(moduleName);
                if (revToNs == null) {
                    revToNs = new TreeMap<Date, URI>();
                    revToNs.put(rev, namespace);
                    namespaceContext.put(moduleName, revToNs);
                }
                revToNs.put(rev, namespace);
            }
        }
        if (context.isPresent()) {
            for (Module module : ((SchemaContext)context.get()).getModules()) {
                TreeMap<Date, URI> revToNs = (TreeMap<Date, URI>)namespaceContext.get(module.getName());
                if (revToNs == null) {
                    revToNs = new TreeMap<Date, URI>();
                    revToNs.put(module.getRevision(), module.getNamespace());
                    namespaceContext.put(module.getName(), revToNs);
                }
                revToNs.put(module.getRevision(), module.getNamespace());
            }
        }
        for (YangParser.Submodule_stmtContext submodule_stmtContext : submodules) {
            String moduleName = ParserListenerUtils.stringFromNode((ParseTree)submodule_stmtContext);
            for (int i = 0; i < submodule_stmtContext.getChildCount(); ++i) {
                ParseTree subHeaderCtx = submodule_stmtContext.getChild(i);
                if (!(subHeaderCtx instanceof YangParser.Submodule_header_stmtsContext)) continue;
                for (int j = 0; j < subHeaderCtx.getChildCount(); ++j) {
                    ParseTree belongsCtx = subHeaderCtx.getChild(j);
                    if (!(belongsCtx instanceof YangParser.Belongs_to_stmtContext)) continue;
                    String belongsTo = ParserListenerUtils.stringFromNode(belongsCtx);
                    NavigableMap ns = (NavigableMap)namespaceContext.get(belongsTo);
                    if (ns == null) {
                        throw new YangParseException(moduleName, submodule_stmtContext.getStart().getLine(), String.format("Unresolved belongs-to statement: %s", belongsTo));
                    }
                    TreeMap subNs = new TreeMap();
                    subNs.put(ns.firstKey(), ns.firstEntry().getValue());
                    namespaceContext.put(moduleName, subNs);
                }
            }
        }
        return namespaceContext;
    }

    private static final class ByteSourceImpl
    extends ByteSource {
        private final String toString;
        private final byte[] data;

        private ByteSourceImpl(InputStream input) throws IOException {
            this.toString = input.toString();
            this.data = ByteStreams.toByteArray((InputStream)input);
        }

        public InputStream openStream() throws IOException {
            return new NamedByteArrayInputStream(this.data, this.toString);
        }
    }
}

