/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceNodeImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class ChoiceBuilder
extends AbstractSchemaNodeBuilder
implements DataSchemaNodeBuilder,
AugmentationTargetBuilder {
    private ChoiceNodeImpl instance;
    private boolean augmenting;
    private boolean addedByUses;
    private boolean configuration;
    private ChoiceSchemaNode originalNode;
    private ChoiceBuilder originalBuilder;
    private final ConstraintsBuilder constraints;
    private final Set<AugmentationSchema> augmentations = new HashSet<AugmentationSchema>();
    private final List<AugmentationSchemaBuilder> augmentationBuilders = new ArrayList<AugmentationSchemaBuilder>();
    private final Set<ChoiceCaseBuilder> caseBuilders = new HashSet<ChoiceCaseBuilder>();
    private String defaultCase;

    public ChoiceBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.constraints = new ConstraintsBuilderImpl(moduleName, line);
    }

    public ChoiceBuilder(String moduleName, int line, QName qname, SchemaPath path, ChoiceSchemaNode base) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.constraints = new ConstraintsBuilderImpl(moduleName, line, base.getConstraints());
        this.description = base.getDescription();
        this.reference = base.getReference();
        this.status = base.getStatus();
        this.augmenting = base.isAugmenting();
        this.addedByUses = base.isAddedByUses();
        this.originalNode = base;
        this.configuration = base.isConfiguration();
        this.augmentations.addAll(base.getAvailableAugmentations());
        Set<DataSchemaNodeBuilder> wrapped = BuilderUtils.wrapChildNodes(moduleName, line, new HashSet<DataSchemaNode>(base.getCases()), path, qname);
        for (DataSchemaNodeBuilder wrap : wrapped) {
            if (!(wrap instanceof ChoiceCaseBuilder)) continue;
            this.caseBuilders.add((ChoiceCaseBuilder)wrap);
        }
        this.addedUnknownNodes.addAll(BuilderUtils.wrapUnknownNodes(moduleName, line, base.getUnknownSchemaNodes(), path, qname));
    }

    public ChoiceSchemaNode build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = new ChoiceNodeImpl(this.qname, this.schemaPath);
        this.instance.description = this.description;
        this.instance.reference = this.reference;
        this.instance.status = this.status;
        this.instance.augmenting = this.augmenting;
        this.instance.addedByUses = this.addedByUses;
        this.instance.configuration = this.configuration;
        this.instance.constraints = this.constraints.toInstance();
        this.instance.defaultCase = this.defaultCase;
        if (this.originalNode == null && this.originalBuilder != null) {
            this.originalNode = this.originalBuilder.build();
        }
        this.instance.original = this.originalNode;
        TreeSet<SchemaNode> cases = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        for (ChoiceCaseBuilder caseBuilder : this.caseBuilders) {
            cases.add((SchemaNode)caseBuilder.build());
        }
        this.instance.cases = ImmutableSet.copyOf(cases);
        for (AugmentationSchemaBuilder builder : this.augmentationBuilders) {
            this.augmentations.add(builder.build());
        }
        this.instance.augmentations = ImmutableSet.copyOf(this.augmentations);
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    public Set<ChoiceCaseBuilder> getCases() {
        return this.caseBuilders;
    }

    public ChoiceCaseBuilder getCaseNodeByName(String caseName) {
        for (ChoiceCaseBuilder addedCase : this.caseBuilders) {
            if (!addedCase.getQName().getLocalName().equals(caseName)) continue;
            return addedCase;
        }
        return null;
    }

    public void addCase(DataSchemaNodeBuilder caseNode) {
        QName caseQName = caseNode.getQName();
        String caseName = caseQName.getLocalName();
        for (ChoiceCaseBuilder existingCase : this.caseBuilders) {
            if (!existingCase.getQName().getLocalName().equals(caseName)) continue;
            throw new YangParseException(caseNode.getModuleName(), caseNode.getLine(), "Can not add '" + caseNode + "' to node '" + this.qname.getLocalName() + "' in module '" + this.getModuleName() + "': case with same name already declared at line " + existingCase.getLine());
        }
        if (caseNode instanceof ChoiceCaseBuilder) {
            this.caseBuilders.add((ChoiceCaseBuilder)caseNode);
        } else {
            ChoiceCaseBuilder caseBuilder = new ChoiceCaseBuilder(caseNode.getModuleName(), caseNode.getLine(), caseQName, caseNode.getPath());
            if (caseNode.isAugmenting()) {
                caseBuilder.setAugmenting(true);
                caseNode.setAugmenting(false);
            }
            SchemaPath newPath = caseNode.getPath().createChild(new QName[]{caseQName});
            caseNode.setPath(newPath);
            caseBuilder.addChildNode(caseNode);
            this.caseBuilders.add(caseBuilder);
        }
    }

    @Override
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    @Override
    public ChoiceBuilder getOriginal() {
        return this.originalBuilder;
    }

    @Override
    public void setOriginal(SchemaNodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof ChoiceBuilder), (Object)("Original of choice cannot be " + builder));
        this.originalBuilder = (ChoiceBuilder)builder;
    }

    @Override
    public boolean isConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(boolean configuration) {
        this.configuration = configuration;
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    @Override
    public void addAugmentation(AugmentationSchemaBuilder augment) {
        this.augmentationBuilders.add(augment);
    }

    public List<AugmentationSchemaBuilder> getAugmentationBuilders() {
        return this.augmentationBuilders;
    }

    public String getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(String defaultCase) {
        this.defaultCase = defaultCase;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChoiceBuilder other = (ChoiceBuilder)obj;
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        return !(this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent()));
    }

    public String toString() {
        return "choice " + this.qname.getLocalName();
    }
}

