/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseNodeImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class ChoiceCaseBuilder
extends AbstractDocumentedDataNodeContainerBuilder
implements DataSchemaNodeBuilder,
AugmentationTargetBuilder {
    private ChoiceCaseNodeImpl instance;
    private SchemaPath schemaPath;
    private boolean augmenting;
    private ChoiceCaseNode originalNode;
    private ChoiceCaseBuilder originalBuilder;
    private boolean addedByUses;
    private final ConstraintsBuilder constraints;
    private final List<AugmentationSchema> augmentations = new ArrayList<AugmentationSchema>();
    private final List<AugmentationSchemaBuilder> augmentationBuilders = new ArrayList<AugmentationSchemaBuilder>();

    public ChoiceCaseBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
        this.constraints = new ConstraintsBuilderImpl(moduleName, line);
    }

    public ChoiceCaseBuilder(String moduleName, int line, QName qname, SchemaPath path, ChoiceCaseNode base) {
        super(moduleName, line, qname, (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null"), (DataNodeContainer)base);
        this.schemaPath = path;
        this.constraints = new ConstraintsBuilderImpl(moduleName, line, base.getConstraints());
        this.augmenting = base.isAugmenting();
        this.addedByUses = base.isAddedByUses();
        this.originalNode = base;
        this.addedUnknownNodes.addAll(BuilderUtils.wrapUnknownNodes(moduleName, line, base.getUnknownSchemaNodes(), path, qname));
        this.augmentations.addAll(base.getAvailableAugmentations());
    }

    public ChoiceCaseNode build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.buildChildren();
        this.instance = new ChoiceCaseNodeImpl(this.qname, this.schemaPath, this);
        this.instance.augmenting = this.augmenting;
        this.instance.addedByUses = this.addedByUses;
        this.instance.constraints = this.constraints.toInstance();
        if (this.originalNode == null && this.originalBuilder != null) {
            this.originalNode = this.originalBuilder.build();
        }
        this.instance.original = this.originalNode;
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        for (AugmentationSchemaBuilder builder : this.augmentationBuilders) {
            this.augmentations.add(builder.build());
        }
        this.instance.augmentations = ImmutableSet.copyOf(this.augmentations);
        return this.instance;
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.schemaPath = path;
    }

    @Override
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    @Override
    public ChoiceCaseBuilder getOriginal() {
        return this.originalBuilder;
    }

    @Override
    public void setOriginal(SchemaNodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof ChoiceCaseBuilder), (Object)("Original of case cannot be " + builder));
        this.originalBuilder = (ChoiceCaseBuilder)builder;
    }

    @Override
    public void addTypedef(TypeDefinitionBuilder typedefBuilder) {
        throw new YangParseException(this.getModuleName(), typedefBuilder.getLine(), "Can not add type definition to choice case.");
    }

    @Override
    public void addGrouping(GroupingBuilder groupingBuilder) {
        throw new YangParseException(this.getModuleName(), groupingBuilder.getLine(), "Can not add grouping to choice case.");
    }

    @Override
    public boolean isConfiguration() {
        return false;
    }

    @Override
    public void setConfiguration(boolean configuration) {
        throw new YangParseException(this.getModuleName(), this.getLine(), "Can not add config statement to choice case.");
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    @Override
    public void addAugmentation(AugmentationSchemaBuilder augment) {
        this.augmentationBuilders.add(augment);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChoiceCaseBuilder other = (ChoiceCaseBuilder)obj;
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        return !(this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent()));
    }

    public String toString() {
        return "case " + this.getQName().getLocalName();
    }

    @Override
    protected String getStatementName() {
        return "choice";
    }
}

