/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedDataNodeContainer;

final class ChoiceCaseNodeImpl
extends AbstractDocumentedDataNodeContainer
implements ChoiceCaseNode,
DerivableSchemaNode {
    private final QName qname;
    private final SchemaPath path;
    boolean augmenting;
    boolean addedByUses;
    ChoiceCaseNode original;
    ConstraintDefinition constraints;
    ImmutableSet<AugmentationSchema> augmentations;
    ImmutableList<UnknownSchemaNode> unknownNodes;

    ChoiceCaseNodeImpl(QName qname, SchemaPath path, ChoiceCaseBuilder builder) {
        super(builder);
        this.qname = qname;
        this.path = path;
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public boolean isConfiguration() {
        return false;
    }

    public ConstraintDefinition getConstraints() {
        return this.constraints;
    }

    public boolean isAugmenting() {
        return this.augmenting;
    }

    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public Optional<ChoiceCaseNode> getOriginal() {
        return Optional.fromNullable((Object)this.original);
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public Set<AugmentationSchema> getAvailableAugmentations() {
        return this.augmentations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChoiceCaseNodeImpl other = (ChoiceCaseNodeImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ChoiceCaseNodeImpl.class.getSimpleName());
        sb.append("[");
        sb.append("qname=");
        sb.append(this.qname);
        sb.append("]");
        return sb.toString();
    }
}

