/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;
import org.opendaylight.yangtools.yang.parser.builder.api.ConstraintsBuilder;

public final class ConstraintsBuilderImpl
implements ConstraintsBuilder {
    private static final ConstraintDefinitionImpl EMPTY_CONSTRAINT = new ConstraintDefinitionImpl();
    private static final ConstraintDefinitionImpl EMPTY_MANDATORY_CONSTRAINT;
    private final String moduleName;
    private final int line;
    private final Set<MustDefinition> mustDefinitions;
    private ConstraintDefinitionImpl instance;
    private RevisionAwareXPath whenStmt;
    private String whenCondition;
    private boolean mandatory;
    private Integer min;
    private Integer max;

    public ConstraintsBuilderImpl(String moduleName, int line) {
        this.moduleName = moduleName;
        this.line = line;
        this.mustDefinitions = new HashSet<MustDefinition>();
    }

    ConstraintsBuilderImpl(ConstraintsBuilder b) {
        this.moduleName = b.getModuleName();
        this.line = b.getLine();
        this.mustDefinitions = new HashSet<MustDefinition>(b.getMustDefinitions());
        this.whenCondition = b.getWhenCondition();
        this.mandatory = b.isMandatory();
        this.min = b.getMinElements();
        this.max = b.getMaxElements();
    }

    ConstraintsBuilderImpl(String moduleName, int line, ConstraintDefinition base) {
        this.moduleName = moduleName;
        this.line = line;
        this.whenStmt = base.getWhenCondition();
        this.mustDefinitions = new HashSet<MustDefinition>(base.getMustConstraints());
        this.mandatory = base.isMandatory();
        this.min = base.getMinElements();
        this.max = base.getMaxElements();
    }

    public ConstraintDefinition build() {
        if (this.instance != null) {
            return this.instance;
        }
        if (this.whenStmt == null) {
            this.whenStmt = this.whenCondition == null ? null : new RevisionAwareXPathImpl(this.whenCondition, false);
        }
        ConstraintDefinitionImpl newInstance = new ConstraintDefinitionImpl();
        newInstance.setWhenCondition(this.whenStmt);
        newInstance.setMandatory(this.mandatory);
        newInstance.setMinElements(this.min);
        newInstance.setMaxElements(this.max);
        if (!this.mustDefinitions.isEmpty()) {
            newInstance.setMustConstraints(this.mustDefinitions);
        }
        if (EMPTY_CONSTRAINT.equals(newInstance)) {
            newInstance = EMPTY_CONSTRAINT;
        } else if (EMPTY_MANDATORY_CONSTRAINT.equals(newInstance)) {
            newInstance = EMPTY_MANDATORY_CONSTRAINT;
        }
        this.instance = newInstance;
        return this.instance;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public Integer getMinElements() {
        return this.min;
    }

    @Override
    public void setMinElements(Integer minElements) {
        this.min = minElements;
    }

    @Override
    public Integer getMaxElements() {
        return this.max;
    }

    @Override
    public void setMaxElements(Integer maxElements) {
        this.max = maxElements;
    }

    @Override
    public Set<MustDefinition> getMustDefinitions() {
        return this.mustDefinitions;
    }

    @Override
    public void addMustDefinition(MustDefinition must) {
        this.mustDefinitions.add(must);
    }

    @Override
    public String getWhenCondition() {
        return this.whenCondition;
    }

    @Override
    public void addWhenCondition(String whenCondition) {
        this.whenCondition = whenCondition;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    @Deprecated
    public ConstraintDefinition toInstance() {
        return this.build();
    }

    static {
        ConstraintDefinitionImpl c = new ConstraintDefinitionImpl();
        c.setMandatory(true);
        EMPTY_MANDATORY_CONSTRAINT = c;
    }

    private static final class ConstraintDefinitionImpl
    implements ConstraintDefinition {
        private RevisionAwareXPath whenCondition;
        private Set<MustDefinition> mustConstraints = Collections.emptySet();
        private Boolean mandatory = false;
        private Integer minElements;
        private Integer maxElements;

        private ConstraintDefinitionImpl() {
        }

        public RevisionAwareXPath getWhenCondition() {
            return this.whenCondition;
        }

        private void setWhenCondition(RevisionAwareXPath whenCondition) {
            this.whenCondition = whenCondition;
        }

        public Set<MustDefinition> getMustConstraints() {
            return this.mustConstraints;
        }

        private void setMustConstraints(Set<MustDefinition> mustConstraints) {
            if (mustConstraints != null) {
                this.mustConstraints = ImmutableSet.copyOf(mustConstraints);
            }
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        private void setMandatory(boolean mandatory) {
            this.mandatory = mandatory;
        }

        public Integer getMinElements() {
            return this.minElements;
        }

        private void setMinElements(Integer minElements) {
            this.minElements = minElements;
        }

        public Integer getMaxElements() {
            return this.maxElements;
        }

        private void setMaxElements(Integer maxElements) {
            this.maxElements = maxElements;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.whenCondition == null ? 0 : this.whenCondition.hashCode());
            result = 31 * result + (this.mustConstraints == null ? 0 : this.mustConstraints.hashCode());
            result = 31 * result + (this.minElements == null ? 0 : this.minElements.hashCode());
            result = 31 * result + (this.maxElements == null ? 0 : this.maxElements.hashCode());
            result = 31 * result + this.mandatory.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstraintDefinitionImpl other = (ConstraintDefinitionImpl)obj;
            if (this.whenCondition == null ? other.whenCondition != null : !this.whenCondition.equals(other.whenCondition)) {
                return false;
            }
            if (this.mustConstraints == null ? other.mustConstraints != null : !this.mustConstraints.equals(other.mustConstraints)) {
                return false;
            }
            if (!this.mandatory.equals(other.mandatory)) {
                return false;
            }
            if (this.minElements == null ? other.minElements != null : !this.minElements.equals(other.minElements)) {
                return false;
            }
            return !(this.maxElements == null ? other.maxElements != null : !this.maxElements.equals(other.maxElements));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(ConstraintDefinitionImpl.class.getSimpleName());
            sb.append("[");
            sb.append("whenCondition=").append(this.whenCondition);
            sb.append(", mustConstraints=").append(this.mustConstraints);
            sb.append(", mandatory=").append(this.mandatory);
            sb.append(", minElements=").append(this.minElements);
            sb.append(", maxElements=").append(this.maxElements);
            sb.append("]");
            return sb.toString();
        }
    }
}

