/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedDataNodeContainerBuilder;

public final class ContainerSchemaNodeBuilder
extends AbstractDocumentedDataNodeContainerBuilder
implements AugmentationTargetBuilder,
DataSchemaNodeBuilder {
    private ContainerSchemaNodeImpl instance;
    private boolean presence;
    private SchemaPath path;
    private boolean augmenting;
    private boolean addedByUses;
    private boolean configuration;
    private ContainerSchemaNode originalNode;
    private ContainerSchemaNodeBuilder originalBuilder;
    private final ConstraintsBuilder constraints;
    private final List<AugmentationSchema> augmentations = new ArrayList<AugmentationSchema>();
    private final List<AugmentationSchemaBuilder> augmentationBuilders = new ArrayList<AugmentationSchemaBuilder>();

    public ContainerSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.path = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
        this.constraints = new ConstraintsBuilderImpl(moduleName, line);
    }

    public ContainerSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path, ContainerSchemaNode base) {
        super(moduleName, line, qname, path, (DataNodeContainer)base);
        this.path = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
        this.constraints = new ConstraintsBuilderImpl(moduleName, line, base.getConstraints());
        this.augmenting = base.isAugmenting();
        this.addedByUses = base.isAddedByUses();
        this.originalNode = base;
        this.configuration = base.isConfiguration();
        this.presence = base.isPresenceContainer();
        this.augmentations.addAll(base.getAvailableAugmentations());
    }

    @Override
    protected String getStatementName() {
        return "container";
    }

    public ContainerSchemaNode build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.buildChildren();
        this.instance = new ContainerSchemaNodeImpl(this);
        this.instance.augmenting = this.augmenting;
        this.instance.addedByUses = this.addedByUses;
        this.instance.configuration = this.configuration;
        this.instance.constraints = this.constraints.toInstance();
        this.instance.presence = this.presence;
        if (this.originalNode == null && this.originalBuilder != null) {
            this.originalNode = this.originalBuilder.build();
        }
        this.instance.original = this.originalNode;
        for (AugmentationSchemaBuilder builder : this.augmentationBuilders) {
            this.augmentations.add(builder.build());
        }
        this.instance.augmentations = ImmutableSet.copyOf(this.augmentations);
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    public List<AugmentationSchemaBuilder> getAugmentationBuilders() {
        return this.augmentationBuilders;
    }

    @Override
    public void addAugmentation(AugmentationSchemaBuilder augment) {
        this.augmentationBuilders.add(augment);
    }

    @Override
    public SchemaPath getPath() {
        return this.path;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.path = path;
    }

    @Override
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    @Override
    public ContainerSchemaNodeBuilder getOriginal() {
        return this.originalBuilder;
    }

    @Override
    public void setOriginal(SchemaNodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof ContainerSchemaNodeBuilder), (Object)("Original of container cannot be " + builder));
        this.originalBuilder = (ContainerSchemaNodeBuilder)builder;
    }

    @Override
    public boolean isConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(boolean configuration) {
        this.configuration = configuration;
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    public boolean isPresence() {
        return this.presence;
    }

    public void setPresence(boolean presence) {
        this.presence = presence;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerSchemaNodeBuilder other = (ContainerSchemaNodeBuilder)obj;
        if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
            return false;
        }
        return !(this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent()));
    }

    public String toString() {
        return "container " + this.qname.getLocalName();
    }
}

