/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AnyXmlBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AugmentationSchemaBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.GroupingBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.TypeDefinitionBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UsesNodeBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractTypeAwareBuilder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class CopyUtils {
    private CopyUtils() {
    }

    public static DataSchemaNodeBuilder copy(DataSchemaNodeBuilder old, Builder newParent, boolean updateQName) {
        if (old instanceof AnyXmlBuilder) {
            return CopyUtils.copy((AnyXmlBuilder)old, newParent, updateQName);
        }
        if (old instanceof ChoiceBuilder) {
            return CopyUtils.copy((ChoiceBuilder)old, newParent, updateQName);
        }
        if (old instanceof ContainerSchemaNodeBuilder) {
            return CopyUtils.copy((ContainerSchemaNodeBuilder)old, newParent, updateQName);
        }
        if (old instanceof LeafSchemaNodeBuilder) {
            return CopyUtils.copy((LeafSchemaNodeBuilder)old, newParent, updateQName);
        }
        if (old instanceof LeafListSchemaNodeBuilder) {
            return CopyUtils.copy((LeafListSchemaNodeBuilder)old, newParent, updateQName);
        }
        if (old instanceof ListSchemaNodeBuilder) {
            return CopyUtils.copy((ListSchemaNodeBuilder)old, newParent, updateQName);
        }
        if (old instanceof ChoiceCaseBuilder) {
            return CopyUtils.copy((ChoiceCaseBuilder)old, newParent, updateQName);
        }
        throw new YangParseException(old.getModuleName(), old.getLine(), "Failed to copy node: Unknown type of DataSchemaNode: " + old);
    }

    private static AnyXmlBuilder copy(AnyXmlBuilder old, Builder newParent, boolean updateQName) {
        DataBean data = CopyUtils.getdata(old, newParent, updateQName);
        QName newQName = data.qname;
        SchemaPath newSchemaPath = data.schemaPath;
        AnyXmlBuilder copy = new AnyXmlBuilder(newParent.getModuleName(), newParent.getLine(), newQName, newSchemaPath);
        copy.setOriginal(old.getOriginal() == null ? old : old.getOriginal());
        CopyUtils.copyConstraints(copy.getConstraints(), old.getConstraints());
        copy.setParent(newParent);
        copy.setDescription(old.getDescription());
        copy.setReference(old.getReference());
        copy.setStatus(old.getStatus());
        copy.setAugmenting(old.isAugmenting());
        copy.setAddedByUses(old.isAddedByUses());
        copy.setConfiguration(old.isConfiguration());
        for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
            copy.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)copy, updateQName));
        }
        return copy;
    }

    private static ChoiceBuilder copy(ChoiceBuilder old, Builder newParent, boolean updateQName) {
        DataBean data = CopyUtils.getdata(old, newParent, updateQName);
        QName newQName = data.qname;
        SchemaPath newSchemaPath = data.schemaPath;
        ChoiceBuilder copy = new ChoiceBuilder(newParent.getModuleName(), newParent.getLine(), newQName, newSchemaPath);
        copy.setOriginal(old.getOriginal() == null ? old : old.getOriginal());
        CopyUtils.copyConstraints(copy.getConstraints(), old.getConstraints());
        copy.setParent(newParent);
        copy.setDescription(old.getDescription());
        copy.setReference(old.getReference());
        copy.setStatus(old.getStatus());
        copy.setAugmenting(old.isAugmenting());
        copy.setAddedByUses(old.isAddedByUses());
        copy.setConfiguration(old.isConfiguration());
        for (ChoiceCaseBuilder childNode : old.getCases()) {
            copy.addCase(CopyUtils.copy(childNode, (Builder)copy, updateQName));
        }
        for (AugmentationSchemaBuilder augment : old.getAugmentationBuilders()) {
            copy.addAugmentation(CopyUtils.copyAugment(augment, copy));
        }
        for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
            copy.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)copy, updateQName));
        }
        return copy;
    }

    private static ChoiceCaseBuilder copy(ChoiceCaseBuilder old, Builder newParent, boolean updateQName) {
        DataBean data = CopyUtils.getdata(old, newParent, updateQName);
        QName newQName = data.qname;
        SchemaPath newSchemaPath = data.schemaPath;
        ChoiceCaseBuilder copy = new ChoiceCaseBuilder(newParent.getModuleName(), newParent.getLine(), newQName, newSchemaPath);
        copy.setOriginal(old.getOriginal() == null ? old : old.getOriginal());
        CopyUtils.copyConstraints(copy.getConstraints(), old.getConstraints());
        copy.setParent(newParent);
        copy.setDescription(old.getDescription());
        copy.setReference(old.getReference());
        copy.setStatus(old.getStatus());
        copy.setAugmenting(old.isAugmenting());
        for (DataSchemaNodeBuilder childNode : old.getChildNodeBuilders()) {
            copy.addChildNode(CopyUtils.copy(childNode, (Builder)copy, updateQName));
        }
        for (UsesNodeBuilder oldUses : old.getUsesNodeBuilders()) {
            copy.addUsesNode(CopyUtils.copyUses(oldUses, copy));
        }
        for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
            copy.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)copy, updateQName));
        }
        return copy;
    }

    private static ContainerSchemaNodeBuilder copy(ContainerSchemaNodeBuilder old, Builder newParent, boolean updateQName) {
        DataBean data = CopyUtils.getdata(old, newParent, updateQName);
        QName newQName = data.qname;
        SchemaPath newSchemaPath = data.schemaPath;
        ContainerSchemaNodeBuilder copy = new ContainerSchemaNodeBuilder(newParent.getModuleName(), newParent.getLine(), newQName, newSchemaPath);
        copy.setOriginal(old.getOriginal() == null ? old : old.getOriginal());
        CopyUtils.copyConstraints(copy.getConstraints(), old.getConstraints());
        copy.setParent(newParent);
        copy.setDescription(old.getDescription());
        copy.setReference(old.getReference());
        copy.setStatus(old.getStatus());
        copy.setPresence(old.isPresence());
        copy.setAugmenting(old.isAugmenting());
        copy.setAddedByUses(old.isAddedByUses());
        copy.setConfiguration(old.isConfiguration());
        for (DataSchemaNodeBuilder childNode : old.getChildNodeBuilders()) {
            copy.addChildNode(CopyUtils.copy(childNode, (Builder)copy, updateQName));
        }
        copy.getGroupings().addAll(old.getGroupings());
        for (GroupingBuilder grouping : old.getGroupingBuilders()) {
            copy.addGrouping(CopyUtils.copy(grouping, (Builder)copy, updateQName));
        }
        for (TypeDefinitionBuilder tdb : old.getTypeDefinitionBuilders()) {
            copy.addTypedef(CopyUtils.copy(tdb, (Builder)copy, updateQName));
        }
        for (UsesNodeBuilder oldUses : old.getUsesNodeBuilders()) {
            copy.addUsesNode(CopyUtils.copyUses(oldUses, copy));
        }
        for (AugmentationSchemaBuilder augment : old.getAugmentationBuilders()) {
            copy.addAugmentation(CopyUtils.copyAugment(augment, copy));
        }
        for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
            copy.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)copy, updateQName));
        }
        return copy;
    }

    private static LeafSchemaNodeBuilder copy(LeafSchemaNodeBuilder old, Builder newParent, boolean updateQName) {
        DataBean data = CopyUtils.getdata(old, newParent, updateQName);
        QName newQName = data.qname;
        SchemaPath newSchemaPath = data.schemaPath;
        LeafSchemaNodeBuilder copy = new LeafSchemaNodeBuilder(newParent.getModuleName(), newParent.getLine(), newQName, newSchemaPath);
        copy.setOriginal(old.getOriginal() == null ? old : old.getOriginal());
        CopyUtils.copyConstraints(copy.getConstraints(), old.getConstraints());
        copy.setParent(newParent);
        copy.setDescription(old.getDescription());
        copy.setReference(old.getReference());
        copy.setStatus(old.getStatus());
        copy.setAugmenting(old.isAugmenting());
        copy.setAddedByUses(old.isAddedByUses());
        copy.setConfiguration(old.isConfiguration());
        for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
            copy.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)copy, updateQName));
        }
        if (old.getType() == null) {
            copy.setTypedef(old.getTypedef());
        } else {
            copy.setType(old.getType());
        }
        copy.setDefaultStr(old.getDefaultStr());
        copy.setUnits(old.getUnits());
        return copy;
    }

    private static LeafListSchemaNodeBuilder copy(LeafListSchemaNodeBuilder old, Builder newParent, boolean updateQName) {
        DataBean data = CopyUtils.getdata(old, newParent, updateQName);
        QName newQName = data.qname;
        SchemaPath newSchemaPath = data.schemaPath;
        LeafListSchemaNodeBuilder copy = new LeafListSchemaNodeBuilder(newParent.getModuleName(), newParent.getLine(), newQName, newSchemaPath);
        copy.setOriginal(old.getOriginal() == null ? old : old.getOriginal());
        CopyUtils.copyConstraints(copy.getConstraints(), old.getConstraints());
        copy.setParent(newParent);
        copy.setDescription(old.getDescription());
        copy.setReference(old.getReference());
        copy.setStatus(old.getStatus());
        copy.setAugmenting(old.isAugmenting());
        copy.setAddedByUses(old.isAddedByUses());
        copy.setConfiguration(old.isConfiguration());
        for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
            copy.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)copy, updateQName));
        }
        if (old.getType() == null) {
            copy.setTypedef(old.getTypedef());
        } else {
            copy.setType(old.getType());
        }
        copy.setUserOrdered(old.isUserOrdered());
        return copy;
    }

    private static ListSchemaNodeBuilder copy(ListSchemaNodeBuilder old, Builder newParent, boolean updateQName) {
        DataBean data = CopyUtils.getdata(old, newParent, updateQName);
        QName newQName = data.qname;
        SchemaPath newSchemaPath = data.schemaPath;
        ListSchemaNodeBuilder copy = new ListSchemaNodeBuilder(newParent.getModuleName(), newParent.getLine(), newQName, newSchemaPath);
        copy.setOriginal(old.getOriginal() == null ? old : old.getOriginal());
        CopyUtils.copyConstraints(copy.getConstraints(), old.getConstraints());
        copy.setParent(newParent);
        copy.setDescription(old.getDescription());
        copy.setReference(old.getReference());
        copy.setStatus(old.getStatus());
        copy.setAugmenting(old.isAugmenting());
        copy.setAddedByUses(old.isAddedByUses());
        copy.setConfiguration(old.isConfiguration());
        for (DataSchemaNodeBuilder childNode : old.getChildNodeBuilders()) {
            copy.addChildNode(CopyUtils.copy(childNode, (Builder)copy, updateQName));
        }
        copy.getGroupings().addAll(old.getGroupings());
        for (GroupingBuilder grouping : old.getGroupingBuilders()) {
            copy.addGrouping(CopyUtils.copy(grouping, (Builder)copy, updateQName));
        }
        for (TypeDefinitionBuilder tdb : old.getTypeDefinitionBuilders()) {
            copy.addTypedef(CopyUtils.copy(tdb, (Builder)copy, updateQName));
        }
        for (UsesNodeBuilder oldUses : old.getUsesNodeBuilders()) {
            copy.addUsesNode(CopyUtils.copyUses(oldUses, copy));
        }
        for (AugmentationSchemaBuilder augment : old.getAugmentationBuilders()) {
            copy.addAugmentation(CopyUtils.copyAugment(augment, copy));
        }
        for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
            copy.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)copy, updateQName));
        }
        copy.setUserOrdered(old.isUserOrdered());
        copy.setKeys(old.getKeys());
        return copy;
    }

    public static GroupingBuilder copy(GroupingBuilder old, Builder newParent, boolean updateQName) {
        DataBean data = CopyUtils.getdata(old, newParent, updateQName);
        QName newQName = data.qname;
        SchemaPath newSchemaPath = data.schemaPath;
        GroupingBuilderImpl copy = new GroupingBuilderImpl(newParent.getModuleName(), newParent.getLine(), newQName, newSchemaPath);
        copy.setParent(newParent);
        copy.setDescription(old.getDescription());
        copy.setReference(old.getReference());
        copy.setStatus(old.getStatus());
        copy.setAddedByUses(old.isAddedByUses());
        for (DataSchemaNodeBuilder childNode : old.getChildNodeBuilders()) {
            copy.addChildNode(CopyUtils.copy(childNode, (Builder)copy, updateQName));
        }
        copy.getGroupings().addAll(old.getGroupings());
        for (GroupingBuilder grouping : old.getGroupingBuilders()) {
            copy.addGrouping(CopyUtils.copy(grouping, (Builder)copy, updateQName));
        }
        for (TypeDefinitionBuilder tdb : old.getTypeDefinitionBuilders()) {
            copy.addTypedef(CopyUtils.copy(tdb, (Builder)copy, updateQName));
        }
        for (UsesNodeBuilder oldUses : old.getUsesNodeBuilders()) {
            copy.addUsesNode(CopyUtils.copyUses(oldUses, copy));
        }
        for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
            copy.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)copy, updateQName));
        }
        return copy;
    }

    public static TypeDefinitionBuilder copy(TypeDefinitionBuilder old, Builder newParent, boolean updateQName) {
        AbstractTypeAwareBuilder type;
        DataBean data = CopyUtils.getdata(old, newParent, updateQName);
        QName newQName = data.qname;
        SchemaPath newSchemaPath = data.schemaPath;
        if (old instanceof UnionTypeBuilder) {
            UnionTypeBuilder oldUnion = (UnionTypeBuilder)old;
            type = new UnionTypeBuilder(newParent.getModuleName(), newParent.getLine());
            type.setParent(newParent);
            for (TypeDefinition<?> td : oldUnion.getTypes()) {
                type.setType(td);
            }
            for (TypeDefinitionBuilder tdb : oldUnion.getTypedefs()) {
                type.setTypedef(CopyUtils.copy(tdb, (Builder)type, updateQName));
            }
        } else if (old instanceof IdentityrefTypeBuilder) {
            type = new IdentityrefTypeBuilder(newParent.getModuleName(), newParent.getLine(), ((IdentityrefTypeBuilder)old).getBaseString(), newSchemaPath);
            type.setParent(newParent);
        } else {
            type = new TypeDefinitionBuilderImpl(old.getModuleName(), newParent.getLine(), newQName, old.getPath());
            type.setParent(newParent);
            if (old.getType() == null) {
                type.setTypedef(CopyUtils.copy(old.getTypedef(), (Builder)type, updateQName));
            } else {
                type.setType(old.getType());
            }
            for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
                type.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)type, updateQName));
            }
            type.setRanges(old.getRanges());
            type.setLengths(old.getLengths());
            type.setPatterns(old.getPatterns());
            type.setFractionDigits(old.getFractionDigits());
            type.setDescription(old.getDescription());
            type.setReference(old.getReference());
            type.setStatus(old.getStatus());
            type.setUnits(old.getUnits());
            type.setDefaultValue(old.getDefaultValue());
            type.setAddedByUses(old.isAddedByUses());
        }
        return type;
    }

    private static ConstraintsBuilder copyConstraints(ConstraintsBuilder newConstraints, ConstraintsBuilder old) {
        newConstraints.getMustDefinitions().addAll(old.getMustDefinitions());
        newConstraints.addWhenCondition(old.getWhenCondition());
        newConstraints.setMandatory(old.isMandatory());
        newConstraints.setMinElements(old.getMinElements());
        newConstraints.setMaxElements(old.getMaxElements());
        return newConstraints;
    }

    private static UsesNodeBuilder copyUses(UsesNodeBuilder old, Builder newParent) {
        UsesNodeBuilderImpl copy = new UsesNodeBuilderImpl(newParent.getModuleName(), newParent.getLine(), old.getGroupingPath());
        copy.setParent(newParent);
        copy.setGroupingDefinition(old.getGroupingDefinition());
        copy.setGrouping(old.getGroupingBuilder());
        copy.setAddedByUses(old.isAddedByUses());
        copy.getAugmentations().addAll(old.getAugmentations());
        copy.getRefineNodes().addAll(old.getRefineNodes());
        copy.getRefines().addAll(old.getRefines());
        copy.setAugmenting(old.isAugmenting());
        copy.setResolved(old.isResolved());
        return copy;
    }

    private static AugmentationSchemaBuilder copyAugment(AugmentationSchemaBuilder old, Builder newParent) {
        AugmentationSchemaBuilderImpl copy = new AugmentationSchemaBuilderImpl(newParent.getModuleName(), newParent.getLine(), old.getTargetPathAsString(), old.getTargetPath(), old.getOrder());
        copy.setParent(newParent);
        copy.setCopyOf(old);
        copy.setDescription(old.getDescription());
        copy.setReference(old.getReference());
        copy.setStatus(old.getStatus());
        copy.addWhenCondition(old.getWhenCondition());
        for (DataSchemaNodeBuilder childNode : old.getChildNodeBuilders()) {
            copy.addChildNode(CopyUtils.copy(childNode, (Builder)copy, false));
        }
        for (UsesNodeBuilder oldUses : old.getUsesNodeBuilders()) {
            copy.addUsesNode(CopyUtils.copyUses(oldUses, copy));
        }
        for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
            copy.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)copy, false));
        }
        return copy;
    }

    public static UnknownSchemaNodeBuilderImpl copy(UnknownSchemaNodeBuilder old, Builder newParent, boolean updateQName) {
        DataBean data = CopyUtils.getdata(old, newParent, updateQName);
        QName newQName = data.qname;
        SchemaPath newSchemaPath = data.schemaPath;
        UnknownSchemaNodeBuilderImpl c = new UnknownSchemaNodeBuilderImpl(newParent.getModuleName(), newParent.getLine(), newQName, newSchemaPath);
        c.setNodeType(old.getNodeType());
        c.setNodeParameter(old.getNodeParameter());
        c.setParent(newParent);
        c.setDescription(old.getDescription());
        c.setReference(old.getReference());
        c.setStatus(old.getStatus());
        c.setAddedByUses(old.isAddedByUses());
        for (UnknownSchemaNodeBuilder un : old.getUnknownNodes()) {
            c.addUnknownNodeBuilder(CopyUtils.copy(un, (Builder)c, updateQName));
        }
        c.setExtensionBuilder(old.getExtensionBuilder());
        c.setExtensionDefinition(old.getExtensionDefinition());
        return c;
    }

    private static DataBean getdata(SchemaNodeBuilder old, Builder newParent, boolean updateQName) {
        SchemaPath newSchemaPath;
        boolean identityrefTypeCheck = old instanceof IdentityrefTypeBuilder ? false : updateQName;
        QName newQName = null;
        if (newParent instanceof ModuleBuilder) {
            ModuleBuilder parent = (ModuleBuilder)newParent;
            newQName = identityrefTypeCheck ? QName.create((QNameModule)parent.getQNameModule(), (String)old.getQName().getLocalName()) : old.getQName();
            newSchemaPath = SchemaPath.create((boolean)true, (QName[])new QName[]{newQName});
        } else if (newParent instanceof AugmentationSchemaBuilder) {
            AugmentationSchemaBuilder augment = (AugmentationSchemaBuilder)newParent;
            ModuleBuilder parent = BuilderUtils.getParentModule(newParent);
            newQName = identityrefTypeCheck ? QName.create((QNameModule)parent.getQNameModule(), (String)old.getQName().getLocalName()) : old.getQName();
            newSchemaPath = augment.getTargetPath().createChild(new QName[]{newQName});
        } else if (newParent instanceof SchemaNodeBuilder) {
            SchemaNodeBuilder parent = (SchemaNodeBuilder)newParent;
            QName parentQName = parent.getQName();
            newQName = identityrefTypeCheck ? QName.create((QName)parentQName, (String)old.getQName().getLocalName()) : old.getQName();
            newSchemaPath = parent.getPath().createChild(new QName[]{newQName});
        } else {
            newSchemaPath = SchemaPath.ROOT;
        }
        return new DataBean(newQName, newSchemaPath);
    }

    private static final class DataBean {
        private final QName qname;
        private final SchemaPath schemaPath;

        private DataBean(QName qname, SchemaPath schemaPath) {
            this.qname = qname;
            this.schemaPath = schemaPath;
        }
    }
}

