/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractBuilder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class DeviationBuilder
extends AbstractBuilder {
    private DeviationImpl instance;
    private final SchemaPath targetPath;
    private Deviation.Deviate deviate;
    private String reference;

    DeviationBuilder(String moduleName, int line, SchemaPath targetPath) {
        super(moduleName, line);
        this.targetPath = targetPath;
    }

    public Deviation build() {
        if (this.instance != null) {
            return this.instance;
        }
        if (this.targetPath == null) {
            throw new YangParseException(this.getModuleName(), this.getLine(), "Unresolved deviation target");
        }
        this.instance = new DeviationImpl(this.targetPath);
        this.instance.deviate = this.deviate;
        this.instance.reference = this.reference;
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    public SchemaPath getTargetPath() {
        return this.targetPath;
    }

    public void setDeviate(String deviate) {
        if ("not-supported".equals(deviate)) {
            this.deviate = Deviation.Deviate.NOT_SUPPORTED;
        } else if ("add".equals(deviate)) {
            this.deviate = Deviation.Deviate.ADD;
        } else if ("replace".equals(deviate)) {
            this.deviate = Deviation.Deviate.REPLACE;
        } else if ("delete".equals(deviate)) {
            this.deviate = Deviation.Deviate.DELETE;
        } else {
            throw new YangParseException(this.getModuleName(), this.getLine(), "Unsupported type of 'deviate' statement: " + deviate);
        }
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String toString() {
        return "deviation " + this.targetPath;
    }

    private static final class DeviationImpl
    implements Deviation {
        private final SchemaPath targetPath;
        private Deviation.Deviate deviate;
        private String reference;
        private ImmutableList<UnknownSchemaNode> unknownNodes;

        private DeviationImpl(SchemaPath targetPath) {
            this.targetPath = targetPath;
        }

        public SchemaPath getTargetPath() {
            return this.targetPath;
        }

        public Deviation.Deviate getDeviate() {
            return this.deviate;
        }

        public String getReference() {
            return this.reference;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return this.unknownNodes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.targetPath == null ? 0 : this.targetPath.hashCode());
            result = 31 * result + (this.deviate == null ? 0 : this.deviate.hashCode());
            result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeviationImpl other = (DeviationImpl)obj;
            if (this.targetPath == null ? other.targetPath != null : !this.targetPath.equals((Object)other.targetPath)) {
                return false;
            }
            if (this.deviate == null ? other.deviate != null : !this.deviate.equals((Object)other.deviate)) {
                return false;
            }
            return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(DeviationImpl.class.getSimpleName());
            sb.append("[");
            sb.append("targetPath=").append(this.targetPath);
            sb.append(", deviate=").append(this.deviate);
            sb.append(", reference=").append(this.reference);
            sb.append("]");
            return sb.toString();
        }
    }
}

