/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractSchemaNodeBuilder;

public final class FeatureBuilder
extends AbstractSchemaNodeBuilder {
    private FeatureDefinitionImpl instance;

    FeatureBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
    }

    @Override
    public FeatureDefinitionImpl build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = new FeatureDefinitionImpl(this.qname, this.schemaPath);
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    public String toString() {
        return "feature " + this.qname.getLocalName();
    }

    private static final class FeatureDefinitionImpl
    implements FeatureDefinition {
        private final QName qname;
        private final SchemaPath path;
        private String description;
        private String reference;
        private Status status;
        private ImmutableList<UnknownSchemaNode> unknownNodes;

        private FeatureDefinitionImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.path = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return this.unknownNodes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FeatureDefinitionImpl other = (FeatureDefinitionImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(FeatureDefinitionImpl.class.getSimpleName());
            sb.append("[name=").append(this.qname).append("]");
            return sb.toString();
        }
    }
}

