/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.CopyUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.GroupingDefinitionImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedDataNodeContainerBuilder;

public final class GroupingBuilderImpl
extends AbstractDocumentedDataNodeContainerBuilder
implements GroupingBuilder {
    private GroupingDefinitionImpl instance;
    private SchemaPath schemaPath;
    private boolean addedByUses;

    public GroupingBuilderImpl(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
    }

    public GroupingBuilderImpl(String moduleName, int line, QName qname, SchemaPath path, GroupingDefinition base) {
        super(moduleName, line, base.getQName(), (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null"), (DataNodeContainer)base);
        this.schemaPath = path;
        this.addedByUses = base.isAddedByUses();
        this.addedUnknownNodes.addAll(BuilderUtils.wrapUnknownNodes(moduleName, line, base.getUnknownSchemaNodes(), path, qname));
    }

    @Override
    public GroupingDefinition build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.buildChildren();
        this.instance = new GroupingDefinitionImpl(this.qname, this.schemaPath, this);
        this.instance.addedByUses = this.addedByUses;
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    @Override
    public List<DataSchemaNodeBuilder> instantiateChildNodes(Builder newParent) {
        ArrayList<DataSchemaNodeBuilder> nodes = new ArrayList<DataSchemaNodeBuilder>();
        for (DataSchemaNodeBuilder node : this.getChildNodeBuilders()) {
            DataSchemaNodeBuilder copy = CopyUtils.copy(node, newParent, true);
            BuilderUtils.setNodeAddedByUses(copy);
            nodes.add(copy);
        }
        return nodes;
    }

    @Override
    public Set<TypeDefinitionBuilder> instantiateTypedefs(Builder newParent) {
        HashSet<TypeDefinitionBuilder> nodes = new HashSet<TypeDefinitionBuilder>();
        for (TypeDefinitionBuilder node : this.getTypeDefinitionBuilders()) {
            TypeDefinitionBuilder copy = CopyUtils.copy(node, newParent, true);
            nodes.add(copy);
        }
        return nodes;
    }

    @Override
    public Set<GroupingBuilder> instantiateGroupings(Builder newParent) {
        HashSet<GroupingBuilder> nodes = new HashSet<GroupingBuilder>();
        for (GroupingBuilder node : this.getGroupingBuilders()) {
            GroupingBuilder copy = CopyUtils.copy(node, newParent, true);
            copy.setAddedByUses(true);
            for (DataSchemaNodeBuilder childNode : copy.getChildNodeBuilders()) {
                BuilderUtils.setNodeAddedByUses(childNode);
            }
            nodes.add(copy);
        }
        return nodes;
    }

    @Override
    public Set<UnknownSchemaNodeBuilder> instantiateUnknownNodes(Builder newParent) {
        HashSet<UnknownSchemaNodeBuilder> nodes = new HashSet<UnknownSchemaNodeBuilder>();
        for (UnknownSchemaNodeBuilder node : this.addedUnknownNodes) {
            UnknownSchemaNodeBuilderImpl copy = CopyUtils.copy(node, newParent, true);
            copy.setAddedByUses(true);
            nodes.add(copy);
        }
        return nodes;
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.schemaPath = path;
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    public String toString() {
        return "grouping " + this.qname.getLocalName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getParent() == null ? 0 : this.getParent().hashCode());
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GroupingBuilderImpl other = (GroupingBuilderImpl)obj;
        if (this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent())) {
            return false;
        }
        return !(this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath));
    }

    @Override
    protected String getStatementName() {
        return "grouping";
    }
}

