/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Splitter;
import java.net.URI;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.RefineBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RefineUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GroupingUtils.class);
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');

    private GroupingUtils() {
    }

    public static GroupingBuilder getTargetGroupingFromModules(UsesNodeBuilder usesBuilder, Map<URI, NavigableMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        int line = usesBuilder.getLine();
        SchemaPath groupingPath = usesBuilder.getTargetGroupingPath();
        QName groupingName = (QName)groupingPath.getPathFromRoot().iterator().next();
        ModuleBuilder dependentModule = BuilderUtils.findModule(groupingName, modules);
        Set<GroupingBuilder> groupings = dependentModule.getGroupingBuilders();
        GroupingBuilder result = GroupingUtils.findGroupingBuilder(groupings, groupingName.getLocalName());
        if (result != null) {
            return result;
        }
        for (Builder parent = usesBuilder.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof DataNodeContainerBuilder) {
                groupings = parent.getGroupingBuilders();
            } else if (parent instanceof RpcDefinitionBuilder) {
                groupings = ((RpcDefinitionBuilder)parent).getGroupings();
            }
            result = GroupingUtils.findGroupingBuilder(groupings, groupingName.getLocalName());
            if (result != null) break;
        }
        if (result == null) {
            throw new YangParseException(module.getName(), line, "Grouping '" + groupingName + "' not found.");
        }
        return result;
    }

    private static GroupingBuilder findGroupingBuilder(Set<GroupingBuilder> groupings, String name) {
        for (GroupingBuilder grouping : groupings) {
            if (!grouping.getQName().getLocalName().equals(name)) continue;
            return grouping;
        }
        return null;
    }

    public static void performRefine(UsesNodeBuilder usesNode) {
        for (RefineBuilder refine : usesNode.getRefines()) {
            String refineTargetPath = refine.getTargetPathString();
            Builder currentNode = usesNode.getParent();
            for (String pathElement : SLASH_SPLITTER.split((CharSequence)refineTargetPath)) {
                if (currentNode instanceof DataNodeContainerBuilder) {
                    currentNode = currentNode.getDataChildByName(pathElement);
                    continue;
                }
                if (!(currentNode instanceof ChoiceBuilder)) continue;
                currentNode = ((ChoiceBuilder)currentNode).getCaseNodeByName(pathElement);
            }
            DataSchemaNodeBuilder nodeToRefine = (DataSchemaNodeBuilder)currentNode;
            if (nodeToRefine == null) {
                LOG.warn("Error in module {} at line {}: Refine target node {} not found.", new Object[]{refine.getModuleName(), refine.getLine(), refine.getTargetPathString()});
                continue;
            }
            RefineUtils.performRefine(nodeToRefine, refine);
            usesNode.addRefineNode(nodeToRefine);
        }
    }

    private static int getElementPosition(UsesNodeBuilder usesNode) {
        int i = 0;
        Builder parent = usesNode.getParent();
        while (!(parent instanceof ModuleBuilder)) {
            parent = parent.getParent();
            ++i;
        }
        return i;
    }

    public static class UsesComparator
    implements Comparator<UsesNodeBuilder> {
        @Override
        public int compare(UsesNodeBuilder o1, UsesNodeBuilder o2) {
            return GroupingUtils.getElementPosition(o2) - GroupingUtils.getElementPosition(o1);
        }
    }
}

