/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentitySchemaNodeImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractSchemaNodeBuilder;

public final class IdentitySchemaNodeBuilder
extends AbstractSchemaNodeBuilder {
    private IdentitySchemaNodeImpl instance;
    private IdentitySchemaNode baseIdentity;
    private IdentitySchemaNodeBuilder baseIdentityBuilder;
    private final Set<IdentitySchemaNode> derivedIdentities = new HashSet<IdentitySchemaNode>();
    private String baseIdentityName;

    IdentitySchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
    }

    IdentitySchemaNodeBuilder(String moduleName, IdentitySchemaNode base) {
        super(moduleName, 0, base.getQName());
        this.schemaPath = base.getPath();
        this.derivedIdentities.addAll(base.getDerivedIdentities());
        this.unknownNodes.addAll(base.getUnknownSchemaNodes());
    }

    public IdentitySchemaNode build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = new IdentitySchemaNodeImpl(this.qname, this.schemaPath, this.derivedIdentities);
        this.instance.description = this.description;
        this.instance.reference = this.reference;
        this.instance.status = this.status;
        if (this.baseIdentityBuilder != null) {
            this.baseIdentityBuilder.addDerivedIdentity(this.instance);
            this.baseIdentity = this.baseIdentityBuilder.build();
        }
        this.instance.baseIdentity = this.baseIdentity;
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    public String getBaseIdentityName() {
        return this.baseIdentityName;
    }

    public void setBaseIdentityName(String baseIdentityName) {
        this.baseIdentityName = baseIdentityName;
    }

    public void setBaseIdentity(IdentitySchemaNodeBuilder baseType) {
        this.baseIdentityBuilder = baseType;
    }

    void addDerivedIdentity(IdentitySchemaNode derivedIdentity) {
        if (derivedIdentity != null) {
            this.derivedIdentities.add(derivedIdentity);
        }
    }

    public String toString() {
        return "identity " + this.qname.getLocalName();
    }
}

