/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

final class IdentitySchemaNodeImpl
implements IdentitySchemaNode {
    private final QName qname;
    private final SchemaPath path;
    IdentitySchemaNode baseIdentity;
    private final Set<IdentitySchemaNode> derivedIdentities;
    String description;
    String reference;
    Status status;
    ImmutableList<UnknownSchemaNode> unknownNodes;

    IdentitySchemaNodeImpl(QName qname, SchemaPath path, Set<IdentitySchemaNode> derivedIdentities) {
        this.qname = qname;
        this.path = path;
        this.derivedIdentities = derivedIdentities;
    }

    public QName getQName() {
        return this.qname;
    }

    public IdentitySchemaNode getBaseIdentity() {
        return this.baseIdentity;
    }

    public Set<IdentitySchemaNode> getDerivedIdentities() {
        return Collections.unmodifiableSet(this.derivedIdentities);
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public Status getStatus() {
        return this.status;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentitySchemaNodeImpl other = (IdentitySchemaNodeImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(IdentitySchemaNodeImpl.class.getSimpleName());
        sb.append("[");
        sb.append("base=").append(this.baseIdentity);
        sb.append(", qname=").append(this.qname);
        sb.append("]");
        return sb.toString();
    }
}

