/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.parser.builder.api.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafListSchemaNodeImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractTypeAwareBuilder;

public final class LeafListSchemaNodeBuilder
extends AbstractTypeAwareBuilder
implements DataSchemaNodeBuilder {
    private LeafListSchemaNodeImpl instance;
    private boolean userOrdered;
    private SchemaPath schemaPath;
    private String description;
    private String reference;
    private Status status = Status.CURRENT;
    private boolean augmenting;
    private boolean addedByUses;
    private LeafListSchemaNode originalNode;
    private LeafListSchemaNodeBuilder originalBuilder;
    private boolean configuration;
    private final ConstraintsBuilder constraints;

    public LeafListSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
        this.constraints = new ConstraintsBuilderImpl(moduleName, line);
    }

    public LeafListSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path, LeafListSchemaNode base) {
        super(moduleName, line, qname);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
        this.constraints = new ConstraintsBuilderImpl(moduleName, line, base.getConstraints());
        this.description = base.getDescription();
        this.reference = base.getReference();
        this.status = base.getStatus();
        this.augmenting = base.isAugmenting();
        this.addedByUses = base.isAddedByUses();
        this.originalNode = base;
        this.configuration = base.isConfiguration();
        this.type = base.getType();
        this.userOrdered = base.isUserOrdered();
        this.unknownNodes.addAll(base.getUnknownSchemaNodes());
    }

    public LeafListSchemaNode build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = new LeafListSchemaNodeImpl(this.qname, this.schemaPath);
        this.instance.description = this.description;
        this.instance.reference = this.reference;
        this.instance.status = this.status;
        this.instance.augmenting = this.augmenting;
        this.instance.addedByUses = this.addedByUses;
        this.instance.configuration = this.configuration;
        this.instance.constraintsDef = this.constraints.toInstance();
        this.instance.userOrdered = this.userOrdered;
        this.instance.type = this.type == null ? this.typedef.build() : this.type;
        if (this.originalNode == null && this.originalBuilder != null) {
            this.originalNode = this.originalBuilder.build();
        }
        this.instance.original = this.originalNode;
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.schemaPath = path;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Status status) {
        this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status cannot be null");
    }

    @Override
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    @Override
    public LeafListSchemaNodeBuilder getOriginal() {
        return this.originalBuilder;
    }

    @Override
    public void setOriginal(SchemaNodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof LeafListSchemaNodeBuilder), (Object)("Original of leaf-list cannot be " + builder));
        this.originalBuilder = (LeafListSchemaNodeBuilder)builder;
    }

    @Override
    public boolean isConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(boolean configuration) {
        this.configuration = configuration;
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    public boolean isUserOrdered() {
        return this.userOrdered;
    }

    public void setUserOrdered(boolean userOrdered) {
        this.userOrdered = userOrdered;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeafListSchemaNodeBuilder other = (LeafListSchemaNodeBuilder)obj;
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        return !(this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent()));
    }

    public String toString() {
        return "leaf-list " + this.qname.getLocalName();
    }
}

