/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.ListSchemaNodeImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class ListSchemaNodeBuilder
extends AbstractDocumentedDataNodeContainerBuilder
implements DataSchemaNodeBuilder,
AugmentationTargetBuilder {
    private ListSchemaNodeImpl instance;
    private boolean userOrdered;
    private Set<String> keys;
    private List<QName> keyDefinition;
    private SchemaPath schemaPath;
    private boolean augmenting;
    private boolean addedByUses;
    private ListSchemaNodeBuilder originalBuilder;
    private ListSchemaNode originalNode;
    private boolean configuration;
    private final ConstraintsBuilder constraints;
    private final List<AugmentationSchema> augmentations = new ArrayList<AugmentationSchema>();
    private final List<AugmentationSchemaBuilder> augmentationBuilders = new ArrayList<AugmentationSchemaBuilder>();

    public ListSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
        this.constraints = new ConstraintsBuilderImpl(moduleName, line);
    }

    public ListSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path, ListSchemaNode base) {
        super(moduleName, line, qname, path, (DataNodeContainer)base);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
        this.constraints = new ConstraintsBuilderImpl(moduleName, line, base.getConstraints());
        this.keyDefinition = ImmutableList.copyOf((Collection)base.getKeyDefinition());
        this.userOrdered = base.isUserOrdered();
        this.augmenting = base.isAugmenting();
        this.addedByUses = base.isAddedByUses();
        this.originalNode = base;
        this.configuration = base.isConfiguration();
        this.addedUnknownNodes.addAll(BuilderUtils.wrapUnknownNodes(moduleName, line, base.getUnknownSchemaNodes(), path, qname));
        this.augmentations.addAll(base.getAvailableAugmentations());
    }

    public ListSchemaNode build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.buildChildren();
        this.instance = new ListSchemaNodeImpl(this.qname, this.schemaPath, this);
        this.instance.augmenting = this.augmenting;
        this.instance.addedByUses = this.addedByUses;
        this.instance.configuration = this.configuration;
        this.instance.constraints = this.constraints.toInstance();
        this.instance.userOrdered = this.userOrdered;
        if (this.keys != null) {
            this.keyDefinition = new ArrayList<QName>();
            for (String key : this.keys) {
                DataSchemaNode keyPart = this.instance.getDataChildByName(key);
                if (keyPart == null) {
                    throw new YangParseException(this.getModuleName(), this.getLine(), "Failed to resolve list key for name " + key);
                }
                if (!(keyPart instanceof LeafSchemaNode)) {
                    throw new YangParseException(this.getModuleName(), this.getLine(), "List key : \"" + key + "\" does not reference any Leaf of the List");
                }
                QName qname = keyPart.getQName();
                if (this.keyDefinition.contains(qname)) continue;
                this.keyDefinition.add(qname);
            }
            this.instance.keyDefinition = ImmutableList.copyOf(this.keyDefinition);
        } else {
            this.instance.keyDefinition = ImmutableList.of();
        }
        if (this.originalNode == null && this.originalBuilder != null) {
            this.originalNode = this.originalBuilder.build();
        }
        this.instance.original = this.originalNode;
        for (AugmentationSchemaBuilder builder : this.augmentationBuilders) {
            this.augmentations.add(builder.build());
        }
        this.instance.augmentations = ImmutableSet.copyOf(this.augmentations);
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    @Override
    protected String getStatementName() {
        return "list";
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.schemaPath = path;
    }

    @Override
    public void addAugmentation(AugmentationSchemaBuilder augment) {
        this.augmentationBuilders.add(augment);
    }

    public List<AugmentationSchemaBuilder> getAugmentationBuilders() {
        return this.augmentationBuilders;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public void setKeys(Set<String> keys) {
        this.keys = keys;
    }

    @Override
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    @Override
    public ListSchemaNodeBuilder getOriginal() {
        return this.originalBuilder;
    }

    @Override
    public void setOriginal(SchemaNodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof ListSchemaNodeBuilder), (Object)("Original of list cannot be " + builder));
        this.originalBuilder = (ListSchemaNodeBuilder)builder;
    }

    @Override
    public boolean isConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(boolean configuration) {
        this.configuration = configuration;
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    public boolean isUserOrdered() {
        return this.userOrdered;
    }

    public void setUserOrdered(boolean userOrdered) {
        this.userOrdered = userOrdered;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListSchemaNodeBuilder other = (ListSchemaNodeBuilder)obj;
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        return !(this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent()));
    }

    public String toString() {
        return "list " + this.qname.getLocalName();
    }
}

