/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.util.ModuleImportImpl;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DocumentedNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.ExtensionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeAwareBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AnyXmlBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AugmentationSchemaBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.DeviationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ExtensionBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.FeatureBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.GroupingBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentitySchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.NotificationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RefineHolderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.TypeDefinitionBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UsesNodeBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public class ModuleBuilder
extends AbstractDocumentedDataNodeContainerBuilder
implements DocumentedNodeBuilder {
    private static final QNameModule EMPTY_QNAME_MODULE = QNameModule.cachedReference((QNameModule)QNameModule.create(null, null));
    private static final String GROUPING_STR = "Grouping";
    private static final String TYPEDEF_STR = "typedef";
    private ModuleImpl instance;
    private final String name;
    private final String sourcePath;
    private static final SchemaPath SCHEMA_PATH = SchemaPath.create(Collections.emptyList(), (boolean)true);
    private String prefix;
    private QNameModule qnameModule = EMPTY_QNAME_MODULE;
    private final boolean submodule;
    private String belongsTo;
    private ModuleBuilder parent;
    private final Deque<Builder> actualPath = new LinkedList<Builder>();
    private final Set<TypeAwareBuilder> dirtyNodes = new HashSet<TypeAwareBuilder>();
    final Map<String, ModuleImport> imports = new HashMap<String, ModuleImport>();
    final Map<String, ModuleBuilder> importedModules = new HashMap<String, ModuleBuilder>();
    final Set<ModuleBuilder> addedSubmodules = new HashSet<ModuleBuilder>();
    final Set<Module> submodules = new HashSet<Module>();
    final Map<String, Date> includedModules = new HashMap<String, Date>();
    private final Set<AugmentationSchema> augments = new LinkedHashSet<AugmentationSchema>();
    private final List<AugmentationSchemaBuilder> augmentBuilders = new ArrayList<AugmentationSchemaBuilder>();
    private final List<AugmentationSchemaBuilder> allAugments = new ArrayList<AugmentationSchemaBuilder>();
    private final List<GroupingBuilder> allGroupings = new ArrayList<GroupingBuilder>();
    private final List<UsesNodeBuilder> allUsesNodes = new ArrayList<UsesNodeBuilder>();
    private final Set<RpcDefinition> rpcs = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<RpcDefinitionBuilder> addedRpcs = new HashSet<RpcDefinitionBuilder>();
    private final Set<NotificationDefinition> notifications = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<NotificationBuilder> addedNotifications = new HashSet<NotificationBuilder>();
    private final Set<IdentitySchemaNode> identities = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<IdentitySchemaNodeBuilder> addedIdentities = new HashSet<IdentitySchemaNodeBuilder>();
    private final Set<FeatureDefinition> features = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<FeatureBuilder> addedFeatures = new HashSet<FeatureBuilder>();
    private final Set<Deviation> deviations = new HashSet<Deviation>();
    private final Set<DeviationBuilder> deviationBuilders = new HashSet<DeviationBuilder>();
    private final List<ExtensionDefinition> extensions = new ArrayList<ExtensionDefinition>();
    private final List<ExtensionBuilder> addedExtensions = new ArrayList<ExtensionBuilder>();
    private final List<UnknownSchemaNodeBuilder> allUnknownNodes = new ArrayList<UnknownSchemaNodeBuilder>();
    private final List<ListSchemaNodeBuilder> allLists = new ArrayList<ListSchemaNodeBuilder>();
    private String source;
    private String yangVersion;
    private String organization;
    private String contact;

    public ModuleBuilder(String name, String sourcePath) {
        this(name, false, sourcePath);
    }

    public ModuleBuilder(String name, boolean submodule, String sourcePath) {
        super(name, 0, (QName)null);
        this.name = name;
        this.sourcePath = sourcePath;
        this.submodule = submodule;
        this.actualPath.push(this);
    }

    public ModuleBuilder(Module base) {
        super(base.getName(), 0, QName.create((QNameModule)base.getQNameModule(), (String)base.getName()), SCHEMA_PATH, (DataNodeContainer)base);
        this.name = base.getName();
        this.sourcePath = base.getModuleSourcePath();
        this.submodule = false;
        this.yangVersion = base.getYangVersion();
        this.actualPath.push(this);
        this.prefix = base.getPrefix();
        this.qnameModule = base.getQNameModule();
        this.augments.addAll(base.getAugmentations());
        this.rpcs.addAll(base.getRpcs());
        this.notifications.addAll(base.getNotifications());
        for (IdentitySchemaNode identityNode : base.getIdentities()) {
            this.addedIdentities.add(new IdentitySchemaNodeBuilder(this.name, identityNode));
        }
        this.features.addAll(base.getFeatures());
        this.deviations.addAll(base.getDeviations());
        this.extensions.addAll(base.getExtensionSchemaNodes());
        this.unknownNodes.addAll(base.getUnknownSchemaNodes());
        this.source = base.getSource();
    }

    @Override
    protected String getStatementName() {
        return "module";
    }

    public Module build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.buildChildren();
        for (ModuleBuilder moduleBuilder : this.addedSubmodules) {
            this.submodules.add(moduleBuilder.build());
        }
        for (FeatureBuilder featureBuilder : this.addedFeatures) {
            this.features.add(featureBuilder.build());
        }
        for (NotificationBuilder notificationBuilder : this.addedNotifications) {
            this.notifications.add(notificationBuilder.build());
        }
        for (AugmentationSchemaBuilder augmentationSchemaBuilder : this.augmentBuilders) {
            this.augments.add(augmentationSchemaBuilder.build());
        }
        for (RpcDefinitionBuilder rpcDefinitionBuilder : this.addedRpcs) {
            this.rpcs.add(rpcDefinitionBuilder.build());
        }
        for (DeviationBuilder deviationBuilder : this.deviationBuilders) {
            this.deviations.add(deviationBuilder.build());
        }
        for (ExtensionBuilder extensionBuilder : this.addedExtensions) {
            this.extensions.add(extensionBuilder.build());
        }
        Collections.sort(this.extensions, Comparators.SCHEMA_NODE_COMP);
        for (IdentitySchemaNodeBuilder identitySchemaNodeBuilder : this.addedIdentities) {
            this.identities.add(identitySchemaNodeBuilder.build());
        }
        for (UnknownSchemaNodeBuilder unknownSchemaNodeBuilder : this.addedUnknownNodes) {
            this.unknownNodes.add(unknownSchemaNodeBuilder.build());
        }
        Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
        this.instance = new ModuleImpl(this.name, this.sourcePath, this);
        return this.instance;
    }

    public String getModuleSourcePath() {
        return this.sourcePath;
    }

    @Override
    public ModuleBuilder getParent() {
        return this.parent;
    }

    public void setParent(ModuleBuilder parent) {
        this.parent = parent;
    }

    @Override
    public void setParent(Builder parent) {
        throw new YangParseException(this.name, 0, "Can not set parent to module");
    }

    @Override
    public SchemaPath getPath() {
        return SCHEMA_PATH;
    }

    public void enterNode(Builder node) {
        this.actualPath.push(node);
    }

    public void exitNode() {
        this.actualPath.pop();
    }

    public Builder getActualNode() {
        if (this.actualPath.isEmpty()) {
            return null;
        }
        return this.actualPath.peekFirst();
    }

    public Set<TypeAwareBuilder> getDirtyNodes() {
        return this.dirtyNodes;
    }

    public Set<AugmentationSchema> getAugments() {
        return this.augments;
    }

    public List<AugmentationSchemaBuilder> getAugmentBuilders() {
        return this.augmentBuilders;
    }

    public List<AugmentationSchemaBuilder> getAllAugments() {
        return this.allAugments;
    }

    public Set<IdentitySchemaNode> getIdentities() {
        return this.identities;
    }

    public Set<IdentitySchemaNodeBuilder> getAddedIdentities() {
        return this.addedIdentities;
    }

    public Set<FeatureDefinition> getFeatures() {
        return this.features;
    }

    public Set<FeatureBuilder> getAddedFeatures() {
        return this.addedFeatures;
    }

    public List<GroupingBuilder> getAllGroupings() {
        return this.allGroupings;
    }

    public List<UsesNodeBuilder> getAllUsesNodes() {
        return this.allUsesNodes;
    }

    public Set<Deviation> getDeviations() {
        return this.deviations;
    }

    public Set<DeviationBuilder> getDeviationBuilders() {
        return this.deviationBuilders;
    }

    public List<ExtensionDefinition> getExtensions() {
        return this.extensions;
    }

    public List<ExtensionBuilder> getAddedExtensions() {
        return this.addedExtensions;
    }

    public List<UnknownSchemaNodeBuilder> getAllUnknownNodes() {
        return this.allUnknownNodes;
    }

    public List<ListSchemaNodeBuilder> getAllLists() {
        return this.allLists;
    }

    public String getName() {
        return this.name;
    }

    public URI getNamespace() {
        return this.qnameModule.getNamespace();
    }

    public QNameModule getQNameModule() {
        return this.qnameModule;
    }

    public void setQNameModule(QNameModule qnameModule) {
        this.qnameModule = (QNameModule)Preconditions.checkNotNull((Object)qnameModule);
    }

    public void setNamespace(URI namespace) {
        this.qnameModule = QNameModule.cachedReference((QNameModule)QNameModule.create((URI)namespace, (Date)this.qnameModule.getRevision()));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Date getRevision() {
        return this.qnameModule.getRevision();
    }

    public ModuleImport getImport(String prefix) {
        return this.imports.get(prefix);
    }

    public Map<String, ModuleImport> getImports() {
        return this.imports;
    }

    public ModuleBuilder getImportedModule(String prefix) {
        return this.importedModules.get(prefix);
    }

    public void addImportedModule(String prefix, ModuleBuilder module) {
        this.checkPrefix(prefix);
        this.importedModules.put(prefix, module);
    }

    public Map<String, Date> getIncludedModules() {
        return this.includedModules;
    }

    public void addInclude(String name, Date revision) {
        this.includedModules.put(name, revision);
    }

    public void addSubmodule(ModuleBuilder submodule) {
        this.addedSubmodules.add(submodule);
    }

    protected String getSource() {
        return this.source;
    }

    public boolean isSubmodule() {
        return this.submodule;
    }

    public String getBelongsTo() {
        return this.belongsTo;
    }

    public void setBelongsTo(String belongsTo) {
        this.belongsTo = belongsTo;
    }

    public void markActualNodeDirty() {
        TypeAwareBuilder nodeBuilder = (TypeAwareBuilder)this.getActualNode();
        this.dirtyNodes.add(nodeBuilder);
    }

    public void setRevision(Date revision) {
        this.qnameModule = QNameModule.cachedReference((QNameModule)QNameModule.create((URI)this.qnameModule.getNamespace(), (Date)revision));
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setYangVersion(String yangVersion) {
        this.yangVersion = yangVersion;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public void addModuleImport(String moduleName, Date revision, String prefix) {
        this.checkPrefix(prefix);
        this.checkNotSealed();
        ModuleImportImpl moduleImport = new ModuleImportImpl(moduleName, revision, prefix);
        this.imports.put(prefix, (ModuleImport)moduleImport);
    }

    private void checkPrefix(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IllegalArgumentException("Cannot add imported module with undefined prefix");
        }
        if (prefix.equals(this.prefix)) {
            throw new IllegalArgumentException("Cannot add imported module with prefix equals to module prefix");
        }
    }

    public ExtensionBuilder addExtension(QName qname, int line, SchemaPath path) {
        this.checkNotSealed();
        Builder parentBuilder = this.getActualNode();
        if (!parentBuilder.equals(this)) {
            throw new YangParseException(this.name, line, "extension can be defined only in module or submodule");
        }
        String extName = qname.getLocalName();
        for (ExtensionBuilder addedExtension : this.addedExtensions) {
            if (!addedExtension.getQName().getLocalName().equals(extName)) continue;
            this.raiseYangParserException("extension", "node", extName, line, addedExtension.getLine());
        }
        ExtensionBuilderImpl builder = new ExtensionBuilderImpl(this.name, line, qname, path);
        builder.setParent(parentBuilder);
        this.addedExtensions.add(builder);
        return builder;
    }

    public ContainerSchemaNodeBuilder addContainerNode(int line, QName qname, SchemaPath schemaPath) {
        this.checkNotSealed();
        ContainerSchemaNodeBuilder builder = new ContainerSchemaNodeBuilder(this.name, line, qname, schemaPath);
        Builder parentBuilder = this.getActualNode();
        builder.setParent(parentBuilder);
        this.addChildToParent(parentBuilder, builder, qname.getLocalName());
        return builder;
    }

    public ListSchemaNodeBuilder addListNode(int line, QName qname, SchemaPath schemaPath) {
        this.checkNotSealed();
        ListSchemaNodeBuilder builder = new ListSchemaNodeBuilder(this.name, line, qname, schemaPath);
        Builder parentBuilder = this.getActualNode();
        builder.setParent(parentBuilder);
        this.addChildToParent(parentBuilder, builder, qname.getLocalName());
        this.allLists.add(builder);
        return builder;
    }

    public LeafSchemaNodeBuilder addLeafNode(int line, QName qname, SchemaPath schemaPath) {
        this.checkNotSealed();
        LeafSchemaNodeBuilder builder = new LeafSchemaNodeBuilder(this.name, line, qname, schemaPath);
        Builder parentBuilder = this.getActualNode();
        builder.setParent(parentBuilder);
        this.addChildToParent(parentBuilder, builder, qname.getLocalName());
        return builder;
    }

    public LeafListSchemaNodeBuilder addLeafListNode(int line, QName qname, SchemaPath schemaPath) {
        this.checkNotSealed();
        LeafListSchemaNodeBuilder builder = new LeafListSchemaNodeBuilder(this.name, line, qname, schemaPath);
        Builder parentBuilder = this.getActualNode();
        builder.setParent(parentBuilder);
        this.addChildToParent(parentBuilder, builder, qname.getLocalName());
        return builder;
    }

    public GroupingBuilder addGrouping(int line, QName qname, SchemaPath path) {
        this.checkNotSealed();
        GroupingBuilderImpl builder = new GroupingBuilderImpl(this.name, line, qname, path);
        Builder parentBuilder = this.getActualNode();
        builder.setParent(parentBuilder);
        String groupingName = qname.getLocalName();
        if (parentBuilder.equals(this)) {
            for (GroupingBuilder addedGrouping : this.getGroupingBuilders()) {
                if (!addedGrouping.getQName().getLocalName().equals(groupingName)) continue;
                this.raiseYangParserException("", GROUPING_STR, groupingName, line, addedGrouping.getLine());
            }
            this.addGrouping(builder);
        } else if (parentBuilder instanceof DataNodeContainerBuilder) {
            DataNodeContainerBuilder parentNode = (DataNodeContainerBuilder)parentBuilder;
            for (GroupingBuilder addedGrouping : parentNode.getGroupingBuilders()) {
                if (!addedGrouping.getQName().getLocalName().equals(groupingName)) continue;
                this.raiseYangParserException("", GROUPING_STR, groupingName, line, addedGrouping.getLine());
            }
            parentNode.addGrouping(builder);
        } else if (parentBuilder instanceof RpcDefinitionBuilder) {
            RpcDefinitionBuilder parentNode = (RpcDefinitionBuilder)parentBuilder;
            for (GroupingBuilder child : parentNode.getGroupings()) {
                if (!child.getQName().getLocalName().equals(groupingName)) continue;
                this.raiseYangParserException("", GROUPING_STR, groupingName, line, child.getLine());
            }
            parentNode.addGrouping(builder);
        } else {
            throw new YangParseException(this.name, line, "Unresolved parent of grouping " + groupingName);
        }
        this.allGroupings.add(builder);
        return builder;
    }

    public AugmentationSchemaBuilder addAugment(int line, String augmentTargetStr, SchemaPath targetPath, int order) {
        this.checkNotSealed();
        AugmentationSchemaBuilderImpl builder = new AugmentationSchemaBuilderImpl(this.name, line, augmentTargetStr, targetPath, order);
        Builder parentBuilder = this.getActualNode();
        builder.setParent(parentBuilder);
        if (parentBuilder.equals(this)) {
            if (!augmentTargetStr.startsWith("/")) {
                throw new YangParseException(this.name, line, "If the 'augment' statement is on the top level in a module, the absolute form of a schema node identifier MUST be used.");
            }
            this.augmentBuilders.add(builder);
        } else if (parentBuilder instanceof UsesNodeBuilder) {
            if (augmentTargetStr.startsWith("/")) {
                throw new YangParseException(this.name, line, "If 'augment' statement is a substatement to the 'uses' statement, it cannot contain absolute path (" + augmentTargetStr + ")");
            }
            ((UsesNodeBuilder)parentBuilder).addAugment(builder);
        } else {
            throw new YangParseException(this.name, line, "Augment can be declared only under module or uses statement.");
        }
        this.allAugments.add(builder);
        return builder;
    }

    public UsesNodeBuilder addUsesNode(int line, SchemaPath grouping) {
        this.checkNotSealed();
        UsesNodeBuilderImpl usesBuilder = new UsesNodeBuilderImpl(this.name, line, grouping);
        Builder parentBuilder = this.getActualNode();
        usesBuilder.setParent(parentBuilder);
        if (parentBuilder.equals(this)) {
            this.addUsesNode(usesBuilder);
        } else {
            if (!(parentBuilder instanceof DataNodeContainerBuilder)) {
                throw new YangParseException(this.name, line, "Unresolved parent of uses '" + grouping + "'.");
            }
            ((DataNodeContainerBuilder)parentBuilder).addUsesNode(usesBuilder);
        }
        if (parentBuilder instanceof AugmentationSchemaBuilder) {
            usesBuilder.setAugmenting(true);
        }
        this.allUsesNodes.add(usesBuilder);
        return usesBuilder;
    }

    public void addRefine(RefineHolderImpl refine) {
        this.checkNotSealed();
        Builder parentBuilder = this.getActualNode();
        if (!(parentBuilder instanceof UsesNodeBuilder)) {
            throw new YangParseException(this.name, refine.getLine(), "refine can be defined only in uses statement");
        }
        ((UsesNodeBuilder)parentBuilder).addRefine(refine);
        refine.setParent(parentBuilder);
    }

    public RpcDefinitionBuilder addRpc(int line, QName qname, SchemaPath path) {
        this.checkNotSealed();
        Builder parentBuilder = this.getActualNode();
        if (!parentBuilder.equals(this)) {
            throw new YangParseException(this.name, line, "rpc can be defined only in module or submodule");
        }
        RpcDefinitionBuilder rpcBuilder = new RpcDefinitionBuilder(this.name, line, qname, path);
        rpcBuilder.setParent(parentBuilder);
        String rpcName = qname.getLocalName();
        this.checkNotConflictingInDataNamespace(rpcName, line);
        this.addedRpcs.add(rpcBuilder);
        return rpcBuilder;
    }

    private void checkNotConflictingInDataNamespace(String rpcName, int line) {
        for (DataSchemaNodeBuilder addedChild : this.getChildNodeBuilders()) {
            if (!addedChild.getQName().getLocalName().equals(rpcName)) continue;
            this.raiseYangParserException("rpc", "node", rpcName, line, addedChild.getLine());
        }
        for (RpcDefinitionBuilder rpc : this.addedRpcs) {
            if (!rpc.getQName().getLocalName().equals(rpcName)) continue;
            this.raiseYangParserException("", "rpc", rpcName, line, rpc.getLine());
        }
        for (NotificationBuilder addedNotification : this.addedNotifications) {
            if (!addedNotification.getQName().getLocalName().equals(rpcName)) continue;
            this.raiseYangParserException("rpc", "notification", rpcName, line, addedNotification.getLine());
        }
    }

    public ContainerSchemaNodeBuilder addRpcInput(int line, QName qname, SchemaPath schemaPath) {
        this.checkNotSealed();
        Builder parentBuilder = this.getActualNode();
        if (!(parentBuilder instanceof RpcDefinitionBuilder)) {
            throw new YangParseException(this.name, line, "input can be defined only in rpc statement");
        }
        RpcDefinitionBuilder rpc = (RpcDefinitionBuilder)parentBuilder;
        ContainerSchemaNodeBuilder inputBuilder = new ContainerSchemaNodeBuilder(this.name, line, qname, schemaPath);
        inputBuilder.setParent(rpc);
        rpc.setInput(inputBuilder);
        return inputBuilder;
    }

    public ContainerSchemaNodeBuilder addRpcOutput(SchemaPath schemaPath, QName qname, int line) {
        this.checkNotSealed();
        Builder parentBuilder = this.getActualNode();
        if (!(parentBuilder instanceof RpcDefinitionBuilder)) {
            throw new YangParseException(this.name, line, "output can be defined only in rpc statement");
        }
        RpcDefinitionBuilder rpc = (RpcDefinitionBuilder)parentBuilder;
        ContainerSchemaNodeBuilder outputBuilder = new ContainerSchemaNodeBuilder(this.name, line, qname, schemaPath);
        outputBuilder.setParent(rpc);
        rpc.setOutput(outputBuilder);
        return outputBuilder;
    }

    public void addNotification(NotificationDefinition notification) {
        this.checkNotSealed();
        this.notifications.add(notification);
    }

    public NotificationBuilder addNotification(int line, QName qname, SchemaPath path) {
        this.checkNotSealed();
        Builder parentBuilder = this.getActualNode();
        if (!parentBuilder.equals(this)) {
            throw new YangParseException(this.name, line, "notification can be defined only in module or submodule");
        }
        String notificationName = qname.getLocalName();
        this.checkNotConflictingInDataNamespace(notificationName, line);
        NotificationBuilder builder = new NotificationBuilder(this.name, line, qname, path);
        builder.setParent(parentBuilder);
        this.addedNotifications.add(builder);
        return builder;
    }

    public FeatureBuilder addFeature(int line, QName qname, SchemaPath path) {
        Builder parentBuilder = this.getActualNode();
        if (!parentBuilder.equals(this)) {
            throw new YangParseException(this.name, line, "feature can be defined only in module or submodule");
        }
        FeatureBuilder builder = new FeatureBuilder(this.name, line, qname, path);
        builder.setParent(parentBuilder);
        String featureName = qname.getLocalName();
        for (FeatureBuilder addedFeature : this.addedFeatures) {
            if (!addedFeature.getQName().getLocalName().equals(featureName)) continue;
            this.raiseYangParserException("", "feature", featureName, line, addedFeature.getLine());
        }
        this.addedFeatures.add(builder);
        return builder;
    }

    public ChoiceBuilder addChoice(int line, QName qname, SchemaPath path) {
        ChoiceBuilder builder = new ChoiceBuilder(this.name, line, qname, path);
        Builder parentBuilder = this.getActualNode();
        builder.setParent(parentBuilder);
        this.addChildToParent(parentBuilder, builder, qname.getLocalName());
        return builder;
    }

    public ChoiceCaseBuilder addCase(int line, QName qname, SchemaPath path) {
        Builder parentBuilder = this.getActualNode();
        if (parentBuilder == null || parentBuilder.equals(this)) {
            throw new YangParseException(this.name, line, "'case' parent not found");
        }
        ChoiceCaseBuilder builder = new ChoiceCaseBuilder(this.name, line, qname, path);
        builder.setParent(parentBuilder);
        if (parentBuilder instanceof ChoiceBuilder) {
            ((ChoiceBuilder)parentBuilder).addCase(builder);
        } else if (parentBuilder instanceof AugmentationSchemaBuilder) {
            ((AugmentationSchemaBuilder)parentBuilder).addChildNode(builder);
        } else {
            throw new YangParseException(this.name, line, "Unresolved parent of 'case' " + qname.getLocalName());
        }
        return builder;
    }

    public AnyXmlBuilder addAnyXml(int line, QName qname, SchemaPath schemaPath) {
        AnyXmlBuilder builder = new AnyXmlBuilder(this.name, line, qname, schemaPath);
        Builder parentBuilder = this.getActualNode();
        builder.setParent(parentBuilder);
        this.addChildToParent(parentBuilder, builder, qname.getLocalName());
        return builder;
    }

    @Override
    public void addTypedef(TypeDefinitionBuilder typedefBuilder) {
        String nodeName = typedefBuilder.getQName().getLocalName();
        for (TypeDefinitionBuilder tdb : this.getTypeDefinitionBuilders()) {
            if (!tdb.getQName().getLocalName().equals(nodeName)) continue;
            this.raiseYangParserException("", TYPEDEF_STR, nodeName, typedefBuilder.getLine(), tdb.getLine());
        }
        super.addTypedef(typedefBuilder);
    }

    public TypeDefinitionBuilderImpl addTypedef(int line, QName qname, SchemaPath path) {
        TypeDefinitionBuilderImpl builder = new TypeDefinitionBuilderImpl(this.name, line, qname, path);
        Builder parentBuilder = this.getActualNode();
        builder.setParent(parentBuilder);
        String typedefName = qname.getLocalName();
        if (parentBuilder.equals(this)) {
            this.addTypedef(builder);
        } else if (parentBuilder instanceof DataNodeContainerBuilder) {
            DataNodeContainerBuilder parentNode = (DataNodeContainerBuilder)parentBuilder;
            for (TypeDefinitionBuilder child : parentNode.getTypeDefinitionBuilders()) {
                if (!child.getQName().getLocalName().equals(typedefName)) continue;
                this.raiseYangParserException("", TYPEDEF_STR, typedefName, line, child.getLine());
            }
            parentNode.addTypedef(builder);
        } else if (parentBuilder instanceof RpcDefinitionBuilder) {
            RpcDefinitionBuilder rpcParent = (RpcDefinitionBuilder)parentBuilder;
            for (TypeDefinitionBuilder tdb : rpcParent.getTypeDefinitions()) {
                if (!tdb.getQName().getLocalName().equals(builder.getQName().getLocalName())) continue;
                this.raiseYangParserException("", TYPEDEF_STR, typedefName, line, tdb.getLine());
            }
            rpcParent.addTypedef(builder);
        } else {
            throw new YangParseException(this.name, line, "Unresolved parent of typedef " + typedefName);
        }
        return builder;
    }

    public void setType(TypeDefinition<?> type) {
        Builder parentBuilder = this.getActualNode();
        if (!(parentBuilder instanceof TypeAwareBuilder)) {
            throw new YangParseException("Failed to set type '" + type.getQName().getLocalName() + "'. Invalid parent node: " + parentBuilder);
        }
        ((TypeAwareBuilder)parentBuilder).setType(type);
    }

    public UnionTypeBuilder addUnionType(int line, QNameModule module) {
        Builder parentBuilder = this.getActualNode();
        if (parentBuilder == null) {
            throw new YangParseException(this.name, line, "Unresolved parent of union type");
        }
        UnionTypeBuilder union = new UnionTypeBuilder(this.name, line);
        if (parentBuilder instanceof TypeAwareBuilder) {
            ((TypeAwareBuilder)parentBuilder).setTypedef(union);
            return union;
        }
        throw new YangParseException(this.name, line, "Invalid parent of union type.");
    }

    public void addIdentityrefType(int line, SchemaPath schemaPath, String baseString) {
        IdentityrefTypeBuilder identityref = new IdentityrefTypeBuilder(this.name, line, baseString, schemaPath);
        Builder parentBuilder = this.getActualNode();
        if (parentBuilder == null) {
            throw new YangParseException(this.name, line, "Unresolved parent of identityref type.");
        }
        if (!(parentBuilder instanceof TypeAwareBuilder)) {
            throw new YangParseException(this.name, line, "Invalid parent of identityref type.");
        }
        TypeAwareBuilder typeParent = (TypeAwareBuilder)parentBuilder;
        typeParent.setTypedef(identityref);
        this.dirtyNodes.add(typeParent);
    }

    public DeviationBuilder addDeviation(int line, SchemaPath targetPath) {
        Builder parentBuilder = this.getActualNode();
        if (!parentBuilder.equals(this)) {
            throw new YangParseException(this.name, line, "deviation can be defined only in module or submodule");
        }
        DeviationBuilder builder = new DeviationBuilder(this.name, line, targetPath);
        builder.setParent(parentBuilder);
        this.deviationBuilders.add(builder);
        return builder;
    }

    public IdentitySchemaNodeBuilder addIdentity(QName qname, int line, SchemaPath path) {
        Builder parentBuilder = this.getActualNode();
        if (!parentBuilder.equals(this)) {
            throw new YangParseException(this.name, line, "identity can be defined only in module or submodule");
        }
        String identityName = qname.getLocalName();
        for (IdentitySchemaNodeBuilder idBuilder : this.addedIdentities) {
            if (!idBuilder.getQName().equals((Object)qname)) continue;
            this.raiseYangParserException("", "identity", identityName, line, idBuilder.getLine());
        }
        IdentitySchemaNodeBuilder builder = new IdentitySchemaNodeBuilder(this.name, line, qname, path);
        builder.setParent(parentBuilder);
        this.addedIdentities.add(builder);
        return builder;
    }

    @Override
    public void addUnknownNodeBuilder(UnknownSchemaNodeBuilder builder) {
        this.addedUnknownNodes.add(builder);
        this.allUnknownNodes.add(builder);
    }

    public UnknownSchemaNodeBuilderImpl addUnknownSchemaNode(int line, QName qname, SchemaPath path) {
        Builder parentBuilder = this.getActualNode();
        UnknownSchemaNodeBuilderImpl builder = new UnknownSchemaNodeBuilderImpl(this.name, line, qname, path);
        builder.setParent(parentBuilder);
        this.allUnknownNodes.add(builder);
        if (parentBuilder.equals(this)) {
            this.addedUnknownNodes.add(builder);
        } else if (parentBuilder instanceof SchemaNodeBuilder) {
            parentBuilder.addUnknownNodeBuilder(builder);
        } else if (parentBuilder instanceof DataNodeContainerBuilder) {
            parentBuilder.addUnknownNodeBuilder(builder);
        } else if (parentBuilder instanceof RefineHolderImpl) {
            parentBuilder.addUnknownNodeBuilder(builder);
        } else {
            throw new YangParseException(this.name, line, "Unresolved parent of unknown node '" + qname.getLocalName() + "'");
        }
        return builder;
    }

    public Set<RpcDefinition> getRpcs() {
        return this.rpcs;
    }

    public Set<RpcDefinitionBuilder> getAddedRpcs() {
        return this.addedRpcs;
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.notifications;
    }

    public Set<NotificationBuilder> getAddedNotifications() {
        return this.addedNotifications;
    }

    public String toString() {
        return "module " + this.name;
    }

    public void setSource(ByteSource byteSource) throws IOException {
        this.setSource(byteSource.asCharSource(Charsets.UTF_8).read());
    }

    public void setSource(String source) {
        this.source = source;
    }

    private void addChildToParent(Builder parent, DataSchemaNodeBuilder child, String childName) {
        int lineNum = child.getLine();
        if (parent.equals(this)) {
            this.addChildToModule(child, childName, lineNum);
        } else {
            this.addChildToSubnodeOfModule(parent, child, childName, lineNum);
        }
    }

    public String getYangVersion() {
        return this.yangVersion;
    }

    public String getContact() {
        return this.contact;
    }

    public String getOrganization() {
        return this.organization;
    }

    private void addChildToModule(DataSchemaNodeBuilder child, String childName, int lineNum) {
        for (DataSchemaNodeBuilder childNode : this.getChildNodeBuilders()) {
            if (!childNode.getQName().getLocalName().equals(childName)) continue;
            this.raiseYangParserException("'" + child + "'", "node", childName, lineNum, childNode.getLine());
        }
        for (RpcDefinitionBuilder rpc : this.addedRpcs) {
            if (!rpc.getQName().getLocalName().equals(childName)) continue;
            this.raiseYangParserException("'" + child + "'", "rpc", childName, lineNum, rpc.getLine());
        }
        for (NotificationBuilder notification : this.addedNotifications) {
            if (!notification.getQName().getLocalName().equals(childName)) continue;
            this.raiseYangParserException("'" + child + "'", "notification", childName, lineNum, notification.getLine());
        }
        this.addChildNode(child);
    }

    private void addChildToSubnodeOfModule(Builder parent, DataSchemaNodeBuilder child, String childName, int lineNum) {
        if (parent instanceof DataNodeContainerBuilder) {
            DataNodeContainerBuilder parentNode = (DataNodeContainerBuilder)parent;
            for (DataSchemaNodeBuilder childNode : parentNode.getChildNodeBuilders()) {
                if (!childNode.getQName().getLocalName().equals(childName)) continue;
                this.raiseYangParserException("'" + child + "'", "node", childName, lineNum, childNode.getLine());
            }
            parentNode.addChildNode(child);
        } else if (parent instanceof ChoiceBuilder) {
            ChoiceBuilder parentNode = (ChoiceBuilder)parent;
            for (ChoiceCaseBuilder caseBuilder : parentNode.getCases()) {
                if (!caseBuilder.getQName().getLocalName().equals(childName)) continue;
                this.raiseYangParserException("'" + child + "'", "node", childName, lineNum, caseBuilder.getLine());
            }
            parentNode.addCase(child);
        } else {
            throw new YangParseException(this.name, lineNum, "Unresolved parent of node '" + childName + "'.");
        }
    }

    private void raiseYangParserException(String cantAddType, String type, String name, int currentLine, int duplicateLine) {
        StringBuilder msgPrefix = new StringBuilder("");
        if (cantAddType != null && !cantAddType.isEmpty()) {
            msgPrefix.append("Can not add ");
            msgPrefix.append(cantAddType);
            msgPrefix.append(": ");
        }
        String msg = String.format("%s%s with same name '%s' already declared at line %d.", msgPrefix, type, name, duplicateLine);
        throw new YangParseException(this.getModuleName(), currentLine, msg);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.qnameModule.hashCode();
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleBuilder other = (ModuleBuilder)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!this.qnameModule.equals((Object)other.qnameModule)) {
            return false;
        }
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }

    public List<UnknownSchemaNode> getExtensionInstances() {
        return this.unknownNodes;
    }
}

