/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.SimpleDateFormatUtil;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;

public class ModuleIdentifierImpl
implements ModuleIdentifier {
    private final QNameModule qnameModule;
    private final String name;

    public ModuleIdentifierImpl(String name, Optional<URI> namespace, Optional<Date> revision) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.qnameModule = QNameModule.create((URI)((URI)namespace.orNull()), (Date)((Date)revision.orNull()));
    }

    public QNameModule getQNameModule() {
        return this.qnameModule;
    }

    public Date getRevision() {
        return this.qnameModule.getRevision();
    }

    public String getName() {
        return this.name;
    }

    public URI getNamespace() {
        return this.qnameModule.getNamespace();
    }

    public String toString() {
        return "ModuleIdentifierImpl{name='" + this.name + '\'' + ", namespace=" + this.getNamespace() + ", revision=" + this.getRevision() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ModuleIdentifier)) {
            return false;
        }
        ModuleIdentifier that = (ModuleIdentifier)o;
        if (!this.name.equals(that.getName())) {
            return false;
        }
        if (this.getNamespace() != null && !this.getNamespace().equals(that.getNamespace())) {
            return false;
        }
        Date defaultRev = SimpleDateFormatUtil.DEFAULT_DATE_REV;
        Date defaultImp = SimpleDateFormatUtil.DEFAULT_DATE_IMP;
        if (this.getRevision() == defaultImp ^ that.getRevision() == defaultImp) {
            return true;
        }
        if (defaultRev.equals(this.getRevision()) && that.getRevision() == null || defaultRev.equals(that.getRevision()) && this.getRevision() == null) {
            return true;
        }
        if (this.getRevision() == null ^ that.getRevision() == null) {
            return false;
        }
        return this.getRevision() == null || that.getRevision() == null || this.getRevision().equals(that.getRevision());
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

