/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedDataNodeContainer;
import org.opendaylight.yangtools.yang.parser.builder.util.Comparators;

public final class ModuleImpl
extends AbstractDocumentedDataNodeContainer
implements Module,
Immutable {
    private final QNameModule qnameModule;
    private final String name;
    private final String sourcePath;
    private final String prefix;
    private final String yangVersion;
    private final String organization;
    private final String contact;
    private final Set<ModuleImport> imports;
    private final Set<Module> submodules;
    private final Set<FeatureDefinition> features;
    private final Set<NotificationDefinition> notifications;
    private final Set<AugmentationSchema> augmentations;
    private final Set<RpcDefinition> rpcs;
    private final Set<Deviation> deviations;
    private final List<ExtensionDefinition> extensionNodes;
    private final Set<IdentitySchemaNode> identities;
    private final List<UnknownSchemaNode> unknownNodes;
    private final String source;

    ModuleImpl(String name, String sourcePath, ModuleBuilder builder) {
        super(builder);
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Missing name");
        this.sourcePath = sourcePath;
        this.imports = ImmutableSet.copyOf(builder.imports.values());
        this.submodules = ImmutableSet.copyOf(builder.submodules);
        this.prefix = builder.getPrefix();
        this.qnameModule = QNameModule.cachedReference((QNameModule)QNameModule.create((URI)builder.getNamespace(), (Date)(builder.getRevision() == null ? null : new Date(builder.getRevision().getTime()))));
        this.yangVersion = builder.getYangVersion();
        this.organization = builder.getOrganization();
        this.contact = builder.getContact();
        this.features = ModuleImpl.toImmutableSortedSet(builder.getFeatures());
        this.notifications = ModuleImpl.toImmutableSortedSet(builder.getNotifications());
        this.augmentations = ImmutableSet.copyOf(builder.getAugments());
        this.rpcs = ModuleImpl.toImmutableSortedSet(builder.getRpcs());
        this.deviations = ImmutableSet.copyOf(builder.getDeviations());
        this.extensionNodes = ImmutableList.copyOf(builder.getExtensions());
        this.identities = ImmutableSet.copyOf(builder.getIdentities());
        this.unknownNodes = ImmutableList.copyOf(builder.getExtensionInstances());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource(), (Object)"Missing source");
    }

    public String getModuleSourcePath() {
        return this.sourcePath;
    }

    public URI getNamespace() {
        return this.qnameModule.getNamespace();
    }

    public String getName() {
        return this.name;
    }

    public Date getRevision() {
        return this.qnameModule.getRevision();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getYangVersion() {
        return this.yangVersion;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getContact() {
        return this.contact;
    }

    public Set<ModuleImport> getImports() {
        return this.imports;
    }

    public Set<Module> getSubmodules() {
        return this.submodules;
    }

    public Set<FeatureDefinition> getFeatures() {
        return this.features;
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.notifications;
    }

    public Set<AugmentationSchema> getAugmentations() {
        return this.augmentations;
    }

    public Set<RpcDefinition> getRpcs() {
        return this.rpcs;
    }

    public Set<Deviation> getDeviations() {
        return this.deviations;
    }

    public List<ExtensionDefinition> getExtensionSchemaNodes() {
        return this.extensionNodes;
    }

    public Set<IdentitySchemaNode> getIdentities() {
        return this.identities;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.yangVersion == null ? 0 : this.yangVersion.hashCode());
        result = 31 * result + this.qnameModule.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleImpl other = (ModuleImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!this.qnameModule.equals((Object)other.qnameModule)) {
            return false;
        }
        return !(this.yangVersion == null ? other.yangVersion != null : !this.yangVersion.equals(other.yangVersion));
    }

    private static <T extends SchemaNode> Set<T> toImmutableSortedSet(Set<T> original) {
        TreeSet<SchemaNode> sorted = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        sorted.addAll(original);
        return Collections.unmodifiableSet(sorted);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ModuleImpl.class.getSimpleName());
        sb.append("[");
        sb.append("name=").append(this.name);
        sb.append(", namespace=").append(this.getNamespace());
        sb.append(", revision=").append(this.getRevision());
        sb.append(", prefix=").append(this.prefix);
        sb.append(", yangVersion=").append(this.yangVersion);
        sb.append("]");
        return sb.toString();
    }

    public QNameModule getQNameModule() {
        return this.qnameModule;
    }
}

