/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.NotificationDefinitionImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class NotificationBuilder
extends AbstractDocumentedDataNodeContainerBuilder
implements SchemaNodeBuilder,
AugmentationTargetBuilder {
    private NotificationDefinitionImpl instance;
    private SchemaPath schemaPath;
    private final List<AugmentationSchema> augmentations = new ArrayList<AugmentationSchema>();
    private final List<AugmentationSchemaBuilder> augmentationBuilders = new ArrayList<AugmentationSchemaBuilder>();

    NotificationBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
    }

    NotificationBuilder(String moduleName, int line, QName qname, SchemaPath path, NotificationDefinition base) {
        super(moduleName, line, qname, path, (DataNodeContainer)base);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
        this.addedUnknownNodes.addAll(BuilderUtils.wrapUnknownNodes(moduleName, line, base.getUnknownSchemaNodes(), path, qname));
        this.augmentations.addAll(base.getAvailableAugmentations());
    }

    public NotificationDefinition build() {
        if (!(this.getParent() instanceof ModuleBuilder)) {
            throw new YangParseException(this.getModuleName(), this.getLine(), "Notification can be defined only under module (was " + this.getParent() + ")");
        }
        if (this.instance != null) {
            return this.instance;
        }
        this.buildChildren();
        this.instance = new NotificationDefinitionImpl(this.qname, this.schemaPath, this);
        for (AugmentationSchemaBuilder builder : this.augmentationBuilders) {
            this.augmentations.add(builder.build());
        }
        this.instance.augmentations = ImmutableSet.copyOf(this.augmentations);
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.schemaPath = path;
    }

    @Override
    public void addAugmentation(AugmentationSchemaBuilder augment) {
        this.augmentationBuilders.add(augment);
    }

    public String toString() {
        return "notification " + this.getQName().getLocalName();
    }

    @Override
    protected String getStatementName() {
        return "notification";
    }
}

