/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.List;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DocumentedNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.RefineBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AnyXmlBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class RefineUtils {
    private RefineUtils() {
    }

    private static void refineLeaf(LeafSchemaNodeBuilder leaf, RefineBuilder refine) {
        String defaultStr = refine.getDefaultStr();
        Boolean mandatory = refine.isMandatory();
        MustDefinition must = refine.getMust();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (defaultStr != null && !defaultStr.isEmpty()) {
            leaf.setDefaultStr(defaultStr);
        }
        if (mandatory != null) {
            leaf.getConstraints().setMandatory(mandatory);
        }
        if (must != null) {
            leaf.getConstraints().addMustDefinition(must);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(leaf);
                leaf.addUnknownNodeBuilder(unknown);
            }
        }
    }

    private static void refineContainer(ContainerSchemaNodeBuilder container, RefineBuilder refine) {
        Boolean presence = refine.isPresence();
        MustDefinition must = refine.getMust();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (presence != null) {
            container.setPresence(presence);
        }
        if (must != null) {
            container.getConstraints().addMustDefinition(must);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(container);
                container.addUnknownNodeBuilder(unknown);
            }
        }
    }

    private static void refineList(ListSchemaNodeBuilder list, RefineBuilder refine) {
        MustDefinition must = refine.getMust();
        Integer min = refine.getMinElements();
        Integer max = refine.getMaxElements();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (must != null) {
            list.getConstraints().addMustDefinition(must);
        }
        if (min != null) {
            list.getConstraints().setMinElements(min);
        }
        if (max != null) {
            list.getConstraints().setMaxElements(max);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(list);
                list.addUnknownNodeBuilder(unknown);
            }
        }
    }

    public static void refineLeafList(LeafListSchemaNodeBuilder leafList, RefineBuilder refine) {
        MustDefinition must = refine.getMust();
        Integer min = refine.getMinElements();
        Integer max = refine.getMaxElements();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (must != null) {
            leafList.getConstraints().addMustDefinition(must);
        }
        if (min != null) {
            leafList.getConstraints().setMinElements(min);
        }
        if (max != null) {
            leafList.getConstraints().setMaxElements(max);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(leafList);
                leafList.addUnknownNodeBuilder(unknown);
            }
        }
    }

    public static void refineChoice(ChoiceBuilder choice, RefineBuilder refine) {
        String defaultStr = refine.getDefaultStr();
        Boolean mandatory = refine.isMandatory();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (defaultStr != null) {
            choice.setDefaultCase(defaultStr);
        }
        if (mandatory != null) {
            choice.getConstraints().setMandatory(mandatory);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(choice);
                choice.addUnknownNodeBuilder(unknown);
            }
        }
    }

    public static void refineAnyxml(AnyXmlBuilder anyXml, RefineBuilder refine) {
        Boolean mandatory = refine.isMandatory();
        MustDefinition must = refine.getMust();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (mandatory != null) {
            anyXml.getConstraints().setMandatory(mandatory);
        }
        if (must != null) {
            anyXml.getConstraints().addMustDefinition(must);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(anyXml);
                anyXml.addUnknownNodeBuilder(unknown);
            }
        }
    }

    private static void checkRefine(SchemaNodeBuilder node, RefineBuilder refine) {
        String moduleName = refine.getModuleName();
        int line = refine.getLine();
        String name = node.getQName().getLocalName();
        String defaultStr = refine.getDefaultStr();
        Boolean mandatory = refine.isMandatory();
        Boolean presence = refine.isPresence();
        MustDefinition must = refine.getMust();
        Integer min = refine.getMinElements();
        Integer max = refine.getMaxElements();
        if (node instanceof AnyXmlBuilder) {
            RefineUtils.checkRefineDefault(node, defaultStr, moduleName, line);
            RefineUtils.checkRefinePresence(node, presence, moduleName, line);
            RefineUtils.checkRefineMinMax(name, min, max, moduleName, line);
        } else if (node instanceof ChoiceBuilder) {
            RefineUtils.checkRefinePresence(node, presence, moduleName, line);
            RefineUtils.checkRefineMust(node, must, moduleName, line);
            RefineUtils.checkRefineMinMax(name, min, max, moduleName, line);
        } else if (node instanceof ContainerSchemaNodeBuilder) {
            RefineUtils.checkRefineDefault(node, defaultStr, moduleName, line);
            RefineUtils.checkRefineMandatory(node, mandatory, moduleName, line);
            RefineUtils.checkRefineMinMax(name, min, max, moduleName, line);
        } else if (node instanceof LeafSchemaNodeBuilder) {
            RefineUtils.checkRefinePresence(node, presence, moduleName, line);
            RefineUtils.checkRefineMinMax(name, min, max, moduleName, line);
        } else if (node instanceof LeafListSchemaNodeBuilder || node instanceof ListSchemaNodeBuilder) {
            RefineUtils.checkRefineDefault(node, defaultStr, moduleName, line);
            RefineUtils.checkRefinePresence(node, presence, moduleName, line);
            RefineUtils.checkRefineMandatory(node, mandatory, moduleName, line);
        } else if (node instanceof GroupingBuilder || node instanceof TypeDefinitionBuilder || node instanceof UsesNodeBuilder) {
            RefineUtils.checkRefineDefault(node, defaultStr, moduleName, line);
            RefineUtils.checkRefinePresence(node, presence, moduleName, line);
            RefineUtils.checkRefineMandatory(node, mandatory, moduleName, line);
            RefineUtils.checkRefineMust(node, must, moduleName, line);
            RefineUtils.checkRefineMinMax(name, min, max, moduleName, line);
        }
    }

    private static void checkRefineDefault(SchemaNodeBuilder node, String defaultStr, String moduleName, int line) {
        if (defaultStr != null) {
            throw new YangParseException(moduleName, line, "Can not refine 'default' for '" + node.getQName().getLocalName() + "'.");
        }
    }

    private static void checkRefineMandatory(SchemaNodeBuilder node, Boolean mandatory, String moduleName, int line) {
        if (mandatory != null) {
            throw new YangParseException(moduleName, line, "Can not refine 'mandatory' for '" + node.getQName().getLocalName() + "'.");
        }
    }

    private static void checkRefinePresence(SchemaNodeBuilder node, Boolean presence, String moduleName, int line) {
        if (presence != null) {
            throw new YangParseException(moduleName, line, "Can not refine 'presence' for '" + node.getQName().getLocalName() + "'.");
        }
    }

    private static void checkRefineMust(SchemaNodeBuilder node, MustDefinition must, String moduleName, int line) {
        if (must != null) {
            throw new YangParseException(moduleName, line, "Can not refine 'must' for '" + node.getQName().getLocalName() + "'.");
        }
    }

    private static void checkRefineMinMax(String refineTargetName, Integer min, Integer max, String moduleName, int line) {
        if (min != null || max != null) {
            throw new YangParseException(moduleName, line, "Can not refine 'min-elements' or 'max-elements' for '" + refineTargetName + "'.");
        }
    }

    private static void refineDefault(Builder node, RefineBuilder refine) {
        Boolean config;
        String reference;
        String moduleName = refine.getModuleName();
        int line = refine.getLine();
        DocumentedNodeBuilder documentedNode = node instanceof DocumentedNodeBuilder ? (DocumentedNodeBuilder)((Object)node) : null;
        String description = refine.getDescription();
        if (description != null) {
            if (documentedNode != null) {
                documentedNode.setDescription(description);
            } else {
                throw new YangParseException(moduleName, line, String.format("Cannot refine description in of target %s", refine.getTargetPathString()));
            }
        }
        if ((reference = refine.getReference()) != null) {
            if (documentedNode != null) {
                documentedNode.setReference(reference);
            } else {
                throw new YangParseException(moduleName, line, String.format("Cannot refine reference in of target %s", refine.getTargetPathString()));
            }
        }
        if ((config = refine.isConfiguration()) != null) {
            if (node instanceof DataSchemaNodeBuilder) {
                ((DataSchemaNodeBuilder)node).setConfiguration(config);
            } else {
                throw new YangParseException(moduleName, line, String.format("Cannot refine config of target %s ", refine.getTargetPathString()));
            }
        }
    }

    static void performRefine(SchemaNodeBuilder nodeToRefine, RefineBuilder refine) {
        RefineUtils.checkRefine(nodeToRefine, refine);
        RefineUtils.refineDefault(nodeToRefine, refine);
        if (nodeToRefine instanceof LeafSchemaNodeBuilder) {
            RefineUtils.refineLeaf((LeafSchemaNodeBuilder)nodeToRefine, refine);
        } else if (nodeToRefine instanceof ContainerSchemaNodeBuilder) {
            RefineUtils.refineContainer((ContainerSchemaNodeBuilder)nodeToRefine, refine);
        } else if (nodeToRefine instanceof ListSchemaNodeBuilder) {
            RefineUtils.refineList((ListSchemaNodeBuilder)nodeToRefine, refine);
        } else if (nodeToRefine instanceof LeafListSchemaNodeBuilder) {
            RefineUtils.refineLeafList((LeafListSchemaNodeBuilder)nodeToRefine, refine);
        } else if (nodeToRefine instanceof ChoiceBuilder) {
            RefineUtils.refineChoice((ChoiceBuilder)nodeToRefine, refine);
        } else if (nodeToRefine instanceof AnyXmlBuilder) {
            RefineUtils.refineAnyxml((AnyXmlBuilder)nodeToRefine, refine);
        }
    }
}

