/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.Comparators;

public final class RpcDefinitionBuilder
extends AbstractSchemaNodeBuilder {
    private RpcDefinitionImpl instance;
    private ContainerSchemaNodeBuilder inputBuilder;
    private ContainerSchemaNodeBuilder outputBuilder;
    private final Set<TypeDefinitionBuilder> addedTypedefs = new HashSet<TypeDefinitionBuilder>();
    private final Set<GroupingBuilder> addedGroupings = new HashSet<GroupingBuilder>();

    RpcDefinitionBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
    }

    public ContainerSchemaNodeBuilder getInput() {
        return this.inputBuilder;
    }

    public ContainerSchemaNodeBuilder getOutput() {
        return this.outputBuilder;
    }

    public RpcDefinition build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = new RpcDefinitionImpl(this.qname, this.schemaPath);
        ContainerSchemaNode input = this.inputBuilder == null ? null : this.inputBuilder.build();
        ContainerSchemaNode output = this.outputBuilder == null ? null : this.outputBuilder.build();
        this.instance.setInput(input);
        this.instance.setOutput(output);
        this.instance.description = this.description;
        this.instance.reference = this.reference;
        this.instance.status = this.status;
        TreeSet<SchemaNode> typedefs = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        for (TypeDefinitionBuilder entry : this.addedTypedefs) {
            typedefs.add((SchemaNode)entry.build());
        }
        this.instance.typeDefinitions = ImmutableSet.copyOf(typedefs);
        TreeSet<SchemaNode> groupings = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        for (GroupingBuilder builder : this.addedGroupings) {
            groupings.add((SchemaNode)builder.build());
        }
        this.instance.groupings = ImmutableSet.copyOf(groupings);
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    void setInput(ContainerSchemaNodeBuilder inputBuilder) {
        this.inputBuilder = inputBuilder;
    }

    void setOutput(ContainerSchemaNodeBuilder outputBuilder) {
        this.outputBuilder = outputBuilder;
    }

    public Set<TypeDefinitionBuilder> getTypeDefinitions() {
        return this.addedTypedefs;
    }

    public void addTypedef(TypeDefinitionBuilder type) {
        this.addedTypedefs.add(type);
    }

    public Set<GroupingBuilder> getGroupings() {
        return this.addedGroupings;
    }

    public void addGrouping(GroupingBuilder grouping) {
        this.addedGroupings.add(grouping);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RpcDefinitionBuilder)) {
            return false;
        }
        RpcDefinitionBuilder other = (RpcDefinitionBuilder)obj;
        if (other.qname == null ? this.qname != null : !other.qname.equals((Object)this.qname)) {
            return false;
        }
        return !(other.schemaPath == null ? this.schemaPath != null : !other.schemaPath.equals((Object)this.schemaPath));
    }

    public String toString() {
        return "rpc " + this.qname.getLocalName();
    }
}

