/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnsignedIntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeAwareBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentitySchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.util.TypeConstraints;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static void resolveType(TypeAwareBuilder nodeToResolve, Map<URI, NavigableMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        QName unknownTypeQName = nodeToResolve.getTypeQName();
        ModuleBuilder dependentModuleBuilder = BuilderUtils.findModule(unknownTypeQName, modules);
        if (dependentModuleBuilder == null) {
            throw new YangParseException(module.getName(), nodeToResolve.getLine(), "Type not found: " + unknownTypeQName);
        }
        TypeDefinitionBuilder resolvedType = TypeUtils.findUnknownTypeDefinition(nodeToResolve, dependentModuleBuilder, modules, module);
        nodeToResolve.setTypedef(resolvedType);
    }

    public static void resolveTypeUnion(UnionTypeBuilder union, Map<URI, NavigableMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        for (TypeDefinitionBuilder unionType : union.getTypedefs()) {
            if (!(unionType instanceof IdentityrefTypeBuilder)) continue;
            IdentityrefTypeBuilder idref = (IdentityrefTypeBuilder)unionType;
            IdentitySchemaNodeBuilder identity = BuilderUtils.findBaseIdentity(module, idref.getBaseString(), idref.getLine());
            if (identity == null) {
                throw new YangParseException(module.getName(), idref.getLine(), "Failed to find base identity");
            }
            idref.setBaseIdentity(identity);
        }
        for (QName unknownTypeQName : union.getBaseTypeQNames()) {
            ModuleBuilder dependentModuleBuilder = BuilderUtils.findModule(unknownTypeQName, modules);
            if (dependentModuleBuilder == null) {
                throw new YangParseException(module.getName(), union.getLine(), "Type not found: " + unknownTypeQName);
            }
            TypeDefinitionBuilder targetTypeBuilder = TypeUtils.findTypeDefinitionBuilder(union, dependentModuleBuilder, unknownTypeQName.getLocalName(), module.getName(), union.getLine());
            union.setTypedef(targetTypeBuilder);
        }
    }

    private static TypeDefinitionBuilder findUnknownTypeDefinition(TypeAwareBuilder nodeToResolve, ModuleBuilder dependentModuleBuilder, Map<URI, NavigableMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        int line = nodeToResolve.getLine();
        QName unknownTypeQName = nodeToResolve.getTypeQName();
        TypeDefinitionBuilder targetTypeBuilder = TypeUtils.findTypeDefinitionBuilder(nodeToResolve, dependentModuleBuilder, unknownTypeQName.getLocalName(), module.getName(), line);
        TypeConstraints constraints = TypeUtils.findConstraintsFromTypeBuilder(nodeToResolve, new TypeConstraints(module.getName(), nodeToResolve.getLine()), modules, module);
        constraints.validateConstraints();
        return targetTypeBuilder;
    }

    private static TypeDefinitionBuilder findTypedefBuilderByName(Set<TypeDefinitionBuilder> types, String name) {
        for (TypeDefinitionBuilder td : types) {
            if (!td.getQName().getLocalName().equals(name)) continue;
            return td;
        }
        return null;
    }

    private static TypeConstraints mergeConstraints(TypeDefinition<?> type, TypeConstraints constraints) {
        if (type instanceof DecimalTypeDefinition) {
            constraints.addRanges(((DecimalTypeDefinition)type).getRangeConstraints());
            constraints.addFractionDigits(((DecimalTypeDefinition)type).getFractionDigits());
        } else if (type instanceof IntegerTypeDefinition) {
            constraints.addRanges(((IntegerTypeDefinition)type).getRangeConstraints());
        } else if (type instanceof UnsignedIntegerTypeDefinition) {
            constraints.addRanges(((UnsignedIntegerTypeDefinition)type).getRangeConstraints());
        } else if (type instanceof StringTypeDefinition) {
            constraints.addPatterns(((StringTypeDefinition)type).getPatternConstraints());
            constraints.addLengths(((StringTypeDefinition)type).getLengthConstraints());
        } else if (type instanceof BinaryTypeDefinition) {
            constraints.addLengths(((BinaryTypeDefinition)type).getLengthConstraints());
        } else if (type instanceof ExtendedType) {
            constraints.addFractionDigits(((ExtendedType)type).getFractionDigits());
            constraints.addLengths(((ExtendedType)type).getLengthConstraints());
            constraints.addPatterns(((ExtendedType)type).getPatternConstraints());
            constraints.addRanges(((ExtendedType)type).getRangeConstraints());
        }
        return constraints;
    }

    private static TypeConstraints findConstraintsFromTypeBuilder(TypeAwareBuilder nodeToResolve, TypeConstraints constraints, Map<URI, NavigableMap<Date, ModuleBuilder>> modules, ModuleBuilder builder) {
        TypeDefinition<?> type;
        if (nodeToResolve instanceof UnionTypeBuilder || nodeToResolve instanceof IdentityrefTypeBuilder) {
            return constraints;
        }
        if (nodeToResolve instanceof TypeDefinitionBuilder) {
            TypeDefinitionBuilder typedefToResolve = (TypeDefinitionBuilder)nodeToResolve;
            constraints.addFractionDigits(typedefToResolve.getFractionDigits());
            constraints.addLengths(typedefToResolve.getLengths());
            constraints.addPatterns(typedefToResolve.getPatterns());
            constraints.addRanges(typedefToResolve.getRanges());
        }
        if ((type = nodeToResolve.getType()) == null) {
            QName unknownTypeQName = nodeToResolve.getTypeQName();
            if (unknownTypeQName == null) {
                return constraints;
            }
            ModuleBuilder dependentModuleBuilder = BuilderUtils.findModule(unknownTypeQName, modules);
            TypeDefinitionBuilder targetTypeBuilder = TypeUtils.findTypeDefinitionBuilder(nodeToResolve, dependentModuleBuilder, unknownTypeQName.getLocalName(), builder.getName(), 0);
            return TypeUtils.findConstraintsFromTypeBuilder(targetTypeBuilder, constraints, modules, dependentModuleBuilder);
        }
        if (type instanceof ExtendedType) {
            TypeUtils.mergeConstraints(type, constraints);
            return TypeUtils.mergeConstraints(type, constraints);
        }
        return TypeUtils.mergeConstraints(type, constraints);
    }

    private static TypeDefinitionBuilder findTypeDefinitionBuilder(TypeAwareBuilder nodeToResolve, ModuleBuilder dependentModule, String typeName, String currentModuleName, int line) {
        Set<TypeDefinitionBuilder> typedefs = dependentModule.getTypeDefinitionBuilders();
        TypeDefinitionBuilder result = TypeUtils.findTypedefBuilderByName(typedefs, typeName);
        if (result != null) {
            return result;
        }
        for (Builder parent = nodeToResolve.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof DataNodeContainerBuilder) {
                typedefs = ((DataNodeContainerBuilder)parent).getTypeDefinitionBuilders();
            } else if (parent instanceof RpcDefinitionBuilder) {
                typedefs = ((RpcDefinitionBuilder)parent).getTypeDefinitions();
            }
            result = TypeUtils.findTypedefBuilderByName(typedefs, typeName);
            if (result != null) break;
        }
        if (result == null) {
            throw new YangParseException(currentModuleName, line, "Referenced type '" + typeName + "' not found.");
        }
        return result;
    }
}

