/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.ExtensionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.Comparators;

public final class UnknownSchemaNodeBuilderImpl
extends AbstractBuilder
implements UnknownSchemaNodeBuilder {
    private QName qname;
    private SchemaPath schemaPath;
    private String description;
    private String reference;
    private Status status = Status.CURRENT;
    private boolean addedByUses;
    private UnknownSchemaNodeImpl instance;
    private QName nodeType;
    private String nodeParameter;
    private ExtensionDefinition extensionDefinition;
    private ExtensionBuilder extensionBuilder;

    public UnknownSchemaNodeBuilderImpl(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line);
        this.qname = qname;
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
    }

    public UnknownSchemaNodeBuilderImpl(String moduleName, int line, QName qname, SchemaPath path, UnknownSchemaNode base) {
        super(moduleName, line);
        this.qname = base.getQName();
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)path, (Object)"Schema Path must not be null");
        this.nodeType = base.getNodeType();
        this.nodeParameter = base.getNodeParameter();
        this.description = base.getDescription();
        this.reference = base.getReference();
        this.status = base.getStatus();
        this.addedByUses = base.isAddedByUses();
        this.extensionDefinition = base.getExtensionDefinition();
        this.unknownNodes.addAll(base.getUnknownSchemaNodes());
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public void setPath(SchemaPath schemaPath) {
        this.schemaPath = schemaPath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
        result = 31 * result + (this.nodeParameter == null ? 0 : this.nodeParameter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnknownSchemaNodeBuilderImpl other = (UnknownSchemaNodeBuilderImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        if (this.nodeType == null ? other.nodeType != null : !this.nodeType.equals((Object)other.nodeType)) {
            return false;
        }
        return !(this.nodeParameter == null ? other.nodeParameter != null : !this.nodeParameter.equals(other.nodeParameter));
    }

    @Override
    public UnknownSchemaNode build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = new UnknownSchemaNodeImpl(this.qname, this.schemaPath);
        this.instance.setNodeType(this.nodeType);
        this.instance.setNodeParameter(this.nodeParameter);
        this.instance.description = this.description;
        this.instance.reference = this.reference;
        this.instance.status = this.status;
        this.instance.addedByUses = this.addedByUses;
        if (this.extensionDefinition != null) {
            this.instance.setExtensionDefinition(this.extensionDefinition);
        } else if (this.extensionBuilder != null) {
            this.instance.setExtensionDefinition(this.extensionBuilder.build());
        }
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
        this.instance.setUnknownSchemaNodes(this.unknownNodes);
        return this.instance;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.status = status;
        }
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    @Override
    public QName getNodeType() {
        return this.nodeType;
    }

    @Override
    public void setNodeType(QName nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public String getNodeParameter() {
        return this.nodeParameter;
    }

    @Override
    public void setNodeParameter(String nodeParameter) {
        this.nodeParameter = nodeParameter;
    }

    @Override
    public ExtensionDefinition getExtensionDefinition() {
        return this.extensionDefinition;
    }

    @Override
    public void setExtensionDefinition(ExtensionDefinition extensionDefinition) {
        this.extensionDefinition = extensionDefinition;
    }

    @Override
    public ExtensionBuilder getExtensionBuilder() {
        return this.extensionBuilder;
    }

    @Override
    public void setExtensionBuilder(ExtensionBuilder extension) {
        this.extensionBuilder = extension;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodeType.getNamespace());
        sb.append(":");
        sb.append(this.nodeType.getLocalName());
        sb.append(" ");
        sb.append(this.nodeParameter);
        return sb.toString();
    }
}

