/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

final class UnknownSchemaNodeImpl
implements UnknownSchemaNode {
    private final QName qname;
    private final SchemaPath path;
    private ExtensionDefinition extension;
    String description;
    String reference;
    Status status = Status.CURRENT;
    private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();
    private QName nodeType;
    private String nodeParameter;
    boolean addedByUses;

    UnknownSchemaNodeImpl(QName qname, SchemaPath path) {
        this.qname = qname;
        this.path = path;
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public ExtensionDefinition getExtensionDefinition() {
        return this.extension;
    }

    void setExtensionDefinition(ExtensionDefinition extension) {
        this.extension = extension;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    void setUnknownSchemaNodes(List<UnknownSchemaNode> unknownNodes) {
        if (unknownNodes != null) {
            this.unknownNodes.addAll(unknownNodes);
        }
    }

    public QName getNodeType() {
        return this.nodeType;
    }

    void setNodeType(QName nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeParameter() {
        return this.nodeParameter;
    }

    void setNodeParameter(String nodeParameter) {
        this.nodeParameter = nodeParameter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodeType.getNamespace());
        sb.append(":");
        sb.append(this.nodeType.getLocalName());
        sb.append(" ");
        sb.append(this.nodeParameter);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
        result = 31 * result + (this.nodeParameter == null ? 0 : this.nodeParameter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnknownSchemaNodeImpl other = (UnknownSchemaNodeImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
            return false;
        }
        if (this.nodeType == null ? other.nodeType != null : !this.nodeType.equals((Object)other.nodeType)) {
            return false;
        }
        return !(this.nodeParameter == null ? other.nodeParameter != null : !this.nodeParameter.equals(other.nodeParameter));
    }
}

