/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.RefineBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UsesNodeImpl;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractBuilder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class UsesNodeBuilderImpl
extends AbstractBuilder
implements UsesNodeBuilder {
    private UsesNodeImpl instance;
    private DataNodeContainerBuilder parentBuilder;
    private final SchemaPath targetGroupingPath;
    private SchemaPath groupingPath;
    private GroupingDefinition groupingDefinition;
    private GroupingBuilder groupingBuilder;
    private boolean addedByUses;
    private boolean augmenting;
    private boolean resolved;
    private final Set<AugmentationSchemaBuilder> augmentationBuilders = new HashSet<AugmentationSchemaBuilder>();
    private final List<SchemaNodeBuilder> refineBuilders = new ArrayList<SchemaNodeBuilder>();
    private final List<RefineBuilder> refines = new ArrayList<RefineBuilder>();

    public UsesNodeBuilderImpl(String moduleName, int line, SchemaPath targetGroupingPath) {
        super(moduleName, line);
        this.targetGroupingPath = targetGroupingPath;
    }

    @Override
    public UsesNode build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = new UsesNodeImpl(this.groupingPath);
        this.instance.setAddedByUses(this.addedByUses);
        HashSet<AugmentationSchema> augments = new HashSet<AugmentationSchema>();
        for (AugmentationSchemaBuilder builder : this.augmentationBuilders) {
            if (builder.isUnsupportedTarget()) continue;
            augments.add(builder.build());
        }
        this.instance.augmentations = ImmutableSet.copyOf(augments);
        HashMap<SchemaPath, SchemaNode> refineNodes = new HashMap<SchemaPath, SchemaNode>();
        for (SchemaNodeBuilder refineBuilder : this.refineBuilders) {
            SchemaNode refineNode = refineBuilder.build();
            refineNodes.put(refineNode.getPath(), refineNode);
        }
        this.instance.refines = ImmutableMap.copyOf(refineNodes);
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        this.instance.unknownNodes = ImmutableList.copyOf((Collection)this.unknownNodes);
        return this.instance;
    }

    @Override
    public DataNodeContainerBuilder getParent() {
        return this.parentBuilder;
    }

    @Override
    public void setParent(Builder parent) {
        if (!(parent instanceof DataNodeContainerBuilder)) {
            throw new YangParseException(this.getModuleName(), this.getLine(), "Parent of 'uses' has to be instance of DataNodeContainerBuilder, but was: '" + parent + "'.");
        }
        this.parentBuilder = (DataNodeContainerBuilder)parent;
    }

    @Override
    public SchemaPath getGroupingPath() {
        return this.groupingPath;
    }

    @Override
    public GroupingDefinition getGroupingDefinition() {
        return this.groupingDefinition;
    }

    @Override
    public void setGroupingDefinition(GroupingDefinition groupingDefinition) {
        this.groupingDefinition = groupingDefinition;
        if (groupingDefinition != null) {
            this.groupingPath = groupingDefinition.getPath();
        }
    }

    @Override
    public GroupingBuilder getGroupingBuilder() {
        return this.groupingBuilder;
    }

    @Override
    public void setGrouping(GroupingBuilder grouping) {
        this.groupingBuilder = grouping;
        if (this.groupingBuilder != null) {
            this.groupingPath = this.groupingBuilder.getPath();
        }
    }

    @Override
    public SchemaPath getTargetGroupingPath() {
        return this.targetGroupingPath;
    }

    @Override
    public Set<AugmentationSchemaBuilder> getAugmentations() {
        return this.augmentationBuilders;
    }

    @Override
    public void addAugment(AugmentationSchemaBuilder augmentBuilder) {
        this.augmentationBuilders.add(augmentBuilder);
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    @Override
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.augmenting = augmenting;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public List<SchemaNodeBuilder> getRefineNodes() {
        return this.refineBuilders;
    }

    @Override
    public void addRefineNode(DataSchemaNodeBuilder refineNode) {
        this.refineBuilders.add(refineNode);
    }

    @Override
    public List<RefineBuilder> getRefines() {
        return this.refines;
    }

    @Override
    public void addRefine(RefineBuilder refine) {
        this.refines.add(refine);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupingPath == null ? 0 : this.groupingPath.hashCode());
        result = 31 * result + (this.parentBuilder == null ? 0 : this.parentBuilder.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsesNodeBuilderImpl other = (UsesNodeBuilderImpl)obj;
        if (this.groupingPath == null ? other.groupingPath != null : !this.groupingPath.equals((Object)other.groupingPath)) {
            return false;
        }
        return !(this.parentBuilder == null ? other.parentBuilder != null : !this.parentBuilder.equals(other.parentBuilder));
    }

    public String toString() {
        return "uses '" + this.groupingPath + "'";
    }
}

