/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;

public abstract class AbstractBuilder
implements Builder {
    private String moduleName;
    private final int line;
    private Builder parentBuilder;
    protected final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();
    protected final List<UnknownSchemaNodeBuilder> addedUnknownNodes = new ArrayList<UnknownSchemaNodeBuilder>();
    private boolean sealed;

    protected AbstractBuilder(String moduleName, int line) {
        this.moduleName = (String)Preconditions.checkNotNull((Object)moduleName, (Object)"moduleName must not be null");
        this.line = line;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    @Deprecated
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public Builder getParent() {
        return this.parentBuilder;
    }

    @Override
    public void setParent(Builder parentBuilder) {
        this.checkNotSealed();
        this.parentBuilder = parentBuilder;
    }

    @Override
    public List<UnknownSchemaNodeBuilder> getUnknownNodes() {
        return this.addedUnknownNodes;
    }

    @Override
    public void addUnknownNodeBuilder(UnknownSchemaNodeBuilder unknownNode) {
        this.addedUnknownNodes.add(unknownNode);
    }

    void seal() {
        this.checkNotSealed();
        this.sealed = true;
    }

    protected final void checkNotSealed() {
        Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (Object)"Builder is sealed. No further modifications allowed");
    }

    boolean isSealed() {
        return this.sealed;
    }
}

