/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedNode;

public abstract class AbstractDocumentedDataNodeContainer
extends AbstractDocumentedNode
implements DataNodeContainer {
    private final Map<QName, DataSchemaNode> childNodes;
    private final Set<GroupingDefinition> groupings;
    private final Set<UsesNode> uses;
    private final Set<TypeDefinition<?>> typeDefinitions;
    private final Set<DataSchemaNode> publicChildNodes;

    protected AbstractDocumentedDataNodeContainer(AbstractDocumentedDataNodeContainerBuilder data) {
        super(data);
        this.childNodes = ImmutableMap.copyOf(data.getChildNodes());
        this.groupings = ImmutableSet.copyOf(data.getGroupings());
        this.uses = ImmutableSet.copyOf(data.getUsesNodes());
        this.typeDefinitions = ImmutableSet.copyOf(data.getTypeDefinitions());
        this.publicChildNodes = ImmutableSet.copyOf(this.childNodes.values());
    }

    public final Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public final Set<DataSchemaNode> getChildNodes() {
        return this.publicChildNodes;
    }

    public final Set<GroupingDefinition> getGroupings() {
        return this.groupings;
    }

    public final DataSchemaNode getDataChildByName(QName name) {
        return this.childNodes.get(name);
    }

    public final DataSchemaNode getDataChildByName(String name) {
        for (DataSchemaNode node : this.childNodes.values()) {
            if (!node.getQName().getLocalName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public Set<UsesNode> getUses() {
        return this.uses;
    }
}

