/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.util.AbstractDocumentedNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public abstract class AbstractDocumentedDataNodeContainerBuilder
extends AbstractDocumentedNodeBuilder
implements DataNodeContainerBuilder {
    protected final QName qname;
    private final Map<QName, DataSchemaNode> childNodes = new LinkedHashMap<QName, DataSchemaNode>();
    private final List<DataSchemaNodeBuilder> addedChildNodes = new ArrayList<DataSchemaNodeBuilder>();
    private final Set<GroupingDefinition> groupings = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<GroupingBuilder> addedGroupings = new HashSet<GroupingBuilder>();
    private final Set<TypeDefinition<?>> typedefs = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<TypeDefinitionBuilder> addedTypedefs = new HashSet<TypeDefinitionBuilder>();
    private final Set<UsesNode> usesNodes = new HashSet<UsesNode>();
    private final List<UsesNodeBuilder> addedUsesNodes = new ArrayList<UsesNodeBuilder>();

    protected AbstractDocumentedDataNodeContainerBuilder(String moduleName, int line, QName qname) {
        super(moduleName, line);
        this.qname = qname;
    }

    protected AbstractDocumentedDataNodeContainerBuilder(String moduleName, int line, QName qname, SchemaPath path, DataNodeContainer base) {
        super(moduleName, line);
        this.qname = qname;
        this.addedChildNodes.addAll(BuilderUtils.wrapChildNodes(moduleName, line, base.getChildNodes(), path, qname));
        this.addedGroupings.addAll(BuilderUtils.wrapGroupings(moduleName, line, base.getGroupings(), path, qname));
        this.addedTypedefs.addAll(BuilderUtils.wrapTypedefs(moduleName, line, base, path, qname));
        this.usesNodes.addAll(base.getUses());
        if (base instanceof DocumentedNode) {
            DocumentedNode node = (DocumentedNode)base;
            this.setDescription(node.getDescription());
            this.setReference(node.getReference());
            this.setStatus(node.getStatus());
        }
    }

    @Override
    public final QName getQName() {
        return this.qname;
    }

    @Override
    public final Map<QName, DataSchemaNode> getChildNodes() {
        return this.childNodes;
    }

    @Override
    public final List<DataSchemaNodeBuilder> getChildNodeBuilders() {
        return this.addedChildNodes;
    }

    @Override
    public final DataSchemaNodeBuilder getDataChildByName(String name) {
        for (DataSchemaNodeBuilder child : this.addedChildNodes) {
            if (!child.getQName().getLocalName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public final void addChildNode(DataSchemaNodeBuilder child) {
        this.checkIsPresent(child);
        this.addedChildNodes.add(child);
    }

    @Override
    public final void addChildNode(int index, DataSchemaNodeBuilder child) {
        this.checkIsPresent(child);
        if (index > this.addedChildNodes.size()) {
            this.addedChildNodes.add(child);
        } else {
            this.addedChildNodes.add(index, child);
        }
    }

    private void checkIsPresent(DataSchemaNodeBuilder child) {
        for (DataSchemaNodeBuilder addedChildNode : this.addedChildNodes) {
            if (!addedChildNode.getQName().equals((Object)child.getQName())) continue;
            throw new YangParseException(child.getModuleName(), child.getLine(), String.format("Can not add '%s' to '%s' in module '%s': node with same name already declared at line %d", child, this, this.getModuleName(), addedChildNode.getLine()));
        }
    }

    @Override
    public final void addChildNodeToContext(DataSchemaNodeBuilder child) {
        this.addedChildNodes.add(child);
    }

    @Override
    public final void addChildNode(DataSchemaNode child) {
        this.checkNotSealed();
        QName childName = child.getQName();
        if (this.childNodes.containsKey(childName)) {
            throw new YangParseException(this.getModuleName(), this.getLine(), String.format("Can not add '%s' to '%s' in module '%s': node with same name already declared", child, this, this.getModuleName()));
        }
        this.childNodes.put(childName, child);
    }

    @Override
    public final Set<GroupingDefinition> getGroupings() {
        return this.groupings;
    }

    @Override
    public final Set<GroupingBuilder> getGroupingBuilders() {
        return this.addedGroupings;
    }

    @Override
    public void addGrouping(GroupingBuilder grouping) {
        this.checkNotSealed();
        QName groupingName = grouping.getQName();
        for (GroupingBuilder addedGrouping : this.addedGroupings) {
            if (!addedGrouping.getQName().equals((Object)groupingName)) continue;
            throw new YangParseException(grouping.getModuleName(), grouping.getLine(), String.format("Can not add '%s': grouping with same name already declared in module '%s' at line %d", grouping, this.getModuleName(), addedGrouping.getLine()));
        }
        this.addedGroupings.add(grouping);
    }

    @Override
    public final Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.typedefs;
    }

    public final Set<UsesNode> getUsesNodes() {
        return this.usesNodes;
    }

    @Override
    public final List<UsesNodeBuilder> getUsesNodeBuilders() {
        return this.addedUsesNodes;
    }

    @Override
    public final void addUsesNode(UsesNodeBuilder usesNode) {
        this.checkNotSealed();
        this.addedUsesNodes.add(usesNode);
    }

    @Override
    public final Set<TypeDefinitionBuilder> getTypeDefinitionBuilders() {
        return this.addedTypedefs;
    }

    @Override
    public void addTypedef(TypeDefinitionBuilder type) {
        this.checkNotSealed();
        String typeName = type.getQName().getLocalName();
        for (TypeDefinitionBuilder addedTypedef : this.addedTypedefs) {
            if (!addedTypedef.getQName().getLocalName().equals(typeName)) continue;
            throw new YangParseException(this.getModuleName(), type.getLine(), "Can not add typedef '" + typeName + "': typedef with same name already declared at line " + addedTypedef.getLine());
        }
        this.addedTypedefs.add(type);
    }

    protected abstract String getStatementName();

    protected void buildChildren() {
        this.checkNotSealed();
        this.seal();
        for (DataSchemaNodeBuilder dataSchemaNodeBuilder : this.addedChildNodes) {
            this.childNodes.put(dataSchemaNodeBuilder.getQName(), dataSchemaNodeBuilder.build());
        }
        for (GroupingBuilder groupingBuilder : this.addedGroupings) {
            this.groupings.add(groupingBuilder.build());
        }
        for (TypeDefinitionBuilder typeDefinitionBuilder : this.addedTypedefs) {
            this.typedefs.add(typeDefinitionBuilder.build());
        }
        for (UsesNodeBuilder usesNodeBuilder : this.addedUsesNodes) {
            this.usesNodes.add(usesNodeBuilder.build());
        }
    }
}

