/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.util;

import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.Iterator;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;

public final class Comparators {
    public static final SchemaNodeComparator SCHEMA_NODE_COMP = new SchemaNodeComparator();
    public static final AugmentComparator AUGMENT_COMP = new AugmentComparator();
    public static final AugmentBuilderComparator AUGMENT_BUILDER_COMP = new AugmentBuilderComparator();

    private Comparators() {
    }

    private static final class AugmentComparator
    implements Comparator<AugmentationSchema> {
        private AugmentComparator() {
        }

        @Override
        public int compare(AugmentationSchema augSchema1, AugmentationSchema augSchema2) {
            Iterator thisIt = augSchema1.getTargetPath().getPathFromRoot().iterator();
            Iterator otherIt = augSchema2.getTargetPath().getPathFromRoot().iterator();
            while (thisIt.hasNext()) {
                if (otherIt.hasNext()) {
                    int comp = ((QName)thisIt.next()).compareTo((QName)otherIt.next());
                    if (comp == 0) continue;
                    return comp;
                }
                return 1;
            }
            if (otherIt.hasNext()) {
                return -1;
            }
            return 0;
        }
    }

    private static final class AugmentBuilderComparator
    implements Comparator<AugmentationSchemaBuilder> {
        private AugmentBuilderComparator() {
        }

        @Override
        public int compare(AugmentationSchemaBuilder o1, AugmentationSchemaBuilder o2) {
            int length1 = Iterables.size((Iterable)o1.getTargetPath().getPathFromRoot());
            int length2 = Iterables.size((Iterable)o2.getTargetPath().getPathFromRoot());
            return length1 - length2;
        }
    }

    private static final class SchemaNodeComparator
    implements Comparator<SchemaNode> {
        private SchemaNodeComparator() {
        }

        @Override
        public int compare(SchemaNode o1, SchemaNode o2) {
            return o1.getQName().compareTo(o2.getQName());
        }
    }
}

