/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.concurrent.Immutable;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;
import org.opendaylight.yangtools.yang.model.util.AbstractSchemaContext;
import org.opendaylight.yangtools.yang.parser.util.ModuleDependencySort;

@Immutable
final class SchemaContextImpl
extends AbstractSchemaContext {
    private final Map<ModuleIdentifier, String> identifiersToSources;
    private final SetMultimap<URI, Module> namespaceToModules;
    private final SetMultimap<String, Module> nameToModules;
    private final Set<Module> modules;

    SchemaContextImpl(Set<Module> modules, Map<ModuleIdentifier, String> identifiersToSources) {
        this.identifiersToSources = ImmutableMap.copyOf(identifiersToSources);
        this.modules = ImmutableSet.copyOf(ModuleDependencySort.sort(modules.toArray(new Module[modules.size()])));
        SetMultimap nsMap = Multimaps.newSetMultimap(new TreeMap(), (Supplier)MODULE_SET_SUPPLIER);
        SetMultimap nameMap = Multimaps.newSetMultimap(new TreeMap(), (Supplier)MODULE_SET_SUPPLIER);
        for (Module m : modules) {
            nameMap.put((Object)m.getName(), (Object)m);
            nsMap.put((Object)m.getNamespace(), (Object)m);
        }
        this.namespaceToModules = ImmutableSetMultimap.copyOf((Multimap)nsMap);
        this.nameToModules = ImmutableSetMultimap.copyOf((Multimap)nameMap);
    }

    protected Map<ModuleIdentifier, String> getIdentifiersToSources() {
        return this.identifiersToSources;
    }

    public Set<Module> getModules() {
        return this.modules;
    }

    protected SetMultimap<URI, Module> getNamespaceToModules() {
        return this.namespaceToModules;
    }

    protected SetMultimap<String, Module> getNameToModules() {
        return this.nameToModules;
    }

    public String toString() {
        return String.format("SchemaContextImpl{modules=%s}", this.modules);
    }
}

