/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.LinkedList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

final class SchemaPathStack {
    private final Deque<SchemaPath> paths = new LinkedList<SchemaPath>();

    SchemaPathStack() {
    }

    SchemaPath addNodeToPath(QName name) {
        SchemaPath sp = this.paths.pop();
        sp = sp.createChild(new QName[]{name});
        this.paths.push(sp);
        return sp;
    }

    QName removeNodeFromPath() {
        SchemaPath sp = this.paths.pop();
        QName ret = sp.getLastComponent();
        this.paths.push((SchemaPath)Preconditions.checkNotNull((Object)sp.getParent(), (String)"Attempted to remove too many nodes from schemapath at stack %s", (Object[])new Object[]{this.paths}));
        return ret;
    }

    SchemaPath currentSchemaPath() {
        return this.paths.peek();
    }

    void pop() {
        this.paths.pop();
    }

    void push() {
        this.paths.push(SchemaPath.ROOT);
    }
}

