/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YangErrorListener
extends BaseErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(YangErrorListener.class);
    private final List<YangSyntaxErrorException> exceptions = new ArrayList<YangSyntaxErrorException>();

    YangErrorListener() {
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        LOG.debug("Syntax error at {}:{}: {}", new Object[]{line, charPositionInLine, msg, e});
        String module = YangErrorListener.getModuleName(recognizer);
        this.exceptions.add(new YangSyntaxErrorException(module, line, charPositionInLine, msg, (Throwable)e));
    }

    private static String getModuleName(Recognizer<?, ?> recognizer) {
        if (!(recognizer instanceof Parser)) {
            return null;
        }
        Parser parser = (Parser)recognizer;
        try {
            String model = parser.getInputStream().getTokenSource().getInputStream().toString();
            model = model.substring(0, model.indexOf("\n"));
            model = model.substring(model.indexOf("module") + 6);
            model = model.substring(0, model.indexOf("{"));
            model = model.trim();
            return model;
        }
        catch (Exception e) {
            LOG.debug("Failed to extract module name from parser {}", (Object)parser, (Object)e);
            return null;
        }
    }

    public void validate() throws YangSyntaxErrorException {
        if (this.exceptions.isEmpty()) {
            return;
        }
        if (this.exceptions.size() == 1) {
            throw this.exceptions.get(0);
        }
        StringBuilder sb = new StringBuilder();
        String module = null;
        boolean first = true;
        for (YangSyntaxErrorException e : this.exceptions) {
            if (module == null) {
                module = e.getModule();
            }
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(e.getFormattedMessage());
        }
        throw new YangSyntaxErrorException(module, 0, 0, sb.toString());
    }
}

