/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.ByteSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.concurrent.Immutable;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.opendaylight.yangtools.antlrv4.code.gen.YangLexer;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.parser.api.YangContextParser;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.ExtensionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeAwareBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.GroupingUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentitySchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.TypeUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.util.Comparators;
import org.opendaylight.yangtools.yang.parser.impl.GroupingSort;
import org.opendaylight.yangtools.yang.parser.impl.SchemaContextImpl;
import org.opendaylight.yangtools.yang.parser.impl.YangErrorListener;
import org.opendaylight.yangtools.yang.parser.impl.YangModelBasicValidator;
import org.opendaylight.yangtools.yang.parser.impl.YangParserListenerImpl;
import org.opendaylight.yangtools.yang.parser.util.ModuleDependencySort;
import org.opendaylight.yangtools.yang.parser.util.NamedByteArrayInputStream;
import org.opendaylight.yangtools.yang.parser.util.NamedFileInputStream;
import org.opendaylight.yangtools.yang.parser.util.NamedInputStream;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class YangParserImpl
implements YangContextParser {
    private static final Logger LOG = LoggerFactory.getLogger(YangParserImpl.class);
    private static final YangParserImpl INSTANCE = new YangParserImpl();

    public static YangParserImpl getInstance() {
        return INSTANCE;
    }

    @Deprecated
    public Set<Module> parseYangModels(File yangFile, File directory) {
        try {
            return this.parseFile(yangFile, directory).getModules();
        }
        catch (IOException | YangSyntaxErrorException e) {
            throw new YangParseException("Failed to parse yang data", (Exception)e);
        }
    }

    public SchemaContext parseFile(File yangFile, File directory) throws IOException, YangSyntaxErrorException {
        Preconditions.checkState((boolean)yangFile.exists(), (Object)(yangFile + " does not exists"));
        Preconditions.checkState((boolean)directory.exists(), (Object)(directory + " does not exists"));
        Preconditions.checkState((boolean)directory.isDirectory(), (Object)(directory + " is not a directory"));
        String yangFileName = yangFile.getName();
        String[] fileList = (String[])Preconditions.checkNotNull((Object)directory.list(), (Object)(directory + " not found or is not a directory"));
        LinkedHashMap<ByteSource, File> sourceToFile = new LinkedHashMap<ByteSource, File>();
        ByteSource mainFileSource = BuilderUtils.fileToByteSource(yangFile);
        sourceToFile.put(mainFileSource, yangFile);
        for (String fileName : fileList) {
            File dependency;
            if (fileName.equals(yangFileName) || !(dependency = new File(directory, fileName)).isFile()) continue;
            sourceToFile.put(BuilderUtils.fileToByteSource(dependency), dependency);
        }
        Map<ByteSource, ModuleBuilder> sourceToBuilder = this.parseSourcesToBuilders(sourceToFile.keySet(), null);
        ModuleBuilder main = sourceToBuilder.get(mainFileSource);
        ArrayList<ModuleBuilder> moduleBuilders = new ArrayList<ModuleBuilder>();
        moduleBuilders.add(main);
        this.filterImports(main, new ArrayList<ModuleBuilder>(sourceToBuilder.values()), moduleBuilders);
        Collection<ModuleBuilder> resolved = this.resolveSubmodules(moduleBuilders);
        List<ModuleBuilder> sortedBuilders = ModuleDependencySort.sort(resolved);
        Map<URI, NavigableMap<Date, ModuleBuilder>> modules = YangParserImpl.resolveModulesWithImports(sortedBuilders, null);
        Collection<Module> unsorted = this.build(modules).values();
        LinkedHashSet<Module> result = new LinkedHashSet<Module>(ModuleDependencySort.sort(unsorted.toArray(new Module[unsorted.size()])));
        return this.resolveSchemaContext(result);
    }

    @Deprecated
    public Set<Module> parseYangModels(List<File> yangFiles) {
        return this.parseFiles(yangFiles).getModules();
    }

    public SchemaContext parseFiles(Collection<File> yangFiles) {
        Collection<Module> unsorted = this.parseYangModelsMapped(yangFiles).values();
        LinkedHashSet<Module> sorted = new LinkedHashSet<Module>(ModuleDependencySort.sort(unsorted.toArray(new Module[unsorted.size()])));
        return this.resolveSchemaContext(sorted);
    }

    @Deprecated
    public Set<Module> parseYangModels(List<File> yangFiles, SchemaContext context) {
        try {
            return this.parseFiles(yangFiles, context).getModules();
        }
        catch (IOException | YangSyntaxErrorException e) {
            throw new YangParseException("Failed to parse yang data", (Exception)e);
        }
    }

    public SchemaContext parseFiles(Collection<File> yangFiles, SchemaContext context) throws IOException, YangSyntaxErrorException {
        if (yangFiles == null) {
            return this.resolveSchemaContext(Collections.emptySet());
        }
        Collection<ByteSource> sources = BuilderUtils.filesToByteSources(yangFiles);
        return this.parseSources(sources, context);
    }

    @Deprecated
    public Set<Module> parseYangModelsFromStreams(List<InputStream> yangModelStreams) {
        try {
            Collection<ByteSource> sources = BuilderUtils.streamsToByteSources(yangModelStreams);
            return this.parseSources(sources).getModules();
        }
        catch (IOException | YangSyntaxErrorException e) {
            throw new YangParseException("Failed to parse yang data", (Exception)e);
        }
    }

    public SchemaContext parseSources(Collection<ByteSource> sources) throws IOException, YangSyntaxErrorException {
        return this.assembleContext(this.parseYangModelSources(sources, null).values());
    }

    @Deprecated
    public Set<Module> parseYangModelsFromStreams(List<InputStream> yangModelStreams, SchemaContext context) {
        try {
            Collection<ByteSource> sources = BuilderUtils.streamsToByteSources(yangModelStreams);
            return this.parseSources(sources, context).getModules();
        }
        catch (IOException | YangSyntaxErrorException e) {
            throw new YangParseException("Failed to parse yang data", (Exception)e);
        }
    }

    public SchemaContext parseSources(Collection<ByteSource> sources, SchemaContext context) throws IOException, YangSyntaxErrorException {
        if (sources == null) {
            return this.resolveSchemaContext(Collections.emptySet());
        }
        List<ModuleBuilder> sorted = this.resolveModuleBuilders(sources, context);
        Map<URI, NavigableMap<Date, ModuleBuilder>> modules = YangParserImpl.resolveModulesWithImports(sorted, context);
        LinkedHashSet<Module> unsorted = new LinkedHashSet<Module>(this.build(modules).values());
        if (context != null) {
            for (Module m : context.getModules()) {
                if (unsorted.contains(m)) continue;
                unsorted.add(m);
            }
        }
        LinkedHashSet<Module> result = new LinkedHashSet<Module>(ModuleDependencySort.sort(unsorted.toArray(new Module[unsorted.size()])));
        return this.resolveSchemaContext(result);
    }

    private static Map<URI, NavigableMap<Date, ModuleBuilder>> resolveModulesWithImports(List<ModuleBuilder> sorted, SchemaContext context) {
        Map<URI, NavigableMap<Date, ModuleBuilder>> modules = YangParserImpl.orderModules(sorted);
        for (ModuleBuilder module : sorted) {
            if (module == null) continue;
            for (ModuleImport imp : module.getImports().values()) {
                String prefix = imp.getPrefix();
                ModuleBuilder targetModule = BuilderUtils.findModuleFromBuilders(imp, sorted);
                if (targetModule == null) {
                    Module result = BuilderUtils.findModuleFromContext(context, module, prefix, 0);
                    targetModule = new ModuleBuilder(result);
                    NavigableMap<Date, ModuleBuilder> map = modules.get(targetModule.getNamespace());
                    if (map == null) {
                        map = new TreeMap<Date, ModuleBuilder>();
                        map.put(targetModule.getRevision(), targetModule);
                        modules.put(targetModule.getNamespace(), map);
                    } else {
                        map.put(targetModule.getRevision(), targetModule);
                    }
                }
                module.addImportedModule(prefix, targetModule);
            }
        }
        return modules;
    }

    public Map<File, Module> parseYangModelsMapped(Collection<File> yangFiles) {
        Map<ByteSource, Module> byteSourceToModule;
        if (yangFiles == null || yangFiles.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<1, File> byteSourceToFile = new HashMap<1, File>();
        for (final File file : yangFiles) {
            ByteSource source = new ByteSource(){

                public InputStream openStream() throws IOException {
                    return new NamedFileInputStream(file, file.getPath());
                }
            };
            byteSourceToFile.put(source, file);
        }
        try {
            byteSourceToModule = this.parseYangModelSources(byteSourceToFile.keySet(), null);
        }
        catch (IOException | YangSyntaxErrorException e) {
            throw new YangParseException("Failed to parse yang data", (Exception)e);
        }
        LinkedHashMap<File, Module> result = new LinkedHashMap<File, Module>();
        for (Map.Entry<ByteSource, Module> entry : byteSourceToModule.entrySet()) {
            result.put((File)byteSourceToFile.get(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public Map<InputStream, Module> parseYangModelsFromStreamsMapped(Collection<InputStream> yangModelStreams) {
        Map<ByteSource, Module> sourceToModule;
        if (yangModelStreams == null || yangModelStreams.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<2, InputStream> sourceToStream = new HashMap<2, InputStream>();
        for (final InputStream stream : yangModelStreams) {
            ByteSource source = new ByteSource(){

                public InputStream openStream() throws IOException {
                    return NamedByteArrayInputStream.create(stream);
                }
            };
            sourceToStream.put(source, stream);
        }
        try {
            sourceToModule = this.parseYangModelSources(sourceToStream.keySet(), null);
        }
        catch (IOException | YangSyntaxErrorException e) {
            throw new YangParseException("Failed to parse yang data", (Exception)e);
        }
        LinkedHashMap<InputStream, Module> result = new LinkedHashMap<InputStream, Module>();
        for (Map.Entry<ByteSource, Module> entry : sourceToModule.entrySet()) {
            result.put((InputStream)sourceToStream.get(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public SchemaContext resolveSchemaContext(Set<Module> modules) {
        HashMap<ModuleIdentifier, String> identifiersToSources = new HashMap<ModuleIdentifier, String>();
        for (Module module : modules) {
            ModuleImpl moduleImpl = (ModuleImpl)module;
            identifiersToSources.put((ModuleIdentifier)module, moduleImpl.getSource());
        }
        return new SchemaContextImpl(modules, identifiersToSources);
    }

    public Collection<Module> buildModules(Collection<ModuleBuilder> builders) {
        Collection<ModuleBuilder> unsorted = this.resolveSubmodules(builders);
        List<ModuleBuilder> sorted = ModuleDependencySort.sort(unsorted);
        Map<URI, NavigableMap<Date, ModuleBuilder>> modules = YangParserImpl.resolveModulesWithImports(sorted, null);
        Map<ModuleBuilder, Module> builderToModule = this.build(modules);
        return builderToModule.values();
    }

    public SchemaContext assembleContext(Collection<Module> modules) {
        LinkedHashSet<Module> sorted = new LinkedHashSet<Module>(ModuleDependencySort.sort(modules.toArray(new Module[modules.size()])));
        return this.resolveSchemaContext(sorted);
    }

    private Map<ByteSource, Module> parseYangModelSources(Collection<ByteSource> sources, SchemaContext context) throws IOException, YangSyntaxErrorException {
        if (sources == null || sources.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<ByteSource, ModuleBuilder> sourceToBuilder = this.resolveSources(sources, context);
        List<ModuleBuilder> sorted = ModuleDependencySort.sort(sourceToBuilder.values());
        Map<URI, NavigableMap<Date, ModuleBuilder>> modules = YangParserImpl.resolveModulesWithImports(sorted, null);
        Map<ModuleBuilder, Module> builderToModule = this.build(modules);
        BiMap builderToSource = HashBiMap.create(sourceToBuilder).inverse();
        sorted = ModuleDependencySort.sort(builderToModule.keySet());
        LinkedHashMap<ByteSource, Module> result = new LinkedHashMap<ByteSource, Module>();
        for (ModuleBuilder moduleBuilder : sorted) {
            Module value = (Module)Preconditions.checkNotNull((Object)builderToModule.get(moduleBuilder), (String)"Cannot get module for %s", (Object[])new Object[]{moduleBuilder});
            result.put((ByteSource)builderToSource.get(moduleBuilder), value);
        }
        return result;
    }

    private Map<ByteSource, ModuleBuilder> resolveSources(Collection<ByteSource> streams, SchemaContext context) throws IOException, YangSyntaxErrorException {
        Map<ByteSource, ModuleBuilder> builders = this.parseSourcesToBuilders(streams, context);
        return this.resolveSubmodules(builders);
    }

    private Map<ByteSource, ModuleBuilder> parseSourcesToBuilders(Collection<ByteSource> sources, SchemaContext context) throws IOException, YangSyntaxErrorException {
        ParseTreeWalker walker = new ParseTreeWalker();
        Map<ByteSource, ParseTree> sourceToTree = this.parseYangSources(sources);
        LinkedHashMap<ByteSource, ModuleBuilder> sourceToBuilder = new LinkedHashMap<ByteSource, ModuleBuilder>();
        new YangModelBasicValidator(walker).validate(sourceToTree.values());
        Map<String, NavigableMap<Date, URI>> namespaceContext = BuilderUtils.createYangNamespaceContext(sourceToTree.values(), (Optional<SchemaContext>)Optional.fromNullable((Object)context));
        for (Map.Entry<ByteSource, ParseTree> entry : sourceToTree.entrySet()) {
            ByteSource source = entry.getKey();
            String path = null;
            try (InputStream stream = source.openStream();){
                if (stream instanceof NamedInputStream) {
                    path = stream.toString();
                }
            }
            YangParserListenerImpl yangModelParser = new YangParserListenerImpl(namespaceContext, path);
            walker.walk((ParseTreeListener)yangModelParser, entry.getValue());
            ModuleBuilder moduleBuilder = yangModelParser.getModuleBuilder();
            moduleBuilder.setSource(source);
            sourceToBuilder.put(source, moduleBuilder);
        }
        return sourceToBuilder;
    }

    private Map<ByteSource, ModuleBuilder> resolveSubmodules(Map<ByteSource, ModuleBuilder> builders) {
        HashMap<ByteSource, ModuleBuilder> modules = new HashMap<ByteSource, ModuleBuilder>();
        HashMap<String, NavigableMap<Date, ModuleBuilder>> submodules = new HashMap<String, NavigableMap<Date, ModuleBuilder>>();
        for (Map.Entry<ByteSource, ModuleBuilder> entry : builders.entrySet()) {
            ModuleBuilder builder = entry.getValue();
            if (builder.isSubmodule()) {
                String submoduleName = builder.getName();
                TreeMap<Date, ModuleBuilder> map = (TreeMap<Date, ModuleBuilder>)submodules.get(submoduleName);
                if (map == null) {
                    map = new TreeMap<Date, ModuleBuilder>();
                    map.put(builder.getRevision(), builder);
                    submodules.put(submoduleName, map);
                    continue;
                }
                map.put(builder.getRevision(), builder);
                continue;
            }
            modules.put(entry.getKey(), builder);
        }
        for (ModuleBuilder module : modules.values()) {
            this.resolveSubmodules(module, submodules);
        }
        return modules;
    }

    private Collection<ModuleBuilder> resolveSubmodules(Collection<ModuleBuilder> builders) {
        HashSet<ModuleBuilder> modules = new HashSet<ModuleBuilder>();
        HashMap<String, NavigableMap<Date, ModuleBuilder>> submodules = new HashMap<String, NavigableMap<Date, ModuleBuilder>>();
        for (ModuleBuilder builder : builders) {
            if (builder.isSubmodule()) {
                String submoduleName = builder.getName();
                TreeMap<Date, ModuleBuilder> map = (TreeMap<Date, ModuleBuilder>)submodules.get(submoduleName);
                if (map == null) {
                    map = new TreeMap<Date, ModuleBuilder>();
                    map.put(builder.getRevision(), builder);
                    submodules.put(submoduleName, map);
                    continue;
                }
                map.put(builder.getRevision(), builder);
                continue;
            }
            modules.add(builder);
        }
        for (ModuleBuilder module : modules) {
            this.resolveSubmodules(module, submodules);
        }
        return modules;
    }

    private void resolveSubmodules(ModuleBuilder module, Map<String, NavigableMap<Date, ModuleBuilder>> submodules) {
        Map<String, Date> includes = module.getIncludedModules();
        for (Map.Entry<String, Date> entry : includes.entrySet()) {
            ModuleBuilder submodule;
            NavigableMap<Date, ModuleBuilder> subs = submodules.get(entry.getKey());
            if (subs == null) {
                throw new YangParseException("Failed to find references submodule " + entry.getKey() + " in module " + module.getName());
            }
            Date rev = entry.getValue();
            if (rev == null) {
                submodule = subs.lastEntry().getValue();
            } else {
                submodule = (ModuleBuilder)subs.get(rev);
                if (submodule == null) {
                    submodule = subs.lastEntry().getValue();
                }
            }
            if (!submodule.getIncludedModules().isEmpty()) {
                this.resolveSubmodules(submodule, submodules);
            }
            this.addSubmoduleToModule(submodule, module);
        }
    }

    private void addSubmoduleToModule(ModuleBuilder submodule, ModuleBuilder module) {
        module.addSubmodule(submodule);
        submodule.setParent(module);
        module.getDirtyNodes().addAll(submodule.getDirtyNodes());
        module.getImports().putAll(submodule.getImports());
        module.getAugments().addAll(submodule.getAugments());
        module.getAugmentBuilders().addAll(submodule.getAugmentBuilders());
        module.getAllAugments().addAll(submodule.getAllAugments());
        module.getChildNodeBuilders().addAll(submodule.getChildNodeBuilders());
        module.getChildNodes().putAll(submodule.getChildNodes());
        module.getGroupings().addAll(submodule.getGroupings());
        module.getGroupingBuilders().addAll(submodule.getGroupingBuilders());
        module.getTypeDefinitions().addAll(submodule.getTypeDefinitions());
        module.getTypeDefinitionBuilders().addAll(submodule.getTypeDefinitionBuilders());
        module.getUsesNodes().addAll(submodule.getUsesNodes());
        module.getUsesNodeBuilders().addAll(submodule.getUsesNodeBuilders());
        module.getAllGroupings().addAll(submodule.getAllGroupings());
        module.getAllUsesNodes().addAll(submodule.getAllUsesNodes());
        module.getRpcs().addAll(submodule.getRpcs());
        module.getAddedRpcs().addAll(submodule.getAddedRpcs());
        module.getNotifications().addAll(submodule.getNotifications());
        module.getAddedNotifications().addAll(submodule.getAddedNotifications());
        module.getIdentities().addAll(submodule.getIdentities());
        module.getAddedIdentities().addAll(submodule.getAddedIdentities());
        module.getFeatures().addAll(submodule.getFeatures());
        module.getAddedFeatures().addAll(submodule.getAddedFeatures());
        module.getDeviations().addAll(submodule.getDeviations());
        module.getDeviationBuilders().addAll(submodule.getDeviationBuilders());
        module.getExtensions().addAll(submodule.getExtensions());
        module.getAddedExtensions().addAll(submodule.getAddedExtensions());
        module.getUnknownNodes().addAll(submodule.getUnknownNodes());
        module.getAllUnknownNodes().addAll(submodule.getAllUnknownNodes());
    }

    private List<ModuleBuilder> resolveModuleBuilders(Collection<ByteSource> yangFileStreams, SchemaContext context) throws IOException, YangSyntaxErrorException {
        Map<ByteSource, ModuleBuilder> parsedBuilders = this.resolveSources(yangFileStreams, context);
        ModuleBuilder[] builders = new ModuleBuilder[parsedBuilders.size()];
        parsedBuilders.values().toArray(builders);
        List<ModuleBuilder> sorted = context == null ? ModuleDependencySort.sort(builders) : ModuleDependencySort.sortWithContext(context, builders);
        return sorted;
    }

    private static Map<URI, NavigableMap<Date, ModuleBuilder>> orderModules(List<ModuleBuilder> modules) {
        LinkedHashMap<URI, NavigableMap<Date, ModuleBuilder>> result = new LinkedHashMap<URI, NavigableMap<Date, ModuleBuilder>>();
        for (ModuleBuilder builder : modules) {
            TreeMap<Date, ModuleBuilder> builderByRevision;
            if (builder == null) continue;
            URI ns = builder.getNamespace();
            Date rev = builder.getRevision();
            if (rev == null) {
                rev = new Date(0L);
            }
            if ((builderByRevision = (TreeMap<Date, ModuleBuilder>)result.get(ns)) == null) {
                builderByRevision = new TreeMap<Date, ModuleBuilder>();
                builderByRevision.put(rev, builder);
                result.put(ns, builderByRevision);
                continue;
            }
            builderByRevision.put(rev, builder);
        }
        return result;
    }

    private void filterImports(ModuleBuilder main, Collection<ModuleBuilder> other, Collection<ModuleBuilder> filtered) {
        Map<String, ModuleImport> imports = main.getImports();
        if (main.isSubmodule()) {
            TreeMap<Date, ModuleBuilder> dependencies = new TreeMap<Date, ModuleBuilder>();
            for (ModuleBuilder mb : other) {
                if (!mb.getName().equals(main.getBelongsTo())) continue;
                dependencies.put(mb.getRevision(), mb);
            }
            ModuleBuilder parent = (ModuleBuilder)dependencies.get(dependencies.firstKey());
            filtered.add(parent);
            imports.putAll(parent.getImports());
        }
        for (ModuleImport mi : imports.values()) {
            for (ModuleBuilder builder : other) {
                if (!mi.getModuleName().equals(builder.getModuleName())) continue;
                if (mi.getRevision() == null) {
                    if (filtered.contains(builder)) continue;
                    filtered.add(builder);
                    this.filterImports(builder, other, filtered);
                    continue;
                }
                if (filtered.contains(builder) || !mi.getRevision().equals(builder.getRevision())) continue;
                filtered.add(builder);
                this.filterImports(builder, other, filtered);
            }
        }
    }

    private Map<ByteSource, ParseTree> parseYangSources(Collection<ByteSource> sources) throws IOException, YangSyntaxErrorException {
        HashMap<ByteSource, ParseTree> trees = new HashMap<ByteSource, ParseTree>();
        for (ByteSource source : sources) {
            InputStream stream = source.openStream();
            Throwable throwable = null;
            try {
                trees.put(source, (ParseTree)YangParserImpl.parseYangSource(stream));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return trees;
    }

    public static YangParser.YangContext parseYangSource(InputStream stream) throws IOException, YangSyntaxErrorException {
        YangLexer lexer = new YangLexer((CharStream)new ANTLRInputStream(stream));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        YangParser parser = new YangParser((TokenStream)tokens);
        parser.removeErrorListeners();
        YangErrorListener errorListener = new YangErrorListener();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        YangParser.YangContext result = parser.yang();
        errorListener.validate();
        return result;
    }

    public static YangParser.YangContext parseStreamWithoutErrorListeners(InputStream yangStream) {
        YangParser.YangContext result = null;
        try {
            ANTLRInputStream input = new ANTLRInputStream(yangStream);
            YangLexer lexer = new YangLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            YangParser parser = new YangParser((TokenStream)tokens);
            parser.removeErrorListeners();
            result = parser.yang();
        }
        catch (IOException e) {
            LOG.warn("Exception while reading yang file: " + yangStream, (Throwable)e);
        }
        return result;
    }

    private Map<ModuleBuilder, Module> build(Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        this.resolveDirtyNodes(modules);
        this.resolveAugmentsTargetPath(modules);
        this.resolveUsesTargetGrouping(modules);
        this.resolveUsesForGroupings(modules);
        this.resolveUsesForNodes(modules);
        this.resolveAugments(modules);
        this.resolveIdentities(modules);
        this.checkChoiceCasesForDuplicityQNames(modules);
        LinkedHashMap<ModuleBuilder, Module> result = new LinkedHashMap<ModuleBuilder, Module>();
        for (Map.Entry<URI, NavigableMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry childEntry : entry.getValue().entrySet()) {
                ModuleBuilder moduleBuilder = (ModuleBuilder)childEntry.getValue();
                Module module = moduleBuilder.build();
                result.put(moduleBuilder, module);
            }
        }
        return result;
    }

    private void resolveDirtyNodes(Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        for (Map.Entry<URI, NavigableMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry childEntry : entry.getValue().entrySet()) {
                ModuleBuilder module = (ModuleBuilder)childEntry.getValue();
                this.resolveUnknownNodes(modules, module);
                this.resolveDirtyNodes(modules, module);
            }
        }
    }

    private void resolveDirtyNodes(Map<URI, NavigableMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        Set<TypeAwareBuilder> dirtyNodes = module.getDirtyNodes();
        if (!dirtyNodes.isEmpty()) {
            for (TypeAwareBuilder nodeToResolve : dirtyNodes) {
                if (nodeToResolve instanceof UnionTypeBuilder) {
                    TypeUtils.resolveTypeUnion((UnionTypeBuilder)nodeToResolve, modules, module);
                    continue;
                }
                if (nodeToResolve.getTypedef() instanceof IdentityrefTypeBuilder) {
                    IdentityrefTypeBuilder idref = (IdentityrefTypeBuilder)nodeToResolve.getTypedef();
                    IdentitySchemaNodeBuilder identity = BuilderUtils.findBaseIdentity(module, idref.getBaseString(), idref.getLine());
                    if (identity == null) {
                        throw new YangParseException(module.getName(), idref.getLine(), "Failed to find base identity");
                    }
                    idref.setBaseIdentity(identity);
                    nodeToResolve.setType((TypeDefinition<?>)idref.build());
                    continue;
                }
                TypeUtils.resolveType(nodeToResolve, modules, module);
            }
        }
    }

    private void resolveAugmentsTargetPath(Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        ArrayList<AugmentationSchemaBuilder> allAugments = new ArrayList<AugmentationSchemaBuilder>();
        for (Map.Entry<URI, NavigableMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry inner : entry.getValue().entrySet()) {
                allAugments.addAll(((ModuleBuilder)inner.getValue()).getAllAugments());
            }
        }
        for (AugmentationSchemaBuilder augment : allAugments) {
            this.setCorrectAugmentTargetPath(augment);
        }
    }

    private void setCorrectAugmentTargetPath(AugmentationSchemaBuilder augment) {
        Builder parent = augment.getParent();
        SchemaPath targetNodeSchemaPath = parent instanceof UsesNodeBuilder ? this.findUsesAugmentTargetNodePath(((UsesNodeBuilder)parent).getParent(), augment) : augment.getTargetPath();
        for (DataSchemaNodeBuilder childNode : augment.getChildNodeBuilders()) {
            this.correctPathForAugmentNodes(childNode, targetNodeSchemaPath);
        }
    }

    private SchemaPath findUsesAugmentTargetNodePath(DataNodeContainerBuilder usesParent, AugmentationSchemaBuilder augment) {
        QNameModule qnm;
        QName parentQName = usesParent.getQName();
        if (parentQName == null) {
            ModuleBuilder m = BuilderUtils.getParentModule(usesParent);
            qnm = m.getQNameModule();
        } else {
            qnm = parentQName.getModule();
        }
        SchemaPath path = usesParent.getPath();
        for (QName qname : augment.getTargetPath().getPathFromRoot()) {
            path = path.createChild(new QName[]{QName.create((QNameModule)qnm, (String)qname.getLocalName())});
        }
        return path;
    }

    private void correctPathForAugmentNodes(DataSchemaNodeBuilder node, SchemaPath parentPath) {
        SchemaPath newPath = parentPath.createChild(new QName[]{node.getQName()});
        node.setPath(newPath);
        if (node instanceof DataNodeContainerBuilder) {
            for (DataSchemaNodeBuilder dataSchemaNodeBuilder : ((DataNodeContainerBuilder)((Object)node)).getChildNodeBuilders()) {
                this.correctPathForAugmentNodes(dataSchemaNodeBuilder, node.getPath());
            }
        }
        if (node instanceof ChoiceBuilder) {
            for (ChoiceCaseBuilder choiceCaseBuilder : ((ChoiceBuilder)node).getCases()) {
                this.correctPathForAugmentNodes(choiceCaseBuilder, node.getPath());
            }
        }
    }

    private void checkAugmentMandatoryNodes(Collection<AugmentationSchemaBuilder> augments) {
        for (AugmentationSchemaBuilder augment : augments) {
            URI augmentTargetNs = ((QName)augment.getTargetPath().getPathFromRoot().iterator().next()).getNamespace();
            Date augmentTargetRev = ((QName)augment.getTargetPath().getPathFromRoot().iterator().next()).getRevision();
            ModuleBuilder module = BuilderUtils.getParentModule(augment);
            if (augmentTargetNs.equals(module.getNamespace()) && augmentTargetRev.equals(module.getRevision())) continue;
            for (DataSchemaNodeBuilder childNode : augment.getChildNodeBuilders()) {
                if (!childNode.getConstraints().isMandatory()) continue;
                throw new YangParseException(augment.getModuleName(), augment.getLine(), "Error in augment parsing: cannot augment mandatory node " + childNode.getQName().getLocalName());
            }
        }
    }

    private void resolveAugments(Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        ArrayList all = new ArrayList();
        for (Map.Entry<URI, NavigableMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry inner : entry.getValue().entrySet()) {
                all.add(inner.getValue());
            }
        }
        for (ModuleBuilder mb : all) {
            if (mb == null) continue;
            List<AugmentationSchemaBuilder> augments = mb.getAllAugments();
            this.checkAugmentMandatoryNodes(augments);
            Collections.sort(augments, Comparators.AUGMENT_BUILDER_COMP);
            for (AugmentationSchemaBuilder augment : augments) {
                boolean resolved;
                if (augment.isResolved() || (resolved = this.resolveAugment(augment, mb, modules))) continue;
                throw new YangParseException(augment.getModuleName(), augment.getLine(), "Error in augment parsing: failed to find augment target: " + augment);
            }
        }
    }

    private boolean resolveUsesAugment(AugmentationSchemaBuilder augment, ModuleBuilder module, Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        if (augment.isResolved()) {
            return true;
        }
        UsesNodeBuilder usesNode = (UsesNodeBuilder)augment.getParent();
        DataNodeContainerBuilder parentNode = usesNode.getParent();
        SchemaPath resolvedTargetPath = this.findUsesAugmentTargetNodePath(parentNode, augment);
        Optional<SchemaNodeBuilder> potentialTargetNode = parentNode instanceof ModuleBuilder && resolvedTargetPath.isAbsolute() ? BuilderUtils.findSchemaNodeInModule(resolvedTargetPath, (ModuleBuilder)parentNode) : Optional.fromNullable((Object)BuilderUtils.findTargetNode(augment.getTargetPath().getPathFromRoot(), parentNode));
        if (potentialTargetNode.isPresent()) {
            SchemaNodeBuilder targetNode = (SchemaNodeBuilder)potentialTargetNode.get();
            if (targetNode instanceof AugmentationTargetBuilder) {
                BuilderUtils.fillAugmentTarget(augment, targetNode);
                ((AugmentationTargetBuilder)((Object)targetNode)).addAugmentation(augment);
                augment.setResolved(true);
                return true;
            }
            LOG.warn("Error in module {} at line {}: Unsupported augment target: {}. Augmentation process skipped.", new Object[]{module.getName(), augment.getLine(), potentialTargetNode});
            augment.setResolved(true);
            augment.setUnsupportedTarget(true);
            return true;
        }
        throw new YangParseException(module.getName(), augment.getLine(), String.format("Failed to resolve augment in uses. Invalid augment target path: %s", augment.getTargetPath()));
    }

    private boolean resolveAugment(AugmentationSchemaBuilder augment, ModuleBuilder module, Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        if (augment.isResolved()) {
            return true;
        }
        QName targetModuleName = (QName)augment.getTargetPath().getPathFromRoot().iterator().next();
        ModuleBuilder targetModule = BuilderUtils.findModule(targetModuleName, modules);
        if (targetModule == null) {
            throw new YangParseException(module.getModuleName(), augment.getLine(), "Failed to resolve augment " + augment);
        }
        return BuilderUtils.processAugmentation(augment, targetModule);
    }

    private void resolveIdentities(Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        for (Map.Entry<URI, NavigableMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry inner : entry.getValue().entrySet()) {
                ModuleBuilder module = (ModuleBuilder)inner.getValue();
                Set<IdentitySchemaNodeBuilder> identities = module.getAddedIdentities();
                for (IdentitySchemaNodeBuilder identity : identities) {
                    this.resolveIdentity(module, identity);
                }
            }
        }
    }

    private void resolveIdentity(ModuleBuilder module, IdentitySchemaNodeBuilder identity) {
        String baseIdentityName = identity.getBaseIdentityName();
        if (baseIdentityName != null) {
            IdentitySchemaNodeBuilder result = null;
            if (baseIdentityName.contains(":")) {
                int line = identity.getLine();
                String[] splittedBase = baseIdentityName.split(":");
                if (splittedBase.length > 2) {
                    throw new YangParseException(module.getName(), line, "Failed to parse identityref base: " + baseIdentityName);
                }
                String prefix = splittedBase[0];
                String name = splittedBase[1];
                if (prefix.equals(module.getPrefix()) && name.equals(identity.getQName().getLocalName())) {
                    throw new YangParseException(module.getName(), identity.getLine(), "Failed to parse base, identity name equals base identity name: " + baseIdentityName);
                }
                ModuleBuilder dependentModule = BuilderUtils.getModuleByPrefix(module, prefix);
                result = BuilderUtils.findIdentity(dependentModule.getAddedIdentities(), name);
            } else {
                if (baseIdentityName.equals(identity.getQName().getLocalName())) {
                    throw new YangParseException(module.getName(), identity.getLine(), "Failed to parse base, identity name equals base identity name: " + baseIdentityName);
                }
                result = BuilderUtils.findIdentity(module.getAddedIdentities(), baseIdentityName);
            }
            identity.setBaseIdentity(result);
        }
    }

    private void resolveUsesTargetGrouping(Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        ArrayList<UsesNodeBuilder> allUses = new ArrayList<UsesNodeBuilder>();
        for (Map.Entry<URI, NavigableMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry inner : entry.getValue().entrySet()) {
                allUses.addAll(((ModuleBuilder)inner.getValue()).getAllUsesNodes());
            }
        }
        for (UsesNodeBuilder usesNode : allUses) {
            ModuleBuilder module = BuilderUtils.getParentModule(usesNode);
            GroupingBuilder targetGroupingBuilder = GroupingUtils.getTargetGroupingFromModules(usesNode, modules, module);
            usesNode.setGrouping(targetGroupingBuilder);
        }
    }

    private void resolveUsesForGroupings(Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        HashSet<GroupingBuilder> allGroupings = new HashSet<GroupingBuilder>();
        for (Map.Entry<URI, NavigableMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry inner : entry.getValue().entrySet()) {
                ModuleBuilder module = (ModuleBuilder)inner.getValue();
                allGroupings.addAll(module.getAllGroupings());
            }
        }
        List<GroupingBuilder> sorted = GroupingSort.sort(allGroupings);
        for (GroupingBuilder gb : sorted) {
            ArrayList<UsesNodeBuilder> usesNodes = new ArrayList<UsesNodeBuilder>(GroupingSort.getAllUsesNodes(gb));
            Collections.sort(usesNodes, new GroupingUtils.UsesComparator());
            for (UsesNodeBuilder usesNode : usesNodes) {
                this.resolveUses(usesNode, modules);
            }
        }
    }

    private void resolveUsesForNodes(Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        for (Map.Entry<URI, NavigableMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry inner : entry.getValue().entrySet()) {
                ModuleBuilder module = (ModuleBuilder)inner.getValue();
                List<UsesNodeBuilder> usesNodes = module.getAllUsesNodes();
                Collections.sort(usesNodes, new GroupingUtils.UsesComparator());
                for (UsesNodeBuilder usesNode : usesNodes) {
                    this.resolveUses(usesNode, modules);
                }
            }
        }
    }

    private void resolveUses(UsesNodeBuilder usesNode, Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        if (!usesNode.isResolved()) {
            DataNodeContainerBuilder parent = usesNode.getParent();
            ModuleBuilder module = BuilderUtils.getParentModule(parent);
            GroupingBuilder target = GroupingUtils.getTargetGroupingFromModules(usesNode, modules, module);
            int index = this.nodeAfterUsesIndex(usesNode);
            List<DataSchemaNodeBuilder> targetNodes = target.instantiateChildNodes(parent);
            for (DataSchemaNodeBuilder targetNode : targetNodes) {
                parent.addChildNode(index++, targetNode);
            }
            parent.getTypeDefinitionBuilders().addAll(target.instantiateTypedefs(parent));
            parent.getGroupingBuilders().addAll(target.instantiateGroupings(parent));
            parent.getUnknownNodes().addAll(target.instantiateUnknownNodes(parent));
            usesNode.setResolved(true);
            for (AugmentationSchemaBuilder augment : usesNode.getAugmentations()) {
                this.resolveUsesAugment(augment, module, modules);
            }
            GroupingUtils.performRefine(usesNode);
        }
    }

    private int nodeAfterUsesIndex(UsesNodeBuilder usesNode) {
        DataNodeContainerBuilder parent = usesNode.getParent();
        int usesLine = usesNode.getLine();
        List<DataSchemaNodeBuilder> childNodes = parent.getChildNodeBuilders();
        if (childNodes.isEmpty()) {
            return 0;
        }
        DataSchemaNodeBuilder nextNodeAfterUses = null;
        for (DataSchemaNodeBuilder childNode : childNodes) {
            if (childNode.isAddedByUses() || childNode.isAugmenting() || childNode.getLine() <= usesLine) continue;
            nextNodeAfterUses = childNode;
            break;
        }
        if (nextNodeAfterUses == null) {
            return childNodes.size();
        }
        return parent.getChildNodeBuilders().indexOf(nextNodeAfterUses);
    }

    private void resolveUnknownNodes(Map<URI, NavigableMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        for (UnknownSchemaNodeBuilder usnb : module.getAllUnknownNodes()) {
            QName nodeType = usnb.getNodeType();
            String localName = usnb.getNodeType().getLocalName();
            ModuleBuilder dependentModule = BuilderUtils.findModule(nodeType, modules);
            if (dependentModule == null) {
                LOG.warn("Error in module {} at line {}: Failed to resolve node {}: no such extension definition found.", new Object[]{module.getName(), usnb.getLine(), usnb});
                continue;
            }
            ExtensionBuilder extBuilder = this.findExtBuilder(localName, dependentModule.getAddedExtensions());
            if (extBuilder == null) {
                ExtensionDefinition extDef = this.findExtDef(localName, dependentModule.getExtensions());
                if (extDef == null) {
                    LOG.warn("Error in module {} at line {}: Failed to resolve node {}: no such extension definition found.", new Object[]{module.getName(), usnb.getLine(), usnb});
                    continue;
                }
                usnb.setExtensionDefinition(extDef);
                continue;
            }
            usnb.setExtensionBuilder(extBuilder);
        }
    }

    private ExtensionBuilder findExtBuilder(String name, Collection<ExtensionBuilder> extensions) {
        for (ExtensionBuilder extension : extensions) {
            if (!extension.getQName().getLocalName().equals(name)) continue;
            return extension;
        }
        return null;
    }

    private ExtensionDefinition findExtDef(String name, Collection<ExtensionDefinition> extensions) {
        for (ExtensionDefinition extension : extensions) {
            if (!extension.getQName().getLocalName().equals(name)) continue;
            return extension;
        }
        return null;
    }

    private void checkChoiceCasesForDuplicityQNames(Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        for (Map.Entry<URI, NavigableMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry childEntry : entry.getValue().entrySet()) {
                ModuleBuilder moduleBuilder = (ModuleBuilder)childEntry.getValue();
                Module module = moduleBuilder.build();
                List<ChoiceSchemaNode> allChoicesFromModule = this.getChoicesFrom(module);
                for (ChoiceSchemaNode choiceNode : allChoicesFromModule) {
                    this.findDuplicityNodesIn(choiceNode, module, moduleBuilder, modules);
                }
            }
        }
    }

    private void findDuplicityNodesIn(ChoiceSchemaNode choiceNode, Module module, ModuleBuilder moduleBuilder, Map<URI, NavigableMap<Date, ModuleBuilder>> modules) {
        HashSet<QName> duplicityTestSet = new HashSet<QName>();
        for (ChoiceCaseNode choiceCaseNode : choiceNode.getCases()) {
            for (DataSchemaNode childSchemaNode : choiceCaseNode.getChildNodes()) {
                if (duplicityTestSet.add(childSchemaNode.getQName())) continue;
                Optional<SchemaNodeBuilder> schemaNodeBuilder = BuilderUtils.findSchemaNodeInModule(childSchemaNode.getPath(), moduleBuilder);
                String nameOfSchemaNode = childSchemaNode.getQName().getLocalName();
                int lineOfSchemaNode = 0;
                if (schemaNodeBuilder.isPresent()) {
                    lineOfSchemaNode = ((SchemaNodeBuilder)schemaNodeBuilder.get()).getLine();
                }
                throw new YangParseException(module.getName(), lineOfSchemaNode, String.format("Choice has two nodes case with same qnames - %s", nameOfSchemaNode));
            }
        }
    }

    private List<ChoiceSchemaNode> getChoicesFrom(Module module) {
        ArrayList<ChoiceSchemaNode> allChoices = new ArrayList<ChoiceSchemaNode>();
        for (DataSchemaNode dataSchemaNode : module.getChildNodes()) {
            this.findChoicesIn((SchemaNode)dataSchemaNode, allChoices);
        }
        return allChoices;
    }

    private void findChoicesIn(SchemaNode schemaNode, Collection<ChoiceSchemaNode> choiceNodes) {
        if (schemaNode instanceof ContainerSchemaNode) {
            ContainerSchemaNode contSchemaNode = (ContainerSchemaNode)schemaNode;
            for (DataSchemaNode dataSchemaNode : contSchemaNode.getChildNodes()) {
                this.findChoicesIn((SchemaNode)dataSchemaNode, choiceNodes);
            }
        } else if (schemaNode instanceof ListSchemaNode) {
            ListSchemaNode listSchemaNode = (ListSchemaNode)schemaNode;
            for (DataSchemaNode dataSchemaNode : listSchemaNode.getChildNodes()) {
                this.findChoicesIn((SchemaNode)dataSchemaNode, choiceNodes);
            }
        } else if (schemaNode instanceof ChoiceSchemaNode) {
            choiceNodes.add((ChoiceSchemaNode)schemaNode);
        }
    }
}

