/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParserBaseListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.ExtensionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeAwareBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AnyXmlBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.CopyUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.DeviationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.FeatureBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentitySchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.NotificationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RefineHolderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.TypeDefinitionBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilderImpl;
import org.opendaylight.yangtools.yang.parser.impl.ParserListenerUtils;
import org.opendaylight.yangtools.yang.parser.impl.SchemaPathStack;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangParserListenerImpl
extends YangParserBaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(YangParserListenerImpl.class);
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final String AUGMENT_STR = "augment";
    private static final String IMPORT_STR = "import";
    private static final String UNION_STR = "union";
    private static final String UNKNOWN_NODE_STR = "unknown-node";
    private final DateFormat revisionFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final SchemaPathStack stack = new SchemaPathStack();
    private final Map<String, NavigableMap<Date, URI>> namespaceContext;
    private final String sourcePath;
    private QName moduleQName = QName.create(null, (Date)new Date(0L), (String)"dummy");
    private ModuleBuilder moduleBuilder;
    private String moduleName;
    private int augmentOrder;
    private String yangModelPrefix;

    public YangParserListenerImpl(Map<String, NavigableMap<Date, URI>> namespaceContext, String sourcePath) {
        this.namespaceContext = namespaceContext;
        this.sourcePath = sourcePath;
    }

    public static YangParserListenerImpl create(Map<String, NavigableMap<Date, URI>> namespaceContext, String sourcePath, ParseTreeWalker walker, ParseTree tree) {
        YangParserListenerImpl ret = new YangParserListenerImpl(namespaceContext, sourcePath);
        walker.walk((ParseTreeListener)ret, tree);
        return ret;
    }

    @Override
    public void enterModule_stmt(YangParser.Module_stmtContext ctx) {
        this.moduleName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        LOG.trace("entering module {}", (Object)this.moduleName);
        YangParserListenerImpl.enterLog("module", this.moduleName, 0);
        this.stack.push();
        this.moduleBuilder = new ModuleBuilder(this.moduleName, this.sourcePath);
        String description = null;
        String reference = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                description = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                reference = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (description != null && reference != null) break;
        }
        this.moduleBuilder.setDescription(description);
        this.moduleBuilder.setReference(reference);
    }

    @Override
    public void exitModule_stmt(YangParser.Module_stmtContext ctx) {
        YangParserListenerImpl.exitLog("module");
        this.stack.pop();
    }

    @Override
    public void enterSubmodule_stmt(YangParser.Submodule_stmtContext ctx) {
        this.moduleName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        LOG.trace("entering submodule {}", (Object)this.moduleName);
        YangParserListenerImpl.enterLog("submodule", this.moduleName, 0);
        this.stack.push();
        this.moduleBuilder = new ModuleBuilder(this.moduleName, true, this.sourcePath);
        String description = null;
        String reference = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                description = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                reference = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (description != null && reference != null) break;
        }
        this.moduleBuilder.setDescription(description);
        this.moduleBuilder.setReference(reference);
    }

    @Override
    public void exitSubmodule_stmt(YangParser.Submodule_stmtContext ctx) {
        YangParserListenerImpl.exitLog("submodule");
        this.stack.pop();
    }

    @Override
    public void enterBelongs_to_stmt(YangParser.Belongs_to_stmtContext ctx) {
        String belongsTo = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        NavigableMap<Date, URI> context = this.namespaceContext.get(belongsTo);
        Map.Entry<Date, URI> entry = context.firstEntry();
        this.moduleQName = QName.create((URI)entry.getValue(), (Date)entry.getKey(), (String)this.moduleQName.getLocalName());
        this.moduleBuilder.setQNameModule(this.moduleQName.getModule());
        this.moduleBuilder.setBelongsTo(belongsTo);
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree treeNode = ctx.getChild(i);
            if (!(treeNode instanceof YangParser.Prefix_stmtContext)) continue;
            this.yangModelPrefix = ParserListenerUtils.stringFromNode(treeNode);
            this.moduleBuilder.setPrefix(this.yangModelPrefix);
            YangParserListenerImpl.setLog("prefix", this.yangModelPrefix);
        }
    }

    @Override
    public void enterModule_header_stmts(YangParser.Module_header_stmtsContext ctx) {
        YangParserListenerImpl.enterLog("module_header", "", ctx.getStart().getLine());
        String yangVersion = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree treeNode = ctx.getChild(i);
            if (treeNode instanceof YangParser.Namespace_stmtContext) {
                String namespaceStr = ParserListenerUtils.stringFromNode(treeNode);
                URI namespace = URI.create(namespaceStr);
                this.moduleQName = QName.create((URI)namespace, (Date)this.moduleQName.getRevision(), (String)this.moduleQName.getLocalName());
                this.moduleBuilder.setQNameModule(this.moduleQName.getModule());
                YangParserListenerImpl.setLog("namespace", namespaceStr);
                continue;
            }
            if (treeNode instanceof YangParser.Prefix_stmtContext) {
                this.yangModelPrefix = ParserListenerUtils.stringFromNode(treeNode);
                this.moduleQName = QName.create((QNameModule)this.moduleQName.getModule(), (String)this.moduleQName.getLocalName());
                this.moduleBuilder.setPrefix(this.yangModelPrefix);
                YangParserListenerImpl.setLog("prefix", this.yangModelPrefix);
                continue;
            }
            if (!(treeNode instanceof YangParser.Yang_version_stmtContext)) continue;
            yangVersion = ParserListenerUtils.stringFromNode(treeNode);
            YangParserListenerImpl.setLog("yang-version", yangVersion);
        }
        if (yangVersion == null) {
            yangVersion = "1";
        }
        this.moduleBuilder.setYangVersion(yangVersion);
    }

    @Override
    public void exitModule_header_stmts(YangParser.Module_header_stmtsContext ctx) {
        YangParserListenerImpl.exitLog("module_header");
    }

    @Override
    public void enterMeta_stmts(YangParser.Meta_stmtsContext ctx) {
        YangParserListenerImpl.enterLog("meta_stmt", "", ctx.getStart().getLine());
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Organization_stmtContext) {
                String organization = ParserListenerUtils.stringFromNode(child);
                this.moduleBuilder.setOrganization(organization);
                YangParserListenerImpl.setLog("organization", organization);
                continue;
            }
            if (child instanceof YangParser.Contact_stmtContext) {
                String contact = ParserListenerUtils.stringFromNode(child);
                this.moduleBuilder.setContact(contact);
                YangParserListenerImpl.setLog("contact", contact);
                continue;
            }
            if (child instanceof YangParser.Description_stmtContext) {
                String description = ParserListenerUtils.stringFromNode(child);
                this.moduleBuilder.setDescription(description);
                YangParserListenerImpl.setLog("description", description);
                continue;
            }
            if (!(child instanceof YangParser.Reference_stmtContext)) continue;
            String reference = ParserListenerUtils.stringFromNode(child);
            this.moduleBuilder.setReference(reference);
            YangParserListenerImpl.setLog("reference", reference);
        }
    }

    @Override
    public void exitMeta_stmts(YangParser.Meta_stmtsContext ctx) {
        YangParserListenerImpl.exitLog("meta_stmt");
    }

    @Override
    public void enterRevision_stmts(YangParser.Revision_stmtsContext ctx) {
        YangParserListenerImpl.enterLog("revisions", "", ctx.getStart().getLine());
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree treeNode = ctx.getChild(i);
            if (!(treeNode instanceof YangParser.Revision_stmtContext)) continue;
            this.updateRevisionForRevisionStatement(treeNode);
        }
    }

    @Override
    public void exitRevision_stmts(YangParser.Revision_stmtsContext ctx) {
        YangParserListenerImpl.exitLog("revisions");
    }

    private void updateRevisionForRevisionStatement(ParseTree treeNode) {
        String revisionDateStr = ParserListenerUtils.stringFromNode(treeNode);
        try {
            Date revisionDate = this.revisionFormat.parse(revisionDateStr);
            if (revisionDate != null && this.moduleQName.getRevision().compareTo(revisionDate) < 0) {
                this.moduleQName = QName.create((URI)this.moduleQName.getNamespace(), (Date)revisionDate, (String)this.moduleQName.getLocalName());
                this.moduleBuilder.setQNameModule(this.moduleQName.getModule());
                YangParserListenerImpl.setLog("revision", revisionDate.toString());
                for (int i = 0; i < treeNode.getChildCount(); ++i) {
                    ParseTree child = treeNode.getChild(i);
                    if (!(child instanceof YangParser.Reference_stmtContext)) continue;
                    this.moduleBuilder.setReference(ParserListenerUtils.stringFromNode(child));
                }
            }
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse revision string: {}", (Object)revisionDateStr, (Object)e);
        }
    }

    @Override
    public void enterImport_stmt(YangParser.Import_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String importName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog(IMPORT_STR, importName, line);
        String importPrefix = null;
        Date importRevision = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree treeNode = ctx.getChild(i);
            if (treeNode instanceof YangParser.Prefix_stmtContext) {
                importPrefix = ParserListenerUtils.stringFromNode(treeNode);
                continue;
            }
            if (!(treeNode instanceof YangParser.Revision_date_stmtContext)) continue;
            String importRevisionStr = ParserListenerUtils.stringFromNode(treeNode);
            try {
                importRevision = this.revisionFormat.parse(importRevisionStr);
                continue;
            }
            catch (ParseException e) {
                LOG.warn("Failed to parse import revision-date at line {}: {}", new Object[]{line, importRevisionStr, e});
            }
        }
        this.moduleBuilder.addModuleImport(importName, importRevision, importPrefix);
        LOG.trace("setting import ({}; {}; {})", new Object[]{importName, importRevision, importPrefix});
    }

    @Override
    public void exitImport_stmt(YangParser.Import_stmtContext ctx) {
        YangParserListenerImpl.exitLog(IMPORT_STR);
    }

    @Override
    public void enterInclude_stmt(YangParser.Include_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String includeName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog(IMPORT_STR, includeName, line);
        Date includeRevision = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree treeNode = ctx.getChild(i);
            if (!(treeNode instanceof YangParser.Revision_date_stmtContext)) continue;
            String importRevisionStr = ParserListenerUtils.stringFromNode(treeNode);
            try {
                includeRevision = this.revisionFormat.parse(importRevisionStr);
                continue;
            }
            catch (ParseException e) {
                LOG.warn("Failed to parse import revision-date at line {}: {}", new Object[]{line, importRevisionStr, e});
            }
        }
        this.moduleBuilder.addInclude(includeName, includeRevision);
    }

    @Override
    public void exitInclude_stmt(YangParser.Include_stmtContext ctx) {
        YangParserListenerImpl.exitLog("include");
    }

    @Override
    public void enterAugment_stmt(YangParser.Augment_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String augmentPath = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog(AUGMENT_STR, augmentPath, line);
        this.stack.push();
        SchemaPath targetPath = this.parseXPathString(augmentPath, line);
        AugmentationSchemaBuilder builder = this.moduleBuilder.addAugment(line, augmentPath, targetPath, this.augmentOrder++);
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                builder.setDescription(ParserListenerUtils.stringFromNode(child));
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                builder.setReference(ParserListenerUtils.stringFromNode(child));
                continue;
            }
            if (child instanceof YangParser.Status_stmtContext) {
                builder.setStatus(ParserListenerUtils.parseStatus((YangParser.Status_stmtContext)child));
                continue;
            }
            if (!(child instanceof YangParser.When_stmtContext)) continue;
            builder.addWhenCondition(ParserListenerUtils.stringFromNode(child));
        }
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitAugment_stmt(YangParser.Augment_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog(AUGMENT_STR);
        this.stack.pop();
    }

    @Override
    public void enterExtension_stmt(YangParser.Extension_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String extName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("extension", extName, line);
        QName qname = QName.create((QName)this.moduleQName, (String)extName);
        SchemaPath path = this.stack.addNodeToPath(qname);
        ExtensionBuilder builder = this.moduleBuilder.addExtension(qname, line, path);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        String argument = null;
        boolean yin = false;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Argument_stmtContext)) continue;
            argument = ParserListenerUtils.stringFromNode(child);
            yin = ParserListenerUtils.parseYinValue((YangParser.Argument_stmtContext)child);
            break;
        }
        builder.setArgument(argument);
        builder.setYinElement(yin);
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitExtension_stmt(YangParser.Extension_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("extension", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterTypedef_stmt(YangParser.Typedef_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String typedefName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("typedef", typedefName, line);
        QName typedefQName = QName.create((QName)this.moduleQName, (String)typedefName);
        SchemaPath path = this.stack.addNodeToPath(typedefQName);
        TypeDefinitionBuilderImpl builder = this.moduleBuilder.addTypedef(line, typedefQName, path);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        builder.setUnits(ParserListenerUtils.parseUnits((ParseTree)ctx));
        builder.setDefaultValue(ParserListenerUtils.parseDefault((ParseTree)ctx));
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitTypedef_stmt(YangParser.Typedef_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("typedef", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterType_stmt(YangParser.Type_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String typeName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("type", typeName, line);
        QName typeQName = this.parseQName(typeName, line);
        YangParser.Type_body_stmtsContext typeBody = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (!(ctx.getChild(i) instanceof YangParser.Type_body_stmtsContext)) continue;
            typeBody = (YangParser.Type_body_stmtsContext)ctx.getChild(i);
            break;
        }
        if (BaseTypes.isYangBuildInType((String)typeName)) {
            if (typeBody == null) {
                ParserListenerUtils.checkMissingBody(typeName, this.moduleName, line);
                TypeDefinition type = (TypeDefinition)BaseTypes.defaultBaseTypeFor((String)typeName).orNull();
                this.stack.addNodeToPath(type.getQName());
                this.moduleBuilder.setType(type);
            } else {
                switch (typeName) {
                    case "union": {
                        this.stack.addNodeToPath(BaseTypes.UNION_QNAME);
                        UnionTypeBuilder unionBuilder = this.moduleBuilder.addUnionType(line, this.moduleQName.getModule());
                        Builder parentBuilder = this.moduleBuilder.getActualNode();
                        unionBuilder.setParent(parentBuilder);
                        this.moduleBuilder.enterNode(unionBuilder);
                        break;
                    }
                    case "identityref": {
                        QName qname = BaseTypes.IDENTITYREF_QNAME;
                        SchemaPath path = this.stack.addNodeToPath(qname);
                        this.moduleBuilder.addIdentityrefType(line, path, ParserListenerUtils.getIdentityrefBase(typeBody));
                        break;
                    }
                    default: {
                        TypeDefinition<?> type = ParserListenerUtils.parseTypeWithBody(typeName, typeBody, this.stack.currentSchemaPath(), this.moduleQName, this.moduleBuilder.getActualNode());
                        this.moduleBuilder.setType(type);
                        this.stack.addNodeToPath(type.getQName());
                        break;
                    }
                }
            }
        } else {
            TypeAwareBuilder parent = (TypeAwareBuilder)this.moduleBuilder.getActualNode();
            if (typeBody == null) {
                parent.setTypeQName(typeQName);
                this.moduleBuilder.markActualNodeDirty();
            } else {
                ParserListenerUtils.parseUnknownTypeWithBody(typeBody, parent, typeQName, this.moduleBuilder, this.moduleQName, this.stack.currentSchemaPath());
            }
            this.stack.addNodeToPath(QName.create((QNameModule)this.moduleQName.getModule(), (String)typeQName.getLocalName()));
        }
    }

    private QName parseQName(String qnameString, int line) {
        QName qname;
        if (qnameString.indexOf(58) == -1) {
            qname = QName.create((QName)this.moduleQName, (String)qnameString);
        } else {
            Iterator split = COLON_SPLITTER.split((CharSequence)qnameString).iterator();
            String prefix = (String)split.next();
            String name = (String)split.next();
            if (prefix.equals(this.moduleBuilder.getPrefix())) {
                qname = QName.create((QName)this.moduleQName, (String)name);
            } else {
                URI namespace;
                ModuleImport imp = this.moduleBuilder.getImport(prefix);
                if (imp == null) {
                    LOG.debug("Error in module {} at line {}: No import found with prefix {}", new Object[]{this.moduleName, line, prefix});
                    throw new YangParseException(this.moduleName, line, "Error in module " + this.moduleName + " No import found with prefix " + prefix + " not found.");
                }
                Date revision = imp.getRevision();
                NavigableMap<Date, URI> namespaces = this.namespaceContext.get(imp.getModuleName());
                if (namespaces == null) {
                    throw new YangParseException(this.moduleName, line, String.format("Imported module %s not found", imp.getModuleName()));
                }
                if (revision == null) {
                    revision = namespaces.lastEntry().getKey();
                    namespace = namespaces.lastEntry().getValue();
                } else {
                    namespace = (URI)namespaces.get(revision);
                }
                QNameModule mod = QNameModule.cachedReference((QNameModule)QNameModule.create((URI)namespace, (Date)revision));
                qname = QName.create((QNameModule)mod, (String)name);
            }
        }
        return qname;
    }

    @Override
    public void exitType_stmt(YangParser.Type_stmtContext ctx) {
        String typeName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        if (UNION_STR.equals(typeName)) {
            this.moduleBuilder.exitNode();
        }
        YangParserListenerImpl.exitLog("type", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterGrouping_stmt(YangParser.Grouping_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String groupName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("grouping", groupName, line);
        QName groupQName = QName.create((QName)this.moduleQName, (String)groupName);
        SchemaPath path = this.stack.addNodeToPath(groupQName);
        GroupingBuilder builder = this.moduleBuilder.addGrouping(ctx.getStart().getLine(), groupQName, path);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitGrouping_stmt(YangParser.Grouping_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("grouping", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterContainer_stmt(YangParser.Container_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String containerName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("container", containerName, line);
        QName containerQName = QName.create((QName)this.moduleQName, (String)containerName);
        SchemaPath path = this.stack.addNodeToPath(containerQName);
        ContainerSchemaNodeBuilder builder = this.moduleBuilder.addContainerNode(line, containerQName, path);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, builder, this.moduleName, line));
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree childNode = ctx.getChild(i);
            if (!(childNode instanceof YangParser.Presence_stmtContext)) continue;
            builder.setPresence(true);
            break;
        }
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitContainer_stmt(YangParser.Container_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("container", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterLeaf_stmt(YangParser.Leaf_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String leafName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("leaf", leafName, line);
        QName leafQName = QName.create((QName)this.moduleQName, (String)leafName);
        SchemaPath path = this.stack.addNodeToPath(leafQName);
        LeafSchemaNodeBuilder builder = this.moduleBuilder.addLeafNode(line, leafQName, path);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, builder, this.moduleName, line));
        String defaultStr = null;
        String unitsStr = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Default_stmtContext) {
                defaultStr = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (!(child instanceof YangParser.Units_stmtContext)) continue;
            unitsStr = ParserListenerUtils.stringFromNode(child);
        }
        builder.setDefaultStr(defaultStr);
        builder.setUnits(unitsStr);
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitLeaf_stmt(YangParser.Leaf_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("leaf", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterUses_stmt(YangParser.Uses_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String groupingPathStr = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        SchemaPath groupingPath = this.parseXPathString(groupingPathStr, line);
        YangParserListenerImpl.enterLog("uses", groupingPathStr, line);
        UsesNodeBuilder builder = this.moduleBuilder.addUsesNode(line, groupingPath);
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitUses_stmt(YangParser.Uses_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("uses");
    }

    @Override
    public void enterUses_augment_stmt(YangParser.Uses_augment_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String augmentPath = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog(AUGMENT_STR, augmentPath, line);
        this.stack.push();
        SchemaPath targetPath = this.parseXPathString(augmentPath, line);
        AugmentationSchemaBuilder builder = this.moduleBuilder.addAugment(line, augmentPath, targetPath, this.augmentOrder++);
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                builder.setDescription(ParserListenerUtils.stringFromNode(child));
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                builder.setReference(ParserListenerUtils.stringFromNode(child));
                continue;
            }
            if (child instanceof YangParser.Status_stmtContext) {
                builder.setStatus(ParserListenerUtils.parseStatus((YangParser.Status_stmtContext)child));
                continue;
            }
            if (!(child instanceof YangParser.When_stmtContext)) continue;
            builder.addWhenCondition(ParserListenerUtils.stringFromNode(child));
        }
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitUses_augment_stmt(YangParser.Uses_augment_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog(AUGMENT_STR);
        this.stack.pop();
    }

    @Override
    public void enterRefine_stmt(YangParser.Refine_stmtContext ctx) {
        String refineString = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("refine", refineString, ctx.getStart().getLine());
        RefineHolderImpl refine = ParserListenerUtils.parseRefine(ctx, this.moduleName);
        this.moduleBuilder.addRefine(refine);
        this.moduleBuilder.enterNode(refine);
    }

    @Override
    public void exitRefine_stmt(YangParser.Refine_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("refine");
    }

    @Override
    public void enterLeaf_list_stmt(YangParser.Leaf_list_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String leafListName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("leaf-list", leafListName, line);
        QName leafListQName = QName.create((QName)this.moduleQName, (String)leafListName);
        SchemaPath path = this.stack.addNodeToPath(leafListQName);
        LeafListSchemaNodeBuilder builder = this.moduleBuilder.addLeafListNode(line, leafListQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, builder, this.moduleName, ctx.getStart().getLine()));
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree childNode = ctx.getChild(i);
            if (!(childNode instanceof YangParser.Ordered_by_stmtContext)) continue;
            YangParser.Ordered_by_stmtContext orderedBy = (YangParser.Ordered_by_stmtContext)childNode;
            boolean userOrdered = ParserListenerUtils.parseUserOrdered(orderedBy);
            builder.setUserOrdered(userOrdered);
            break;
        }
    }

    @Override
    public void exitLeaf_list_stmt(YangParser.Leaf_list_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("leaf-list", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterList_stmt(YangParser.List_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String listName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("list", listName, line);
        QName listQName = QName.create((QName)this.moduleQName, (String)listName);
        SchemaPath path = this.stack.addNodeToPath(listQName);
        ListSchemaNodeBuilder builder = this.moduleBuilder.addListNode(line, listQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, builder, this.moduleName, line));
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree childNode = ctx.getChild(i);
            if (childNode instanceof YangParser.Ordered_by_stmtContext) {
                YangParser.Ordered_by_stmtContext orderedBy = (YangParser.Ordered_by_stmtContext)childNode;
                boolean userOrdered = ParserListenerUtils.parseUserOrdered(orderedBy);
                builder.setUserOrdered(userOrdered);
                continue;
            }
            if (childNode instanceof YangParser.Key_stmtContext) {
                Set<String> key = ParserListenerUtils.createListKey((YangParser.Key_stmtContext)childNode);
                builder.setKeys(key);
                continue;
            }
            if (!(childNode instanceof YangParser.Identifier_stmtContext) || !UNION_STR.equals(childNode.getChild(0).toString())) continue;
            throw new YangParseException(this.moduleName, line, "Union statement is not allowed inside a list statement");
        }
    }

    @Override
    public void exitList_stmt(YangParser.List_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("list", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterAnyxml_stmt(YangParser.Anyxml_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String anyXmlName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("anyxml", anyXmlName, line);
        QName anyXmlQName = QName.create((QName)this.moduleQName, (String)anyXmlName);
        SchemaPath path = this.stack.addNodeToPath(anyXmlQName);
        AnyXmlBuilder builder = this.moduleBuilder.addAnyXml(line, anyXmlQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, builder, this.moduleName, line));
    }

    @Override
    public void exitAnyxml_stmt(YangParser.Anyxml_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("anyxml", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterChoice_stmt(YangParser.Choice_stmtContext ctx) {
        int i;
        int line = ctx.getStart().getLine();
        String choiceName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("choice", choiceName, line);
        QName choiceQName = QName.create((QName)this.moduleQName, (String)choiceName);
        SchemaPath path = this.stack.addNodeToPath(choiceQName);
        ChoiceBuilder builder = this.moduleBuilder.addChoice(line, choiceQName, path);
        this.moduleBuilder.enterNode(builder);
        for (i = 0; i < this.moduleBuilder.getAllAugments().size(); ++i) {
            ArrayList<DataSchemaNodeBuilder> found = new ArrayList<DataSchemaNodeBuilder>();
            AugmentationSchemaBuilder augment = this.moduleBuilder.getAllAugments().get(i);
            if (augment.getTargetPath().getLastComponent().equals((Object)choiceQName)) {
                for (int j = 0; j < augment.getChildNodeBuilders().size(); ++j) {
                    SchemaNodeBuilder addedChildNode = augment.getChildNodeBuilders().get(j);
                    if (addedChildNode instanceof ChoiceCaseBuilder || !(addedChildNode instanceof DataSchemaNodeBuilder)) continue;
                    QName caseQName = QName.create((QName)this.moduleQName, (String)addedChildNode.getQName().getLocalName().concat("Case"));
                    ChoiceCaseBuilder choiceCaseBuilder = (ChoiceCaseBuilder)CopyUtils.copy((DataSchemaNodeBuilder)new ChoiceCaseBuilder(this.moduleName, addedChildNode.getLine(), caseQName, addedChildNode.getPath().getParent().createChild(new QName[]{caseQName})), (Builder)augment, false);
                    augment.addChildNode(choiceCaseBuilder);
                    choiceCaseBuilder.addChildNode(CopyUtils.copy((DataSchemaNodeBuilder)addedChildNode, (Builder)choiceCaseBuilder, false));
                    found.add((DataSchemaNodeBuilder)addedChildNode);
                }
            }
            if (found.isEmpty()) continue;
            augment.getChildNodeBuilders().removeAll(found);
        }
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, builder, this.moduleName, line));
        for (i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Default_stmtContext)) continue;
            String defaultCase = ParserListenerUtils.stringFromNode(child);
            builder.setDefaultCase(defaultCase);
            break;
        }
    }

    @Override
    public void exitChoice_stmt(YangParser.Choice_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("choice", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterCase_stmt(YangParser.Case_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String caseName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("case", caseName, line);
        QName caseQName = QName.create((QName)this.moduleQName, (String)caseName);
        SchemaPath path = this.stack.addNodeToPath(caseQName);
        ChoiceCaseBuilder builder = this.moduleBuilder.addCase(line, caseQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
    }

    @Override
    public void exitCase_stmt(YangParser.Case_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("case", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterNotification_stmt(YangParser.Notification_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String notificationName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("notification", notificationName, line);
        QName notificationQName = QName.create((QName)this.moduleQName, (String)notificationName);
        SchemaPath path = this.stack.addNodeToPath(notificationQName);
        NotificationBuilder builder = this.moduleBuilder.addNotification(line, notificationQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
    }

    @Override
    public void exitNotification_stmt(YangParser.Notification_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("notification", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterIdentifier_stmt(YangParser.Identifier_stmtContext ctx) {
        this.handleUnknownNode(ctx.getStart().getLine(), (ParseTree)ctx);
    }

    @Override
    public void exitIdentifier_stmt(YangParser.Identifier_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog(UNKNOWN_NODE_STR, this.stack.removeNodeFromPath());
    }

    @Override
    public void enterUnknown_statement(YangParser.Unknown_statementContext ctx) {
        this.handleUnknownNode(ctx.getStart().getLine(), (ParseTree)ctx);
    }

    @Override
    public void exitUnknown_statement(YangParser.Unknown_statementContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog(UNKNOWN_NODE_STR, this.stack.removeNodeFromPath());
    }

    @Override
    public void enterRpc_stmt(YangParser.Rpc_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String rpcName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("rpc", rpcName, line);
        QName rpcQName = QName.create((QName)this.moduleQName, (String)rpcName);
        SchemaPath path = this.stack.addNodeToPath(rpcQName);
        RpcDefinitionBuilder rpcBuilder = this.moduleBuilder.addRpc(line, rpcQName, path);
        this.moduleBuilder.enterNode(rpcBuilder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, rpcBuilder);
    }

    @Override
    public void exitRpc_stmt(YangParser.Rpc_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("rpc", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterInput_stmt(YangParser.Input_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String input = "input";
        YangParserListenerImpl.enterLog("input", "input", line);
        QName rpcQName = QName.create((QName)this.moduleQName, (String)"input");
        SchemaPath path = this.stack.addNodeToPath(rpcQName);
        ContainerSchemaNodeBuilder builder = this.moduleBuilder.addRpcInput(line, rpcQName, path);
        this.moduleBuilder.enterNode(builder);
        builder.setConfiguration(true);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
    }

    @Override
    public void exitInput_stmt(YangParser.Input_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("input", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterOutput_stmt(YangParser.Output_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String output = "output";
        YangParserListenerImpl.enterLog("output", "output", line);
        QName rpcQName = QName.create((QName)this.moduleQName, (String)"output");
        SchemaPath path = this.stack.addNodeToPath(rpcQName);
        ContainerSchemaNodeBuilder builder = this.moduleBuilder.addRpcOutput(path, rpcQName, line);
        this.moduleBuilder.enterNode(builder);
        builder.setConfiguration(true);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
    }

    @Override
    public void exitOutput_stmt(YangParser.Output_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("output", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterFeature_stmt(YangParser.Feature_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String featureName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("feature", featureName, line);
        QName featureQName = QName.create((QName)this.moduleQName, (String)featureName);
        SchemaPath path = this.stack.addNodeToPath(featureQName);
        FeatureBuilder featureBuilder = this.moduleBuilder.addFeature(line, featureQName, path);
        this.moduleBuilder.enterNode(featureBuilder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, featureBuilder);
    }

    @Override
    public void exitFeature_stmt(YangParser.Feature_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("feature", this.stack.removeNodeFromPath());
    }

    @Override
    public void enterDeviation_stmt(YangParser.Deviation_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String targetPathStr = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        if (!targetPathStr.startsWith("/")) {
            throw new YangParseException(this.moduleName, line, "Deviation argument string must be an absolute schema node identifier.");
        }
        YangParserListenerImpl.enterLog("deviation", targetPathStr, line);
        String reference = null;
        String deviate = null;
        SchemaPath targetPath = this.parseXPathString(targetPathStr, line);
        DeviationBuilder builder = this.moduleBuilder.addDeviation(line, targetPath);
        this.moduleBuilder.enterNode(builder);
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Reference_stmtContext) {
                reference = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Deviate_not_supported_stmtContext) {
                deviate = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Deviate_add_stmtContext) {
                deviate = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Deviate_replace_stmtContext) {
                deviate = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (!(child instanceof YangParser.Deviate_delete_stmtContext)) continue;
            deviate = ParserListenerUtils.stringFromNode(child);
        }
        builder.setReference(reference);
        builder.setDeviate(deviate);
    }

    public SchemaPath parseXPathString(String xpathString, int line) {
        boolean absolute = !xpathString.isEmpty() && xpathString.charAt(0) == '/';
        ArrayList<QName> path = new ArrayList<QName>();
        for (String pathElement : SLASH_SPLITTER.split((CharSequence)xpathString)) {
            Iterator it = COLON_SPLITTER.split((CharSequence)pathElement).iterator();
            String s = (String)it.next();
            if (it.hasNext()) {
                path.add(this.parseQName(pathElement, line));
                continue;
            }
            path.add(QName.create((QName)this.moduleQName, (String)s));
        }
        return SchemaPath.create(path, (boolean)absolute);
    }

    @Override
    public void exitDeviation_stmt(YangParser.Deviation_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("deviation");
    }

    @Override
    public void enterIdentity_stmt(YangParser.Identity_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String identityName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        YangParserListenerImpl.enterLog("identity", identityName, line);
        QName identityQName = QName.create((QName)this.moduleQName, (String)identityName);
        SchemaPath path = this.stack.addNodeToPath(identityQName);
        IdentitySchemaNodeBuilder builder = this.moduleBuilder.addIdentity(identityQName, line, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Base_stmtContext)) continue;
            String baseIdentityName = ParserListenerUtils.stringFromNode(child);
            builder.setBaseIdentityName(baseIdentityName);
        }
    }

    @Override
    public void exitIdentity_stmt(YangParser.Identity_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        YangParserListenerImpl.exitLog("identity", this.stack.removeNodeFromPath());
    }

    public ModuleBuilder getModuleBuilder() {
        return this.moduleBuilder;
    }

    private static void enterLog(String p1, String p2, int line) {
        LOG.trace("entering {} {} ({})", new Object[]{p1, p2, line});
    }

    private static void exitLog(String p1) {
        LOG.trace("exiting {}", (Object)p1);
    }

    private static void exitLog(String p1, QName p2) {
        LOG.trace("exiting {} {}", (Object)p1, (Object)p2.getLocalName());
    }

    private static void setLog(String p1, String p2) {
        LOG.trace("setting {} {}", (Object)p1, (Object)p2);
    }

    private void handleUnknownNode(int line, ParseTree ctx) {
        String nodeParameter = ParserListenerUtils.stringFromNode(ctx);
        YangParserListenerImpl.enterLog(UNKNOWN_NODE_STR, nodeParameter, line);
        String nodeTypeStr = ctx.getChild(0).getText();
        QName nodeType = this.parseQName(nodeTypeStr, line);
        QName qname = null;
        try {
            if (Strings.isNullOrEmpty((String)nodeParameter)) {
                qname = nodeType;
            } else {
                Iterable splittedName = COLON_SPLITTER.split((CharSequence)nodeParameter);
                Iterator it = splittedName.iterator();
                qname = Iterables.size((Iterable)splittedName) == 2 ? this.parseQName(nodeParameter, line) : QName.create((QName)this.moduleQName, (String)((String)it.next()));
            }
        }
        catch (IllegalArgumentException | YangParseException ex) {
            qname = nodeType;
        }
        SchemaPath path = this.stack.addNodeToPath(qname);
        UnknownSchemaNodeBuilderImpl builder = this.moduleBuilder.addUnknownSchemaNode(line, qname, path);
        builder.setNodeType(nodeType);
        builder.setNodeParameter(nodeParameter);
        ParserListenerUtils.parseSchemaNodeArgs(ctx, builder);
        this.moduleBuilder.enterNode(builder);
    }
}

