/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opendaylight.yangtools.antlrv4.code.gen.YangStatementParser;
import org.opendaylight.yangtools.antlrv4.code.gen.YangStatementParserBaseListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class YangStatementParserListenerImpl
extends YangStatementParserBaseListener {
    private StatementWriter writer;
    private StatementSourceReference ref;
    private QNameToStatementDefinition stmtDef;
    private PrefixToModule prefixes;
    private List<String> toBeSkipped = new ArrayList<String>();
    private static final Logger LOG = LoggerFactory.getLogger(YangStatementParserListenerImpl.class);

    public YangStatementParserListenerImpl(StatementSourceReference ref) {
        this.ref = ref;
    }

    public void setAttributes(StatementWriter writer, QNameToStatementDefinition stmtDef) {
        this.writer = writer;
        this.stmtDef = stmtDef;
    }

    public void setAttributes(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule prefixes) {
        this.writer = writer;
        this.stmtDef = stmtDef;
        this.prefixes = prefixes;
    }

    @Override
    public void enterStatement(YangStatementParser.StatementContext ctx) {
        boolean action = true;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangStatementParser.KeywordContext) {
                try {
                    QName identifier = new QName(YangConstants.RFC6020_YIN_NAMESPACE, ((ParseTree)((YangStatementParser.KeywordContext)child).children.get(0)).getText());
                    if (this.stmtDef != null && Utils.isValidStatementDefinition(this.prefixes, this.stmtDef, identifier) && this.toBeSkipped.isEmpty()) {
                        this.writer.startStatement(identifier, this.ref);
                        continue;
                    }
                    action = false;
                    this.toBeSkipped.add(((ParseTree)((YangStatementParser.KeywordContext)child).children.get(0)).getText());
                }
                catch (SourceException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (!(child instanceof YangStatementParser.ArgumentContext)) continue;
            try {
                if (action) {
                    this.writer.argumentValue(Utils.stringFromStringContext((YangStatementParser.ArgumentContext)child), this.ref);
                    continue;
                }
                action = true;
                continue;
            }
            catch (SourceException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void exitStatement(YangStatementParser.StatementContext ctx) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangStatementParser.KeywordContext)) continue;
            try {
                String statementName = ((ParseTree)((YangStatementParser.KeywordContext)child).children.get(0)).getText();
                QName identifier = new QName(YangConstants.RFC6020_YIN_NAMESPACE, statementName);
                if (this.stmtDef != null && Utils.isValidStatementDefinition(this.prefixes, this.stmtDef, identifier) && this.toBeSkipped.isEmpty()) {
                    this.writer.endStatement(this.ref);
                }
                if (!this.toBeSkipped.contains(statementName)) continue;
                this.toBeSkipped.remove(statementName);
                continue;
            }
            catch (SourceException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

